/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.behaviours.TertiaryStructureRefinementAnswerBehaviour;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.tools.AbstractParadiseToolAgent;
import jade.gui.GuiEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RnartDialog
extends JDialog {
    private JTextField thres = new JTextField();
    private JComboBox mod = new JComboBox<Object>(new Object[]{"Number of passes (ex : 10)", "Average RMSD treshold (ex : 0.2)", "Similarity between 2 successive RMSD (in %, ex : 95)"});

    public RnartDialog(final Mediator mediator, final Collection<Molecule> molecules) {
        this.setTitle("Rnart Parameters");
        JButton ok = new JButton("Ok");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                    String mode = "";
                    switch (RnartDialog.this.mod.getSelectedIndex()) {
                        case 0: {
                            mode = "n";
                            Integer.parseInt(RnartDialog.this.thres.getText());
                            break;
                        }
                        case 1: {
                            mode = "v";
                            Float.parseFloat(RnartDialog.this.thres.getText());
                            break;
                        }
                        case 2: {
                            mode = "p";
                            Integer.parseInt(RnartDialog.this.thres.getText());
                        }
                    }
                    parameters.add(new Parameter("mode", mode));
                    parameters.add(new Parameter("threshold", RnartDialog.this.thres.getText()));
                    GuiEvent ev = new GuiEvent((Object)this, 6);
                    ev.addParameter((Object)new TertiaryStructureRefinementAnswerBehaviour(new ArrayList<Molecule>(molecules), parameters));
                    ((AbstractParadiseToolAgent)mediator.getAssemble().getAgent()).postGuiEvent(ev);
                    RnartDialog.this.dispose();
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, "The value you entered is not a number");
                }
            }
        });
        JLabel warning = new JLabel("Warning ! This operation can take a LONG time !");
        warning.setForeground(Color.RED);
        String listMol = "<html>About to refine the following molecules <ul>";
        for (Molecule m : molecules) {
            listMol = listMol + "<li>" + m + "</li>";
        }
        listMol = listMol + "</ul></html>";
        JLabel list = new JLabel(listMol);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(list);
        JPanel center = new JPanel();
        center.setLayout(new GridLayout(2, 2));
        center.add(new JLabel("Choose the stop condition of the Rnart algorithm"));
        center.add(warning);
        center.add(this.mod);
        center.add(this.thres);
        this.getContentPane().add(center);
        JPanel button = new JPanel();
        button.setLayout(new BorderLayout());
        button.add((Component)ok, "East");
        this.getContentPane().add(button);
        this.pack();
        this.setVisible(true);
    }
}

