/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.AssembleAgent;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.utils.AssembleConfig;
import fr.unistra.ibmc.assemble.utils.RessourcesUtils;
import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.services.ParadisePlatform;
import fr.unistra.ibmc.paradise.goloka.tools.ConnectionException;
import fr.unistra.ibmc.paradise.goloka.tools.IncompatibilityException;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.goloka.utils.GeneralUtils;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdesktop.swingworker.SwingWorker;

public class SplashScreen
extends JFrame {
    private JLabel label;

    public SplashScreen() {
        this.repaint();
        this.setUndecorated(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        ImageIcon icon = new ImageIcon(RessourcesUtils.getImage("logo.png"));
        this.add((Component)new JLabel(icon), "North");
        this.label = new JLabel("Assemble 1.0, Release Candidate 1");
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        labelPanel.setBackground(Color.WHITE);
        labelPanel.add(this.label);
        this.add((Component)labelPanel, "South");
        final JComboBox<String> addressField = new JComboBox<String>(AssembleConfig.getPlatformAddresses());
        addressField.addItem("Register new address...");
        addressField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String newAddress;
                if ("Register new address...".equals(((JComboBox)event.getSource()).getSelectedItem()) && (newAddress = JOptionPane.showInputDialog("Please enter the new address")) != null && newAddress.length() != 0) {
                    AssembleConfig.addPlatformAddress(newAddress);
                    addressField.removeAllItems();
                    for (String address : AssembleConfig.getPlatformAddresses()) {
                        addressField.addItem(address);
                    }
                    addressField.addItem("Register new address...");
                    addressField.setSelectedItem(newAddress);
                }
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBackground(Color.WHITE);
        JButton cancelButton = new JButton("Don't Connect");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    JOptionPane.showMessageDialog(null, "Using the disconnected mode, several functions of Assemble will be inactivated.");
                    Assemble assemble = new Assemble(new ParadiseWorkingSession(null));
                    assemble.startup();
                    SplashScreen.this.dispose();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (ControllerException e) {
                    e.printStackTrace();
                }
                catch (ConnectionException e) {
                    e.printStackTrace();
                }
                catch (IncompatibilityException e) {
                    e.printStackTrace();
                }
            }
        });
        final JButton okButton = new JButton("Connect");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                final String platformAddress = (String)addressField.getSelectedItem();
                okButton.setEnabled(false);
                addressField.setEnabled(false);
                new SwingWorker(){

                    protected Object doInBackground() {
                        try {
                            if (!platformAddress.equals("localhost")) {
                                SplashScreen.this.label.setText("Try to connect to " + platformAddress);
                                SplashScreen.this.label.setText("GUI started...");
                                new AssembleAgent(new ParadiseWorkingSession(platformAddress));
                            } else {
                                String osArch;
                                String osName = System.getProperty("os.name");
                                if (!Paradise.isSupported((String)osName, (String)(osArch = System.getProperty("os.arch")))) {
                                    JOptionPane.showMessageDialog(null, "Your computer's architecture is not compatible with the RNA algorithms of Assemble.\n Several functions will be inactivated.");
                                    Assemble assemble = new Assemble(new ParadiseWorkingSession(null));
                                    assemble.startup();
                                } else {
                                    SplashScreen.this.label.setText("Platform started...");
                                    ParadisePlatform.launchParadisePlatform();
                                    SplashScreen.this.label.setText("GUI started...");
                                    new AssembleAgent(new ParadiseWorkingSession(platformAddress));
                                }
                            }
                            SplashScreen.this.dispose();
                        }
                        catch (StaleProxyException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "Problem to connect to " + platformAddress);
                        }
                        catch (UnknownHostException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "Problem to connect to " + platformAddress);
                        }
                        catch (ConnectionException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "Problem to connect to " + platformAddress);
                        }
                        catch (ControllerException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "Problem to connect to " + platformAddress);
                        }
                        catch (IncompatibilityException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "The " + platformAddress + " platform is not up to date with your Assemble version. Contact its administrator to update it.");
                            this.done();
                        }
                        return null;
                    }
                }.execute();
            }
        });
        buttonsPanel.add(addressField);
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        this.add((Component)buttonsPanel, "Center");
        this.pack();
        GeneralUtils.centerOnScreen((Window)this);
        this.setVisible(true);
        this.toFront();
    }

    public void updateText(String message) {
        this.label.setText(message);
    }
}

