/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui.labels;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.labels.AbstractLabel;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomLabel
extends AbstractLabel {
    public Atom atom = null;

    public AtomLabel(Mediator mediator, Atom a) {
        super(mediator);
        this.color = new OpenGLColor(Color.white);
        this.atom = a;
        a.addAtomListener(this);
        this.compute();
    }

    @Override
    public List<Atom> getAtoms() {
        return new ArrayList<Atom>(Arrays.asList(this.atom));
    }

    @Override
    void compute() {
        this.position = this.atom.getFloat();
        this.value = this.atom.getName();
    }

    @Override
    public void draw(GL gl) {
        this.compute();
        this.color.setR(255 - this.mediator.getRenderer().getBackgroundColor().getR());
        this.color.setG(255 - this.mediator.getRenderer().getBackgroundColor().getG());
        this.color.setB(255 - this.mediator.getRenderer().getBackgroundColor().getB());
        super.draw(gl);
    }
}

