/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui.labels;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.labels.AbstractLabel;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.paradise.goloka.utils.TBMath;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DihedralLabel
extends AbstractLabel {
    public Atom firstAtom = null;
    public Atom secondAtom = null;
    public Atom thirdAtom = null;
    public Atom fourthAtom = null;

    public DihedralLabel(Mediator mediator, Atom a, Atom b, Atom c, Atom d) {
        super(mediator);
        this.color = new OpenGLColor(Color.orange);
        this.firstAtom = a;
        this.secondAtom = b;
        this.thirdAtom = c;
        this.fourthAtom = d;
        a.addAtomListener(this);
        b.addAtomListener(this);
        c.addAtomListener(this);
        d.addAtomListener(this);
        this.compute();
    }

    @Override
    public List<Atom> getAtoms() {
        return new ArrayList<Atom>(Arrays.asList(this.firstAtom, this.secondAtom, this.thirdAtom, this.fourthAtom));
    }

    @Override
    void compute() {
        for (int i = 0; i < 3; ++i) {
            this.position[i] = (this.firstAtom.getFloat()[i] + this.secondAtom.getFloat()[i] + this.thirdAtom.getFloat()[i] + this.fourthAtom.getFloat()[i]) / 4.0f;
        }
        double tmp = (double)TBMath.dihedral((float[])this.firstAtom.getFloat(), (float[])this.secondAtom.getFloat(), (float[])this.thirdAtom.getFloat(), (float[])this.fourthAtom.getFloat()) * TBMath.RadianToDegree;
        this.value = "" + tmp;
        this.value = this.value.substring(0, this.value.lastIndexOf(".") + 4);
        this.value = this.value + "\u00b0";
    }

    @Override
    public void draw(GL gl) {
        super.draw(gl);
        gl.glLineStipple(1, (short)-6751);
        gl.glBegin(1);
        gl.glVertex3fv(this.firstAtom.getFloat(), 0);
        gl.glVertex3fv(this.secondAtom.getFloat(), 0);
        gl.glVertex3fv(this.secondAtom.getFloat(), 0);
        gl.glVertex3fv(this.thirdAtom.getFloat(), 0);
        gl.glVertex3fv(this.thirdAtom.getFloat(), 0);
        gl.glVertex3fv(this.fourthAtom.getFloat(), 0);
        gl.glEnd();
    }
}

