/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residues2DRepository;
import fr.unistra.ibmc.assemble.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.assemble.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.utils.DrawingUtils;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Helix;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helix2D
extends StructuralDomain2D {
    Set<BaseBaseInteraction2D> secondaryInteractions = new TreeSet<BaseBaseInteraction2D>(new Comparator(){

        public int compare(Object o1, Object o2) {
            BaseBaseInteraction bb1 = ((BaseBaseInteraction2D)o1).getBaseBaseInteractionFeature();
            BaseBaseInteraction bb2 = ((BaseBaseInteraction2D)o2).getBaseBaseInteractionFeature();
            return new Integer(bb1.getResidue().getAbsolutePosition()).compareTo(bb2.getResidue().getAbsolutePosition());
        }
    });
    public static final Color DEFAULT_COLOR = Color.BLUE;
    private Point2D middle;
    private Point2D perpendicular;
    public double dx;
    public double dy;
    public boolean fixed;
    private Area area;

    public Helix2D(Helix h, Residues2DRepository repository, Mediator mediator, GraphicContext gc) {
        super((StructuralDomain)h, repository, mediator, gc);
        for (BaseBaseInteraction inter : h.getAllBaseBaseInteractions()) {
            this.secondaryInteractions.add(BaseBaseInteraction2D.getInteraction(inter, this.repository, mediator, gc));
        }
        this.setColor(DEFAULT_COLOR);
        for (Residue2D r : this.getAllResidues()) {
            r.setStructuralDomain(this);
        }
    }

    public Helix getHelixFeature() {
        return (Helix)this.structuralDomain;
    }

    @Override
    public List<Residue2D> getAllResidues() {
        ArrayList<Residue2D> residues = new ArrayList<Residue2D>(this.getLength());
        for (Residue r : this.getHelixFeature().getResidues().getAllResidues()) {
            residues.add(this.repository.getResidue(r));
        }
        return residues;
    }

    public Residue2D get5PrimeEnd(Residue2D _3PrimeEnd) {
        return this.repository.getResidue(this.getHelixFeature().get5PrimeEnd((Residue)_3PrimeEnd.getResidue2DFeature().getResidues().iterator().next()));
    }

    public Residue2D get3PrimeEnd(Residue2D _5PrimeEnd) {
        return this.repository.getResidue(this.getHelixFeature().get3PrimeEnd((Residue)_5PrimeEnd.getResidue2DFeature().getResidues().iterator().next()));
    }

    public Residue2D getPairedResidue(Residue2D r) {
        for (BaseBaseInteraction2D interaction : this.secondaryInteractions) {
            if (this.repository.getResidue(interaction.getBaseBaseInteractionFeature().getResidue()).equals(r)) {
                return this.repository.getResidue(interaction.getBaseBaseInteractionFeature().getPartnerResidue());
            }
            if (!this.repository.getResidue(interaction.getBaseBaseInteractionFeature().getPartnerResidue()).equals(r)) continue;
            return this.repository.getResidue(interaction.getBaseBaseInteractionFeature().getResidue());
        }
        return null;
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.isInsideDrawingArea()) {
            if (this.isSelected()) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(this.color);
            }
            for (BaseBaseInteraction2D inter : this.secondaryInteractions) {
                inter.draw(g2);
            }
            for (Residue2D r : this.getAllResidues()) {
                r.draw(g2);
            }
            if (this.gc.isLabelsDisplayed()) {
                g2.setColor(Color.GRAY);
                int middle = (this.getLength() + 1) / 2;
                Residue2D _5PrimeEnd = this.get5PrimeEnds()[0];
                Residue2D _3PrimeEnd = this.get3PrimeEnd(_5PrimeEnd);
                if ((_5PrimeEnd.getAbsolutePosition() + middle - 1) % 5 == 0 && (_3PrimeEnd.getAbsolutePosition() - middle + 1) % 5 == 0) {
                    middle = this.getLength() > 3 ? (middle += 2) : ++middle;
                }
                Residue2D r1 = this.getResidue(_5PrimeEnd.getAbsolutePosition() + middle - 1);
                Residue2D r2 = this.getResidue(_3PrimeEnd.getAbsolutePosition() - middle + 1);
                FontMetrics fm = g2.getFontMetrics(g2.getFont());
                Point2D[] points = DrawingUtils.fit(r1.getCurrentCenter(), r2.getCurrentCenter(), -(this.gc.getCurrentHalf() + (double)(fm.stringWidth(this.getLabel()) / 2)));
                Residue2D _5_0 = this.get5PrimeEnds()[0];
                Residue2D _3_1 = this.get3PrimeEnds()[1];
                for (int i = 1; i <= this.getLength(); ++i) {
                    Point2D[] _lines;
                    Point2D[] lines;
                    if (_5_0.getAbsolutePosition() % 5 == 0 && _5_0.isDisplayed()) {
                        g2.setFont(this.gc.getFont().deriveFont(this.gc.getFont().getSize2D() / 1.5f));
                        fm = g2.getFontMetrics(g2.getFont());
                        lines = DrawingUtils.fit(_5_0.getCurrentCenter(), _3_1.getCurrentCenter(), -this.gc.getCurrentHalf());
                        _lines = DrawingUtils.fit(_5_0.getCurrentCenter(), _3_1.getCurrentCenter(), -(2.0 * this.gc.getCurrentHalf()));
                        g2.drawLine((int)lines[0].getX(), (int)lines[0].getY(), (int)_lines[0].getX(), (int)_lines[0].getY());
                        points = DrawingUtils.fit(_5_0.getCurrentCenter(), _3_1.getCurrentCenter(), -(2.0 * this.gc.getCurrentHalf() + (double)(fm.stringWidth("" + _5_0.getAbsolutePosition()) / 2)));
                        DrawingUtils.drawString(points[0], "" + _5_0.getAbsolutePosition(), g2);
                        g2.setFont(this.gc.getFont());
                    } else if (_3_1.getAbsolutePosition() % 5 == 0 && _3_1.isDisplayed()) {
                        g2.setFont(this.gc.getFont().deriveFont(this.gc.getFont().getSize2D() / 1.5f));
                        fm = g2.getFontMetrics(g2.getFont());
                        lines = DrawingUtils.fit(_5_0.getCurrentCenter(), _3_1.getCurrentCenter(), -this.gc.getCurrentHalf());
                        _lines = DrawingUtils.fit(_5_0.getCurrentCenter(), _3_1.getCurrentCenter(), -(2.0 * this.gc.getCurrentHalf()));
                        g2.drawLine((int)lines[1].getX(), (int)lines[1].getY(), (int)_lines[1].getX(), (int)_lines[1].getY());
                        points = DrawingUtils.fit(_5_0.getCurrentCenter(), _3_1.getCurrentCenter(), -(2.0 * this.gc.getCurrentHalf() + (double)(fm.stringWidth("" + _3_1.getAbsolutePosition()) / 2)));
                        DrawingUtils.drawString(points[1], "" + _3_1.getAbsolutePosition(), g2);
                        g2.setFont(this.gc.getFont());
                    }
                    _5_0 = _5_0.getNextResidue();
                    _3_1 = _3_1.getPreviousResidue();
                }
            }
        }
        Polygon p = new Polygon();
        Residue2D[] bases5 = this.get5PrimeEnds();
        Residue2D[] bases3 = this.get3PrimeEnds();
        p.addPoint((int)bases5[0].getCurrentCenterX(), (int)bases5[0].getCurrentCenterY());
        p.addPoint((int)bases3[1].getCurrentCenterX(), (int)bases3[1].getCurrentCenterY());
        p.addPoint((int)bases5[1].getCurrentCenterX(), (int)bases5[1].getCurrentCenterY());
        p.addPoint((int)bases3[0].getCurrentCenterX(), (int)bases3[0].getCurrentCenterY());
        this.area = new Area(p);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getArea().contains(x, y);
    }

    public Point2D getCenter() {
        Residue2D _5end = this.get5PrimeEnds()[0];
        Residue2D _3end = this.get3PrimeEnds()[0];
        return new Point2D.Double((_5end.getCurrentCenterX() + _3end.getCurrentCenterX()) / 2.0, (_5end.getCurrentCenterY() + _3end.getCurrentCenterY()) / 2.0);
    }

    @Override
    public String toSVG() {
        if (!this.isDisplayed()) {
            return "";
        }
        StringBuffer svg = new StringBuffer();
        for (BaseBaseInteraction2D inter : this.secondaryInteractions) {
            svg.append(inter.toSVG());
        }
        for (Residue2D r : this.getAllResidues()) {
            svg.append(r.toSVG());
        }
        return svg.toString();
    }

    @Override
    public void setCoordinates() {
        if (this.getHelixFeature().getLength() > 2) {
            Residue2D base5 = this.get5PrimeEnds()[0];
            Residue2D base3 = this.get3PrimeEnd(base5);
            double length = DrawingUtils.getDistance(base5.getRealCoordinates(), base3.getRealCoordinates());
            Residue2D base5_0 = base5.getNextResidue();
            int i = 1;
            while (base5_0.getAbsolutePosition() < base3.getAbsolutePosition()) {
                base5_0.setRealCoordinates(DrawingUtils.fit(base5.getRealCoordinates(), base3.getRealCoordinates(), length / (double)(this.getLength() - 1) * (double)i)[0]);
                base5_0 = base5_0.getNextResidue();
                ++i;
            }
            base5 = this.getPairedResidue(base3);
            base3 = this.get3PrimeEnd(base5);
            base5_0 = base5.getNextResidue();
            i = 1;
            while (base5_0.getAbsolutePosition() < base3.getAbsolutePosition()) {
                base5_0.setRealCoordinates(DrawingUtils.fit(base5.getRealCoordinates(), base3.getRealCoordinates(), length / (double)(this.getLength() - 1) * (double)i)[0]);
                base5_0 = base5_0.getNextResidue();
                ++i;
            }
        }
        for (Residue2D r : this.get5PrimeEnds()) {
            if (r.getPreviousResidue() == null || !Sstrand2D.class.isInstance(r.getPreviousResidue().getStructuralDomain())) continue;
            r.getPreviousResidue().getStructuralDomain().setCoordinates();
        }
        for (Residue2D r : this.get3PrimeEnds()) {
            if (r.getNextResidue() == null || !Sstrand2D.class.isInstance(r.getNextResidue().getStructuralDomain())) continue;
            r.getNextResidue().getStructuralDomain().setCoordinates();
        }
    }

    @Override
    public void translateEnds(double dragX, double dragY) {
        Residue2D[] bases5 = this.repository.getResidues(this.getHelixFeature().get5PrimeEnds());
        Residue2D[] bases3 = this.repository.getResidues(this.getHelixFeature().get3PrimeEnds());
        bases5[0].translate(dragX, dragY);
        bases3[0].translate(dragX, dragY);
        bases5[1].translate(dragX, dragY);
        bases3[1].translate(dragX, dragY);
        this.setCoordinates();
    }

    @Override
    public void rotateEnds(Point2D centerPoint, double angle) {
        Residue2D[] bases5 = this.repository.getResidues(this.getHelixFeature().get5PrimeEnds());
        Residue2D[] bases3 = this.repository.getResidues(this.getHelixFeature().get3PrimeEnds());
        bases5[0].rotate(centerPoint, angle);
        bases3[0].rotate(centerPoint, angle);
        bases5[1].rotate(centerPoint, angle);
        bases3[1].rotate(centerPoint, angle);
        this.setCoordinates();
    }

    @Override
    public void flipEnds(Point2D center) {
        Residue2D[] bases5 = this.repository.getResidues(this.getHelixFeature().get5PrimeEnds());
        Residue2D[] bases3 = this.repository.getResidues(this.getHelixFeature().get3PrimeEnds());
        bases5[0].flip(center);
        bases5[1].flip(center);
        bases3[0].flip(center);
        bases3[1].flip(center);
        this.setCoordinates();
    }

    public void setEnds(Residue2D r1, Point2D p1, Residue2D r2, Point2D p2, Residue2D r3, Point2D p3, Residue2D r4, Point2D p4) {
        r1.setRealCoordinates(p1);
        r2.setRealCoordinates(p2);
        r3.setRealCoordinates(p3);
        r4.setRealCoordinates(p4);
        this.setCoordinates();
    }

    public void flipTerminalLoop() {
    }

    public List<BaseBaseInteraction2D> getSecondaryInteractions() {
        return new ArrayList<BaseBaseInteraction2D>(this.secondaryInteractions);
    }

    public Residue2D[] get5PrimeEnds() {
        return this.repository.getResidues(this.getHelixFeature().get5PrimeEnds());
    }

    public Residue2D[] get3PrimeEnds() {
        return this.repository.getResidues(this.getHelixFeature().get3PrimeEnds());
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        for (BaseBaseInteraction2D inter : this.secondaryInteractions) {
            inter.setColor(color);
        }
        for (Residue2D r : this.getAllResidues()) {
            r.setColor(color);
        }
    }

    @Override
    public Area getArea() {
        return this.area;
    }
}

