/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.PhosphodiesterBond2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residues2DRepository;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.assemble.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.RNA;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Helix;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rna2D
extends Rna2DElement {
    private RNA rna;
    List<Helix2D> helices;
    List<Sstrand2D> strands;
    List<BaseBaseInteraction2D> tertiaryInteractions;
    private SecondaryStructure secondaryStructure;

    Rna2D(RNA rna, SecondaryStructure secondaryStructure, Residues2DRepository repository, Mediator mediator, GraphicContext gc) {
        super(repository, mediator, gc);
        this.secondaryStructure = secondaryStructure;
        this.rna = rna;
        this.tertiaryInteractions = new ArrayList<BaseBaseInteraction2D>();
        this.helices = new ArrayList<Helix2D>();
        this.strands = new ArrayList<Sstrand2D>();
        for (SingleStrand ss : secondaryStructure.getAllSingleStrands()) {
            if (!((Molecule)ss.getMolecules().iterator().next()).getParadiseID().equals((Object)this.rna.getParadiseID())) continue;
            this.strands.add(new Sstrand2D(this, secondaryStructure, ss, repository, mediator, gc));
        }
        for (BaseBaseInteraction interaction : secondaryStructure.getAllTertiaryInteractions()) {
            if (interaction.isSecondaryInteraction() || interaction.getMolecules().size() != 1 || !((Molecule)interaction.getMolecules().iterator().next()).getParadiseID().equals((Object)this.rna.getParadiseID())) continue;
            this.tertiaryInteractions.add(BaseBaseInteraction2D.getInteraction(interaction, repository, mediator, gc));
        }
        for (Helix helix : secondaryStructure.getAllHelices()) {
            if (helix.getMolecules().size() != 1 || !((Molecule)helix.getMolecules().iterator().next()).getParadiseID().equals((Object)this.rna.getParadiseID())) continue;
            Helix2D h = new Helix2D(helix, repository, mediator, gc);
            this.helices.add(h);
        }
        for (int i = 1; i <= rna.getLength() - 1; ++i) {
            new PhosphodiesterBond2D(new Residue(i, (Molecule)rna), new Residue(i + 1, (Molecule)rna), repository, mediator, gc);
        }
    }

    public void addTertiaryInteraction(BaseBaseInteraction2D interaction) {
        this.tertiaryInteractions.add(interaction);
    }

    public RNA getRnaMolecule() {
        return this.rna;
    }

    @Override
    public List<Residue2D> getAllResidues() {
        ArrayList<Residue2D> residues = new ArrayList<Residue2D>(this.rna.getLength());
        for (int i = 1; i <= this.rna.getLength(); ++i) {
            residues.add(this.repository.getResidue(new Residue(i, (Molecule)this.rna)));
        }
        return residues;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getArea().contains(x, y);
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.isSelected()) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(this.color);
        }
        for (Helix2D h : this.helices) {
            h.draw(g2);
        }
        for (Sstrand2D ss : this.strands) {
            ss.draw(g2);
        }
        for (BaseBaseInteraction2D interaction : this.tertiaryInteractions) {
            interaction.draw(g2);
        }
    }

    @Override
    public Area getArea() {
        return null;
    }

    @Override
    public String toSVG() {
        if (!this.isDisplayed()) {
            return "";
        }
        StringBuffer svg = new StringBuffer();
        for (BaseBaseInteraction2D interaction : this.tertiaryInteractions) {
            svg.append(interaction.toSVG());
        }
        for (Helix2D h : this.helices) {
            svg.append(h.toSVG());
        }
        return svg.toString();
    }

    public List<Sstrand2D> getStrands() {
        return new ArrayList<Sstrand2D>(this.strands);
    }

    public List<Helix2D> getHelices() {
        return new ArrayList<Helix2D>(this.helices);
    }

    public List<BaseBaseInteraction2D> getTertiaryInteractions() {
        return new ArrayList<BaseBaseInteraction2D>(this.tertiaryInteractions);
    }

    public int length() {
        return this.rna.getLength();
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            return false;
        }
        return this.rna.getParadiseID().equals((Object)((Rna2D)obj).rna.getParadiseID());
    }

    public void removeTertiaryInteraction(BaseBaseInteraction2D interaction) {
        this.tertiaryInteractions.remove(interaction);
    }

    public void removeSstrand(Sstrand2D ss) {
        this.strands.remove(ss);
    }
}

