/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.utils.TextUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;

abstract class Symbol {
    Shape shape;
    private char orientation = (char)63;
    protected GraphicContext gc;

    Symbol(GraphicContext gc) {
        this.gc = gc;
    }

    Symbol(char orientation, GraphicContext gc) {
        this(gc);
        this.orientation = orientation;
    }

    public boolean contains(double x, double y) {
        return this.getArea().contains(x, y);
    }

    public Area getArea() {
        return new Area(this.shape);
    }

    public void draw(Graphics2D g2) {
        this.drawShape(g2);
    }

    public void drawShape(Graphics2D g2) {
        if (this.orientation == 'T') {
            g2.draw(this.shape);
        } else {
            g2.fill(this.shape);
        }
    }

    public abstract String toSVG();

    String getSVGStyle(Color color) {
        if (this.orientation == 'C') {
            return "style=\" fill-rule : nonzero; fill :" + TextUtils.colorToString(color) + " ; stroke :" + TextUtils.colorToString(color) + "; \"";
        }
        return "style=\" fill :none ; stroke :" + TextUtils.colorToString(color) + "; \"";
    }

    Color getSVGColor() {
        return Color.BLACK;
    }
}

