/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.graphics;

import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Model2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.assemble.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SelectState;
import fr.unistra.ibmc.assemble.structures.Residue;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResidueSelect
extends SelectState {
    ResidueSelect(Mediator mediator) {
        super(mediator);
    }

    @Override
    void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        Residue2D residueSelected = null;
        Model2D model2D = this.mediator.getModel2D();
        if (model2D != null && e.getClickCount() == 1) {
            block0: for (Helix2D h : model2D.getInterMolecularHelices()) {
                for (Residue2D r : h.getAllResidues()) {
                    if (!r.isDrawn() || !r.contains(e.getX(), e.getY())) continue;
                    residueSelected = r;
                    break block0;
                }
            }
            if (residueSelected == null) {
                block2: for (Rna2D rna : model2D.getRnas()) {
                    for (Helix2D h : rna.getHelices()) {
                        for (Residue2D r : h.getAllResidues()) {
                            if (!r.isDrawn() || !r.contains(e.getX(), e.getY())) continue;
                            residueSelected = r;
                            break block2;
                        }
                    }
                    for (Sstrand2D ss : rna.getStrands()) {
                        for (Residue2D r : ss.getAllResidues()) {
                            if (!r.isDrawn() || !r.contains(e.getX(), e.getY())) continue;
                            residueSelected = r;
                            break block2;
                        }
                    }
                }
            }
            if (residueSelected != null) {
                Residue assembleResidue;
                if (e.isShiftDown()) {
                    this.mediator.getSecondaryCanvas().addShiftCurrentResidue(residueSelected);
                } else {
                    this.mediator.getSecondaryCanvas().addCurrentResidue(residueSelected);
                }
                if (this.mediator.getAssemble().getMediator().get3DModel() != null && (assembleResidue = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.goloka.core.utils.Residue)residueSelected.getResidue2DFeature().getResidues().iterator().next())) != null) {
                    this.mediator.getRna2DViewer().fireSelectResidues(new ArrayList<Residue>(Arrays.asList(assembleResidue)), e.isShiftDown());
                }
            }
        }
    }

    @Override
    void mouseDragged(MouseEvent e) {
        this.mediator.getSecondaryCanvas().updateGravityPoint();
        if (this.mediator.getSecondaryCanvas().getGravityPoint() != null) {
            double trX = (double)e.getX() - this.mediator.getSecondaryCanvas().getGravityPoint().getX();
            double trY = (double)e.getY() - this.mediator.getSecondaryCanvas().getGravityPoint().getY();
            this.mediator.getSecondaryCanvas().translateSelection(trX, trY);
        }
    }

    @Override
    Rna2DElement getWrapper(fr.unistra.ibmc.paradise.goloka.core.utils.Residue residue) {
        if (this.mediator.getSecondaryCanvas() != null) {
            return this.mediator.getSecondaryCanvas().getModel2D().getResidue(residue.getMoleculeId(), residue.getAbsolutePosition());
        }
        return null;
    }

    @Override
    public void select(SecondaryCanvas canvas, List<Residue2D> residues) {
        canvas.clearAllSelections();
        for (Residue2D r2D : residues) {
            canvas.addShiftCurrentResidue(r2D);
        }
    }
}

