/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.graphics;

import fr.unistra.ibmc.assemble.AssembleAgent;
import fr.unistra.ibmc.assemble.behaviours.HelixReorganizationRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.SecondaryStructureDrawingRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.TertiaryStructurePredictionRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.gui.event.SelectionListener;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Model2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.assemble.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.ClearZoomState;
import fr.unistra.ibmc.assemble.ssviewer.graphics.InteractionSelect;
import fr.unistra.ibmc.assemble.ssviewer.graphics.MagnusZoomState;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.graphics.MinusZoomState;
import fr.unistra.ibmc.assemble.ssviewer.graphics.MoveViewState;
import fr.unistra.ibmc.assemble.ssviewer.graphics.ResidueSelect;
import fr.unistra.ibmc.assemble.ssviewer.graphics.RotationState;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SelectState;
import fr.unistra.ibmc.assemble.ssviewer.graphics.State;
import fr.unistra.ibmc.assemble.ssviewer.graphics.StructSelect;
import fr.unistra.ibmc.assemble.ssviewer.utils.IoUtils;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.utils.RessourcesUtils;
import fr.unistra.ibmc.paradise.goloka.ArchitectureException;
import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.RNA;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.goloka.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.goloka.utils.GeneralUtils;
import fr.unistra.ibmc.paradise.goloka.utils.VTextIcon;
import jade.gui.GuiEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rna2DViewer
extends JPanel
implements SelectionListener {
    private fr.unistra.ibmc.assemble.Mediator assembleMediator;
    private Mediator rna2DViewerMediator;
    private JButton lastClicked;
    private SelectButton selectButton;
    public static Cursor selectCursor;
    public static Cursor magnifyCursor;
    public static Cursor magnifyPlusCursor;
    public static Cursor magnifyMinusCursor;
    public static Cursor moveviewCursor;
    public static Cursor rotateCursor;
    private Cursor currentCursor;
    public static final int TERTIARY_STRUCTURE_ANNOTATION = 0;
    public static final int TERTIARY_STRUCTURE_PREDICTION = 1;
    public static final int SECONDARY_STRUCTURE_PREDICTION = 3;
    public static final int SECONDARY_STRUCTURE_DRAWING = 4;
    public static final int HELICES_REORGANIZATION = 5;
    private SelectState currentSelectionMode;
    private SecondaryCanvas secondaryCanvas;
    private Rna2DViewerToolBar toolbar;
    private ParadiseWorkingSession workingSession;
    private List<SelectionListener> selectionListeners;

    public Rna2DViewer(ParadiseWorkingSession workingSession, fr.unistra.ibmc.assemble.Mediator assembleMediator) {
        this.assembleMediator = assembleMediator;
        this.assembleMediator.setRna2DViewer(this);
        this.rna2DViewerMediator = new Mediator(this);
        this.setLayout(new BorderLayout());
        this.secondaryCanvas = new SecondaryCanvas(workingSession, this.rna2DViewerMediator);
        this.add((Component)this.secondaryCanvas, "Center");
        this.currentCursor = selectCursor;
        this.toolbar = new Rna2DViewerToolBar();
        this.currentSelectionMode = new StructSelect(this.rna2DViewerMediator);
        this.lastClicked = this.selectButton;
        this.workingSession = workingSession;
    }

    public void reorganizeHelices() {
        this.toolbar.reorganizeHelices.doClick();
    }

    public void generate3D() {
        this.toolbar.generate3DButton.doClick();
    }

    public void addSelectionListener(SelectionListener l) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<SelectionListener>();
        }
        this.selectionListeners.add(l);
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        if (!isShiftDown) {
            this.secondaryCanvas.clearAllSelections();
        }
        for (Residue r : residues) {
            this.secondaryCanvas.addShiftCurrentResidue(this.secondaryCanvas.seekResidue2D((fr.unistra.ibmc.paradise.goloka.core.utils.Residue)r.getResidue3D().getResidues().iterator().next()));
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        if (!isShiftDown) {
            this.secondaryCanvas.clearAllSelections();
        }
        this.secondaryCanvas.addShiftCurrentStructure((StructuralDomain2D)this.secondaryCanvas.seekRna2DNode((ParadiseFeature)structuralDomain));
    }

    @Override
    public void atomsSelected(Collection<Atom> atoms, boolean isShiftDown) {
        if (!isShiftDown) {
            this.secondaryCanvas.clearAllSelections();
        }
        for (Atom a : atoms) {
            this.secondaryCanvas.addShiftCurrentResidue(this.secondaryCanvas.seekResidue2D((fr.unistra.ibmc.paradise.goloka.core.utils.Residue)a.getResidue().getResidue3D().getResidues().iterator().next()));
        }
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        if (!isShiftDown) {
            this.secondaryCanvas.clearAllSelections();
        }
        this.secondaryCanvas.addShiftCurrentInteraction((Interaction2D)this.secondaryCanvas.seekRna2DNode((ParadiseFeature)interaction));
    }

    public ParadiseWorkingSession getWorkingSession() {
        return this.workingSession;
    }

    public Rna2DViewerToolBar getToolbar() {
        return this.toolbar;
    }

    public Mediator getRna2DViewerMediator() {
        return this.rna2DViewerMediator;
    }

    public fr.unistra.ibmc.assemble.Mediator getAssembleMediator() {
        return this.assembleMediator;
    }

    public MainParadiseFeature getCurrentFeature() {
        if (this.rna2DViewerMediator == null || this.rna2DViewerMediator.getSecondaryCanvas() == null || this.rna2DViewerMediator.getSecondaryCanvas().getModel2D() == null) {
            return null;
        }
        return this.rna2DViewerMediator.getSecondaryCanvas().getModel2D().getSecondaryStructure();
    }

    private void setCursorForCanvas(Cursor cursor) {
        this.getSecondaryCanvas().setCursor(cursor);
    }

    public Cursor getCurrentCursor() {
        return this.currentCursor;
    }

    public void loadRNASecondaryStructure(SecondaryStructure ss) {
        SecondaryStructureDisplay display = ss.getSecondaryStructureDisplay();
        if (display == null) {
            GuiEvent ev = new GuiEvent((Object)this, 3);
            ArrayList<Molecule> molecules = new ArrayList<Molecule>();
            for (Molecule m : ss.getMolecules()) {
                if (!RNA.class.isInstance(m)) continue;
                m.removeAllSelectedFeatures();
                molecules.add(m);
                m.addSelectedFeature((ParadiseFeature)ss);
            }
            ev.addParameter((Object)new SecondaryStructureDrawingRequestAnswerBehaviour(molecules, new ArrayList<Parameter>()));
            ((AbstractParadiseToolAgent)this.assembleMediator.getAssemble().getAgent()).postGuiEvent(ev);
        } else {
            if (this.rna2DViewerMediator.getModel2D() == null) {
                this.rna2DViewerMediator.setModel2D(ss, display);
            } else {
                try {
                    ArrayList<RNA> molecules = new ArrayList<RNA>();
                    for (Molecule m : ss.getMolecules()) {
                        RNA _m = this.rna2DViewerMediator.getRna2DViewer().getWorkingSession().createRNA(m.getParadiseID(), m.getName(), m.getSource(), m.printSequence());
                        molecules.add(_m);
                    }
                    this.rna2DViewerMediator.getModel2D().getSecondaryStructure().getFactory().copySubFeaturesToSecondaryStructure(molecules, ss, this.rna2DViewerMediator.getModel2D().getSecondaryStructure(), false);
                    SecondaryStructureDisplay currentDisplay = this.rna2DViewerMediator.getModel2D().getSecondaryStructure().getSecondaryStructureDisplay();
                    for (fr.unistra.ibmc.paradise.goloka.core.features.Residue2D r : display.getAllResidues2D()) {
                        this.rna2DViewerMediator.getModel2D().getSecondaryStructure().getFactory().copyResidue2D(molecules, r, currentDisplay);
                    }
                    this.rna2DViewerMediator.setModel2D(this.rna2DViewerMediator.getModel2D().getSecondaryStructure(), currentDisplay);
                }
                catch (BiologicalSymbolException e) {
                    e.printStackTrace();
                    return;
                }
            }
            this.assembleMediator.getSecondaryStructureNavigator().update();
        }
    }

    public SecondaryCanvas getSecondaryCanvas() {
        return this.secondaryCanvas;
    }

    void doClickOnSelectButton() {
        if (this.getSecondaryCanvas() != null) {
            if (this.lastClicked != null) {
                this.lastClicked.setEnabled(true);
            }
            this.selectButton.setEnabled(false);
            this.currentCursor = selectCursor;
            this.setCursorForCanvas(selectCursor);
            this.lastClicked = this.selectButton;
        }
    }

    public void selectResidues(Collection<fr.unistra.ibmc.paradise.goloka.core.utils.Residue> residues, boolean isShiftDown) {
        SecondaryCanvas canvas = this.getSecondaryCanvas();
        if (!isShiftDown) {
            canvas.clearAllSelections();
        }
        if (canvas.getModel2D() != null) {
            for (Rna2D rna2D : canvas.getModel2D().getRnas()) {
                for (fr.unistra.ibmc.paradise.goloka.core.utils.Residue r : residues) {
                    if (!rna2D.getRnaMolecule().equals((Object)r.getMolecule())) continue;
                    for (Residue2D r2D : rna2D.getAllResidues()) {
                        if (r.getAbsolutePosition() != r2D.getAbsolutePosition()) continue;
                        canvas.addShiftCurrentResidue(r2D);
                    }
                }
            }
        }
    }

    public void fireSelectResidues(List<Residue> residues, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.residuesSelected(residues, isShiftDown);
        }
    }

    public void fireSelectStructuralDomain(StructuralDomain domain, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.structuralDomainSelected(domain, isShiftDown);
        }
    }

    public void fireSelectBaseBaseInteraction(BaseBaseInteraction interaction, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.interactionSelected(interaction, isShiftDown);
        }
    }

    static {
        Toolkit tk = Toolkit.getDefaultToolkit();
        selectCursor = tk.createCustomCursor(RessourcesUtils.getImage("select-cursor.gif"), new Point(0, 0), "select");
        magnifyCursor = tk.createCustomCursor(RessourcesUtils.getImage("magnify-cursor.gif"), new Point(0, 0), "magnify");
        magnifyPlusCursor = tk.createCustomCursor(RessourcesUtils.getImage("magnify-plus-cursor.gif"), new Point(0, 0), "mplus");
        magnifyMinusCursor = tk.createCustomCursor(RessourcesUtils.getImage("magnify-minus-cursor.gif"), new Point(0, 0), "mminus");
        moveviewCursor = tk.createCustomCursor(RessourcesUtils.getImage("move-view-cursor.gif"), new Point(0, 0), "move view");
        rotateCursor = tk.createCustomCursor(RessourcesUtils.getImage("rotate-cursor.gif"), new Point(0, 0), "rotate");
    }

    private class InteractionSelector
    extends JDialog {
        private JButton ok = new JButton("Ok");
        private JButton cancel = new JButton("Cancel");
        private JRadioButton w1 = new JRadioButton("Watson Crick");
        private JRadioButton h1 = new JRadioButton("Hoogsteen");
        private JRadioButton s1 = new JRadioButton("Sugar Edge");
        private JRadioButton w2 = new JRadioButton("Watson Crick");
        private JRadioButton h2 = new JRadioButton("Hoogsteen");
        private JRadioButton s2 = new JRadioButton("Sugar Edge");
        private JRadioButton cis = new JRadioButton("Cis");
        private JRadioButton trans = new JRadioButton("Trans");
        private JRadioButton r1;
        private JRadioButton r2;
        private Residue2D residue1;
        private Residue2D residue2;
        private Molecule m1;
        private Molecule m2;
        private int pos1;
        private int pos2;
        private boolean generateTertiaryInteraction;

        private InteractionSelector(Residue2D residue1, Residue2D residue2) {
            this.residue1 = residue1;
            this.residue2 = residue2;
            this.pos1 = residue1.getAbsolutePosition();
            this.pos2 = residue2.getAbsolutePosition();
            this.m1 = (Molecule)residue1.getResidue2DFeature().getMolecules().iterator().next();
            this.m2 = (Molecule)residue2.getResidue2DFeature().getMolecules().iterator().next();
            this.r1 = new JRadioButton(this.m1.getResidueAt(this.pos1) + " " + this.pos1 + " (" + this.m1.getName() + ")");
            this.r2 = new JRadioButton(this.m2.getResidueAt(this.pos2) + " " + this.pos2 + " (" + this.m2.getName() + ")");
            ButtonGroup be1 = new ButtonGroup();
            ButtonGroup be2 = new ButtonGroup();
            ButtonGroup bo = new ButtonGroup();
            ButtonGroup br = new ButtonGroup();
            be1.add(this.w1);
            be1.add(this.h1);
            be1.add(this.s1);
            be2.add(this.w2);
            be2.add(this.h2);
            be2.add(this.s2);
            bo.add(this.cis);
            bo.add(this.trans);
            br.add(this.r1);
            br.add(this.r2);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
            JPanel ed1 = new JPanel();
            ed1.setLayout(new BoxLayout(ed1, 2));
            JPanel ed2 = new JPanel();
            ed2.setLayout(new BoxLayout(ed2, 2));
            JPanel or = new JPanel();
            or.setLayout(new BoxLayout(or, 2));
            JPanel re = new JPanel();
            re.setLayout(new BoxLayout(re, 2));
            JPanel but = new JPanel();
            but.setLayout(new BoxLayout(but, 2));
            ed1.add(new JLabel("Edge for " + this.m1.getResidueAt(this.pos1) + " " + this.pos1));
            ed1.add(this.w1);
            ed1.add(this.h1);
            ed1.add(this.s1);
            ed2.add(new JLabel("Edge for " + this.m2.getResidueAt(this.pos2) + " " + this.pos2));
            ed2.add(this.w2);
            ed2.add(this.h2);
            ed2.add(this.s2);
            or.add(new JLabel("Orientation of the Interaction"));
            or.add(this.cis);
            or.add(this.trans);
            re.add(new JLabel("Dominant Residue (if applicable)"));
            re.add(this.r1);
            re.add(this.r2);
            but.add(this.ok);
            but.add(this.cancel);
            this.setTitle("Describe the Interaction");
            this.getContentPane().add(ed1);
            this.getContentPane().add(ed2);
            this.getContentPane().add(or);
            this.getContentPane().add(re);
            this.getContentPane().add(but);
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InteractionSelector.this.dispose();
                }
            });
            this.pack();
            this.setResizable(false);
            GeneralUtils.centerOnScreen((Window)this);
            this.setVisible(true);
        }

        public InteractionSelector(final BaseBaseInteraction2D interaction) {
            this(interaction.getResidue(), interaction.getPartnerResidue());
            switch (interaction.getBaseBaseInteractionFeature().getOrientation()) {
                case 'C': {
                    this.cis.setSelected(true);
                    break;
                }
                case 'T': {
                    this.trans.setSelected(true);
                }
            }
            switch (interaction.getBaseBaseInteractionFeature().getEdge1()) {
                case 'W': {
                    this.w1.setSelected(true);
                    break;
                }
                case 'H': {
                    this.h1.setSelected(true);
                    break;
                }
                case 'S': {
                    this.s1.setSelected(true);
                }
            }
            switch (interaction.getBaseBaseInteractionFeature().getEdge2()) {
                case 'W': {
                    this.w2.setSelected(true);
                    break;
                }
                case 'H': {
                    this.h2.setSelected(true);
                    break;
                }
                case 'S': {
                    this.s2.setSelected(true);
                }
            }
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    char edge1 = 'W';
                    char edge2 = 'W';
                    char orientation = 'C';
                    char dominant = '\u0001';
                    if (InteractionSelector.this.h1.isSelected()) {
                        edge1 = 'H';
                    }
                    if (InteractionSelector.this.s1.isSelected()) {
                        edge1 = 'S';
                    }
                    if (InteractionSelector.this.h2.isSelected()) {
                        edge2 = 'H';
                    }
                    if (InteractionSelector.this.s2.isSelected()) {
                        edge2 = 'S';
                    }
                    if (InteractionSelector.this.trans.isSelected()) {
                        orientation = 'T';
                    }
                    if (InteractionSelector.this.r2.isSelected()) {
                        dominant = '\u0002';
                    }
                    Rna2DViewer.this.rna2DViewerMediator.getModel2D().modifyInteractionType(interaction, InteractionSelector.this.residue1, edge1, InteractionSelector.this.residue2, edge2, orientation, dominant);
                    Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                    InteractionSelector.this.dispose();
                    Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                }
            });
        }

        public InteractionSelector(final Residue2D residue1, final Residue2D residue2, boolean generateTertiaryInteraction) {
            this(residue1, residue2);
            this.w1.setSelected(true);
            this.w2.setSelected(true);
            this.cis.setSelected(true);
            this.r1.setSelected(true);
            this.generateTertiaryInteraction = generateTertiaryInteraction;
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == InteractionSelector.this.ok) {
                        char edge1 = 'W';
                        char edge2 = 'W';
                        char orientation = 'C';
                        char dominant = '\u0001';
                        if (InteractionSelector.this.h1.isSelected()) {
                            edge1 = 'H';
                        }
                        if (InteractionSelector.this.s1.isSelected()) {
                            edge1 = 'S';
                        }
                        if (InteractionSelector.this.h2.isSelected()) {
                            edge2 = 'H';
                        }
                        if (InteractionSelector.this.s2.isSelected()) {
                            edge2 = 'S';
                        }
                        if (InteractionSelector.this.trans.isSelected()) {
                            orientation = 'T';
                        }
                        if (InteractionSelector.this.r2.isSelected()) {
                            dominant = '\u0002';
                        }
                        Rna2DViewer.this.rna2DViewerMediator.getModel2D().createTertiaryInteraction(residue1, edge1, residue2, edge2, orientation, dominant);
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                        InteractionSelector.this.dispose();
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                    }
                }
            });
        }
    }

    class SelectButton
    extends JButton
    implements ActionListener,
    MouseListener {
        private SelectButton(String name, Icon image) {
            super(name, image);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setBackground(Color.white);
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            if (Rna2DViewer.this.lastClicked != null) {
                Rna2DViewer.this.lastClicked.setEnabled(true);
            }
            this.setEnabled(false);
            Rna2DViewer.this.lastClicked = this;
            if (Rna2DViewer.this.getSecondaryCanvas().getModel2D() != null) {
                Rna2DViewer.this.rna2DViewerMediator.setState(Rna2DViewer.this.currentSelectionMode);
            }
            Rna2DViewer.this.setCursorForCanvas(selectCursor);
            Rna2DViewer.this.currentCursor = selectCursor;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setBackground(Color.lightGray);
            this.setBorderPainted(true);
        }

        public void mouseExited(MouseEvent e) {
            this.setBackground(Color.white);
            this.setBorderPainted(false);
        }
    }

    private class Generate3DButton
    extends JButton
    implements MouseListener {
        private Generate3DButton() {
            super(new ImageIcon(RessourcesUtils.getImage("22/generate3D.png")));
            this.setBackground(Color.white);
            this.setBorderPainted(false);
            this.addMouseListener(this);
            if (!Rna2DViewer.this.assembleMediator.getAssemble().isConnected()) {
                this.setToolTipText("Generate 3D from 2D (need connection)");
                this.setEnabled(false);
            } else {
                this.setToolTipText("Generate 3D from 2D");
            }
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.rna2DViewerMediator.getModel2D() != null) {
                        Molecule m;
                        Collection _molecules;
                        if (Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures().isEmpty() && Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions().isEmpty()) {
                            JOptionPane.showMessageDialog(null, "Please select at least one Structural Domain or Base-Base Interaction to use this function");
                            return;
                        }
                        if (Rna2DViewer.this.assembleMediator.get3DModel() != null) {
                            for (Residue2D r : Rna2DViewer.this.getSecondaryCanvas().getCurrentResidues()) {
                                if (Rna2DViewer.this.assembleMediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.goloka.core.utils.Residue)r.getResidue2DFeature().getResidues().iterator().next()) == null) continue;
                                JOptionPane.showMessageDialog(null, "One or several residues are already present in the 3D Model.\nDelete them in the 3D Model before to retry");
                                return;
                            }
                        }
                        GuiEvent ev = new GuiEvent((Object)this, 5);
                        HashSet molecules = new HashSet();
                        for (Molecule m2 : Rna2DViewer.this.getSecondaryCanvas().getModel2D().getSecondaryStructure().getMolecules()) {
                            m2.removeAllSelectedFeatures();
                        }
                        ArrayList<Interaction2D> interactions2D = new ArrayList<Interaction2D>(Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions());
                        for (StructuralDomain2D sd : Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures()) {
                            if (Helix2D.class.isInstance(sd)) {
                                interactions2D.removeAll(((Helix2D)sd).getSecondaryInteractions());
                            }
                            _molecules = sd.getStructuralDomain().getMolecules();
                            molecules.addAll(_molecules);
                            m = (Molecule)_molecules.iterator().next();
                            m.addSelectedFeature((ParadiseFeature)sd.getStructuralDomain());
                        }
                        for (Interaction2D interaction : interactions2D) {
                            if (!BaseBaseInteraction2D.class.isInstance(interaction)) continue;
                            _molecules = ((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().getMolecules();
                            molecules.addAll(_molecules);
                            m = (Molecule)_molecules.iterator().next();
                            m.addSelectedFeature((ParadiseFeature)((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature());
                        }
                        ev.addParameter((Object)new TertiaryStructurePredictionRequestAnswerBehaviour(new ArrayList<Molecule>(molecules), new ArrayList<Parameter>()));
                        Rna2DViewer.this.assembleMediator.stopAnimator();
                        ((AssembleAgent)Rna2DViewer.this.assembleMediator.getAssemble().getAgent()).postGuiEvent(ev);
                    }
                }
            });
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setBackground(Color.lightGray);
            this.setBorderPainted(true);
        }

        public void mouseExited(MouseEvent e) {
            this.setBackground(Color.white);
            this.setBorderPainted(false);
        }
    }

    private class Rna2DViewerToolBar
    extends JToolBar {
        private StateButton zoomPlusButton;
        private StateButton zoomMinusButton;
        private StateButton noZoomButton;
        private StateButton rotButton;
        private StateButton moveView;
        private ActionButton addHelix;
        private ActionButton removeHelix;
        private ActionButton addTertiaryInteraction;
        private ActionButton removeTertiaryInteraction;
        private ActionButton modifyInteractionType;
        private ActionButton reorganizeHelices;
        private ActionButton[] actions = new ActionButton[15];
        private Generate3DButton generate3DButton;

        private Rna2DViewerToolBar() {
            this.setFloatable(false);
            this.setBackground(Color.white);
            int height = new ImageIcon(RessourcesUtils.getImage("flip.png")).getIconHeight();
            this.actions[0] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("flip.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.getSecondaryCanvas().flipSelection();
                }
            });
            this.actions[0].setToolTipText("Flip selection");
            this.actions[1] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("lock.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            this.actions[1].setToolTipText("Lock interaction display");
            this.actions[2] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("unlock.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            this.actions[2].setToolTipText("Unlock interaction display");
            this.actions[3] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("show-symbol.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Iterator<Interaction2D> ic = Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions().iterator();
                    while (ic.hasNext()) {
                        ic.next().drawRealSymbol(true);
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            });
            this.actions[3].setToolTipText("Display LW symbol");
            this.actions[4] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("hide-symbol.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Iterator<Interaction2D> ic = Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions().iterator();
                    while (ic.hasNext()) {
                        ic.next().drawRealSymbol(false);
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            });
            this.actions[4].setToolTipText("Hide LW symbol");
            this.actions[5] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("center-view.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.getSecondaryCanvas().centerView();
                }
            });
            this.actions[5].setToolTipText("Center view on 2D structure");
            this.actions[8] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("plus.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.getSecondaryCanvas().increaseFontSize();
                }
            });
            this.actions[8].setToolTipText("Increase font");
            this.actions[9] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("minus.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.getSecondaryCanvas().decreaseFontSize();
                }
            });
            this.actions[9].setToolTipText("Decrease font");
            this.actions[12] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("ellipse.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<StructuralDomain2D> strs = Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures();
                    StructuralDomain2D str2 = null;
                    for (StructuralDomain2D str2 : strs) {
                        if (!(str2 instanceof Sstrand2D)) continue;
                        ((Sstrand2D)str2).isAutomaticCoordinates(true);
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            });
            this.actions[12].setToolTipText("Single-strand automatic drawing mode");
            this.actions[13] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("polygon.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<StructuralDomain2D> strs = Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures();
                    StructuralDomain2D str2 = null;
                    for (StructuralDomain2D str2 : strs) {
                        if (!(str2 instanceof Sstrand2D)) continue;
                        ((Sstrand2D)str2).isAutomaticCoordinates(false);
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            });
            this.actions[13].setToolTipText("Single-strand user-defined drawing mode");
            Rna2DViewer.this.selectButton = new SelectButton(null, new ImageIcon(RessourcesUtils.getImage("select.png")));
            Rna2DViewer.this.selectButton.setToolTipText("Select/Translate selection");
            this.zoomPlusButton = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("plus.png")), new MagnusZoomState(Rna2DViewer.this.rna2DViewerMediator), magnifyPlusCursor);
            this.zoomPlusButton.setToolTipText("Zoom in");
            this.zoomMinusButton = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("minus.png")), new MinusZoomState(Rna2DViewer.this.rna2DViewerMediator), magnifyMinusCursor);
            this.zoomMinusButton.setToolTipText("Zoom out");
            this.noZoomButton = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("zoom.png")), new ClearZoomState(Rna2DViewer.this.rna2DViewerMediator), magnifyCursor);
            this.noZoomButton.setToolTipText("1:1");
            this.rotButton = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("rotate.png")), new RotationState(Rna2DViewer.this.rna2DViewerMediator), rotateCursor);
            this.rotButton.setToolTipText("Rotate selection");
            this.moveView = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("move-view.png")), new MoveViewState(Rna2DViewer.this.rna2DViewerMediator), moveviewCursor);
            this.moveView.setToolTipText("Move view");
            this.addHelix = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("new-secondary.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SecondaryCanvas canvas = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas();
                    Model2D model2D = canvas.getModel2D();
                    if (model2D != null && canvas.getCurrentResidues().size() == 4) {
                        Iterator<Residue2D> it = canvas.getCurrentResidues().iterator();
                        Residue2D r1 = it.next();
                        Residue2D r2 = it.next();
                        Residue2D r3 = it.next();
                        Residue2D r4 = it.next();
                        ParadiseID id1 = r1.getMoleculeId();
                        ParadiseID id2 = r2.getMoleculeId();
                        ParadiseID id3 = r3.getMoleculeId();
                        ParadiseID id4 = r4.getMoleculeId();
                        ArrayList<Residue2D> sortedResidues = new ArrayList<Residue2D>(4);
                        if (id1 == id2 && id3 == id4) {
                            if (r1.getAbsolutePosition() < r2.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r2);
                            } else {
                                sortedResidues.add(r2);
                                sortedResidues.add(r1);
                            }
                            if (r3.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r3);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r3);
                            }
                        } else if (id1 == id3 && id2 == id4) {
                            if (r1.getAbsolutePosition() < r3.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r3);
                            } else {
                                sortedResidues.add(r3);
                                sortedResidues.add(r1);
                            }
                            if (r2.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r2);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r2);
                            }
                        } else if (id1 == id4 && id2 == id3) {
                            if (r1.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r1);
                            }
                            if (r2.getAbsolutePosition() < r3.getAbsolutePosition()) {
                                sortedResidues.add(r2);
                                sortedResidues.add(r3);
                            } else {
                                sortedResidues.add(r3);
                                sortedResidues.add(r2);
                            }
                        }
                        it = sortedResidues.iterator();
                        try {
                            model2D.createHelix(it.next(), it.next(), it.next(), it.next());
                            Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                        }
                        catch (ArchitectureException ex) {
                            JOptionPane.showMessageDialog(Rna2DViewer.this, ex.getMessage(), "Cannot create Helix", 0);
                        }
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "Select exactly four residues to use this option", "Cannot create Helix", 0);
                    }
                }
            });
            this.addHelix.setToolTipText("Create new helix");
            this.removeHelix = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("delete-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Model2D model2D = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getModel2D();
                    if (model2D != null) {
                        ArrayList<StructuralDomain2D> domains = new ArrayList<StructuralDomain2D>(Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getCurrentStructures());
                        for (StructuralDomain2D sd : domains) {
                            if (!Helix2D.class.isInstance(sd)) continue;
                            Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().removeCurrentStructure(sd);
                            model2D.removeHelix((Helix2D)sd);
                        }
                    }
                    Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                }
            });
            this.removeHelix.setToolTipText("Remove helix");
            this.addTertiaryInteraction = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("new-tertiary.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Residue2D> residues = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getCurrentResidues();
                    if (residues.size() == 2) {
                        new InteractionSelector(residues.get(0), residues.get(1), true);
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "You have to select two residues to create a new tertiary interaction", "No residues selected!!", 0);
                    }
                }
            });
            this.addTertiaryInteraction.setToolTipText("Create new tertiary interaction");
            this.removeTertiaryInteraction = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("delete-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Interaction2D> interactions = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getCurrentInteractions();
                    if (interactions.isEmpty()) {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "No interactions selected !!");
                    } else {
                        ArrayList<BaseBaseInteraction> interactionsRemoved = new ArrayList<BaseBaseInteraction>();
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                        for (Interaction2D i : interactions) {
                            if (!BaseBaseInteraction2D.class.isInstance(i) || ((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature().isSecondaryInteraction() || ((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature().getMolecules().size() != 1) continue;
                            Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getModel2D().removeTertiaryInteraction((BaseBaseInteraction2D)i);
                            interactionsRemoved.add(((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature());
                        }
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                    }
                }
            });
            this.removeTertiaryInteraction.setToolTipText("Remove tertiary interactions");
            this.modifyInteractionType = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("modify-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Interaction2D> interactions = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getCurrentInteractions();
                    if (interactions.size() == 1 && BaseBaseInteraction2D.class.isInstance(interactions.get(0))) {
                        new InteractionSelector((BaseBaseInteraction2D)interactions.get(0));
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "You have to select only one interaction!!");
                    }
                }
            });
            this.modifyInteractionType.setToolTipText("Modify interaction's type");
            JLabel toolBarName = new JLabel();
            toolBarName.setIcon((Icon)new VTextIcon((Component)toolBarName, "2D", 2));
            this.add(toolBarName);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.moveView);
            this.add(this.actions[5]);
            JSeparator separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.zoomPlusButton);
            this.add(this.noZoomButton);
            this.add(this.zoomMinusButton);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(Rna2DViewer.this.selectButton);
            this.add(new SelectionMode(height));
            ActionButton clearSelections = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("22/unselect.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                    Rna2DViewer.this.assembleMediator.getGlobalSelection().clear();
                    Rna2DViewer.this.assembleMediator.getAssemble().getSecondaryStructureNavigator().clearSelections();
                }
            });
            clearSelections.setToolTipText("Clear Selection");
            this.add(clearSelections);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.rotButton);
            this.add(this.actions[0]);
            this.reorganizeHelices = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("22/magic.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GuiEvent ev = new GuiEvent((Object)this, 4);
                    if (Rna2DViewer.this.getSecondaryCanvas().getModel2D() != null) {
                        SecondaryStructure ss = Rna2DViewer.this.getSecondaryCanvas().getModel2D().getSecondaryStructure();
                        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                        for (Molecule m : ss.getMolecules()) {
                            m.removeAllSelectedFeatures();
                            m.addSelectedFeature((ParadiseFeature)ss);
                            molecules.add(m);
                        }
                        ev.addParameter((Object)new HelixReorganizationRequestAnswerBehaviour(molecules, new ArrayList<Parameter>()));
                        ((AssembleAgent)Rna2DViewer.this.assembleMediator.getAssemble().getAgent()).postGuiEvent(ev);
                    }
                }
            });
            if (!Rna2DViewer.this.assembleMediator.getAssemble().isConnected()) {
                this.reorganizeHelices.setToolTipText("Reorganize helices (need connection)");
                this.reorganizeHelices.setEnabled(false);
            } else {
                this.reorganizeHelices.setToolTipText("Reorganize helices");
            }
            this.add(this.reorganizeHelices);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.addHelix);
            this.add(this.removeHelix);
            this.add(this.addTertiaryInteraction);
            this.add(this.removeTertiaryInteraction);
            this.add(this.modifyInteractionType);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(new CaptureViewButton());
            this.generate3DButton = new Generate3DButton();
            this.add(this.generate3DButton);
            this.add(Box.createHorizontalGlue());
        }

        private class CaptureViewButton
        extends JButton
        implements MouseListener {
            private CaptureViewButton() {
                super(new ImageIcon(RessourcesUtils.getImage("capture.png")));
                this.setToolTipText("Capture the view");
                this.setBackground(Color.white);
                this.setBorderPainted(false);
                this.addMouseListener(this);
                this.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent e) {
                        if (Rna2DViewer.this.rna2DViewerMediator.getModel2D() != null) {
                            JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                            fileChooser.setFileFilter(IoUtils.getPNGFilter());
                            if (fileChooser.showSaveDialog(Rna2DViewer.this) == 0) {
                                File file = null;
                                String extension = null;
                                PrintWriter pw = null;
                                try {
                                    file = fileChooser.getSelectedFile();
                                    extension = IoUtils.getExtension(file);
                                    if (extension.equals("png")) {
                                        file.createNewFile();
                                        Paradise.setWorkingDirectory((String)file.getAbsolutePath());
                                        ImageIO.write((RenderedImage)Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getImage(false), "png", file);
                                        JOptionPane.showMessageDialog(Rna2DViewer.this, "Saving successful");
                                    } else {
                                        System.out.println("Not supported file type");
                                    }
                                }
                                catch (FileNotFoundException fnfe) {
                                    System.out.println("I cannot find the file : " + file.getPath());
                                    return;
                                }
                                catch (IOException ioe) {
                                    System.out.println("Problem to save data in the file : " + file.getPath());
                                    return;
                                }
                                finally {
                                    if (pw != null) {
                                        pw.close();
                                    }
                                }
                            }
                        }
                    }
                });
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class DisplayButton
        extends JButton
        implements MouseListener {
            private DisplayButton() {
                super(new ImageIcon(RessourcesUtils.getImage("display-unlocked.png")));
                this.setToolTipText("Lock/Unlock the display");
                this.setBackground(Color.white);
                this.setBorderPainted(false);
                this.addMouseListener(this);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Rna2DViewer.this.rna2DViewerMediator.isLinked(!Rna2DViewer.this.rna2DViewerMediator.isLinked());
                        if (Rna2DViewer.this.rna2DViewerMediator.isLinked()) {
                            DisplayButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage("display-unlocked.png")));
                        } else {
                            DisplayButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage("display-locked.png")));
                        }
                    }
                });
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class StateButton
        extends JButton
        implements ActionListener,
        MouseListener {
            private State state;
            private Cursor cursor;

            private StateButton(String name, Icon image, State state, Cursor cursor) {
                super(name, image);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorderPainted(false);
                this.setBackground(Color.white);
                this.addActionListener(this);
                this.addMouseListener(this);
                this.state = state;
                this.cursor = cursor;
            }

            public void actionPerformed(ActionEvent e) {
                if (Rna2DViewer.this.lastClicked != null) {
                    Rna2DViewer.this.lastClicked.setEnabled(true);
                }
                this.setEnabled(false);
                Rna2DViewer.this.lastClicked = this;
                if (Rna2DViewer.this.getSecondaryCanvas().getModel2D() != null) {
                    Rna2DViewer.this.rna2DViewerMediator.setState(this.state);
                }
                Rna2DViewer.this.setCursorForCanvas(this.cursor);
                Rna2DViewer.this.currentCursor = this.cursor;
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class ActionButton
        extends JButton
        implements MouseListener {
            private ActionButton(String name, Icon image, ActionListener listener) {
                super(name, image);
                this.addActionListener(listener);
                this.addMouseListener(this);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorderPainted(false);
                this.setBackground(Color.white);
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class SelectionMode
        extends JComboBox {
            private SelectionItem[] selectionItems;

            SelectionMode(int height) {
                this.selectionItems = new SelectionItem[]{new SelectionItem("Structures", new StructSelect(Rna2DViewer.this.rna2DViewerMediator)), new SelectionItem("Interactions", new InteractionSelect(Rna2DViewer.this.rna2DViewerMediator)), new SelectionItem("Bases", new ResidueSelect(Rna2DViewer.this.rna2DViewerMediator))};
                this.setMaximumSize(new Dimension(10, height));
                for (SelectionItem item : this.selectionItems) {
                    this.addItem(item);
                }
                this.setBackground(Color.WHITE);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Rna2DViewer.this.currentSelectionMode = ((SelectionItem)SelectionMode.this.getSelectedItem()).selectionMode;
                        Rna2DViewer.this.rna2DViewerMediator.setState(((SelectionItem)SelectionMode.this.getSelectedItem()).selectionMode);
                        Rna2DViewer.this.doClickOnSelectButton();
                    }
                });
                this.setEditable(false);
            }

            private class SelectionItem {
                private String label;
                private SelectState selectionMode;

                private SelectionItem(String label, SelectState selectionMode2) {
                    this.label = label;
                    this.selectionMode = selectionMode2;
                }

                public String toString() {
                    return this.label;
                }
            }
        }
    }
}

