/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.graphics;

import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Model2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.assemble.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.assemble.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SelectState;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StructSelect
extends SelectState {
    private List<StructuralDomain2D> structuresSelected = new ArrayList<StructuralDomain2D>();

    StructSelect(Mediator mediator) {
        super(mediator);
    }

    @Override
    void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        StructuralDomain2D structSelect = null;
        Model2D model2D = this.mediator.getSecondaryCanvas().getModel2D();
        if (model2D != null && e.getClickCount() == 1) {
            for (Helix2D h : model2D.getInterMolecularHelices()) {
                if (!h.isDrawn() || !h.contains(e.getX(), e.getY())) continue;
                structSelect = h;
                break;
            }
            block1: for (Rna2D rna : model2D.getRnas()) {
                for (Helix2D h : rna.getHelices()) {
                    if (!h.isDrawn() || !h.contains(e.getX(), e.getY())) continue;
                    structSelect = h;
                    break block1;
                }
                for (Sstrand2D ss : rna.getStrands()) {
                    if (!ss.isDrawn() || !ss.contains(e.getX(), e.getY())) continue;
                    structSelect = ss;
                    break block1;
                }
            }
            if (structSelect != null) {
                if (e.isShiftDown()) {
                    this.mediator.getSecondaryCanvas().addShiftCurrentStructure(structSelect);
                } else {
                    this.mediator.getSecondaryCanvas().addCurrentStructure(structSelect);
                }
                this.mediator.getRna2DViewer().fireSelectStructuralDomain(structSelect.getStructuralDomain(), e.isShiftDown());
                this.mediator.getSecondaryCanvas().updateGravityPoint();
            }
        }
    }

    @Override
    void mouseDragged(MouseEvent e) {
        if (e.isShiftDown()) {
            Rectangle2D.Double r = new Rectangle2D.Double(Math.min(this.corner.getX(), (double)e.getX()), Math.min(this.corner.getY(), (double)e.getY()), Math.abs((double)e.getX() - this.corner.getX()), Math.abs((double)e.getY() - this.corner.getY()));
            Rectangle2D previous = this.mediator.getSecondaryCanvas().selectionRectangle;
            this.mediator.getSecondaryCanvas().setSelectionRectangle(r);
            Model2D model2D = this.mediator.getSecondaryCanvas().getModel2D();
            for (StructuralDomain2D s : this.structuresSelected) {
                s.isSelected(false);
            }
            this.structuresSelected.clear();
            if (model2D != null) {
                for (Helix2D h : model2D.getInterMolecularHelices()) {
                    if (!h.isDrawn() || !this.mediator.getSecondaryCanvas().selectionRectangle.contains(h.getArea().getBounds2D())) continue;
                    this.structuresSelected.add(h);
                    h.isSelected(true);
                }
                for (Rna2D rna : model2D.getRnas()) {
                    for (Helix2D h : rna.getHelices()) {
                        if (!h.isDrawn() || !this.mediator.getSecondaryCanvas().selectionRectangle.contains(h.getArea().getBounds2D())) continue;
                        this.structuresSelected.add(h);
                        h.isSelected(true);
                    }
                    for (Sstrand2D ss : rna.getStrands()) {
                        if (!ss.isDrawn() || !this.mediator.getSecondaryCanvas().selectionRectangle.contains(ss.getArea().getBounds2D())) continue;
                        this.structuresSelected.add(ss);
                        ss.isSelected(true);
                    }
                }
            }
            this.mediator.getSecondaryCanvas().repaint();
        } else {
            this.mediator.getSecondaryCanvas().updateGravityPoint();
            if (this.mediator.getSecondaryCanvas().getGravityPoint() != null) {
                double trX = (double)e.getX() - this.mediator.getSecondaryCanvas().getGravityPoint().getX();
                double trY = (double)e.getY() - this.mediator.getSecondaryCanvas().getGravityPoint().getY();
                this.mediator.getSecondaryCanvas().translateSelection(trX, trY);
            }
        }
    }

    @Override
    void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.structuresSelected != null && this.structuresSelected.size() > 0) {
            ArrayList<StructuralDomain2D> structures = new ArrayList<StructuralDomain2D>();
            if (e.isShiftDown()) {
                for (StructuralDomain2D s : this.mediator.getSecondaryCanvas().getCurrentStructures()) {
                    structures.add(s);
                }
                for (StructuralDomain2D s : this.structuresSelected) {
                    this.mediator.getSecondaryCanvas().addShiftCurrentStructure(s);
                    structures.add(s);
                }
            } else {
                this.mediator.getSecondaryCanvas().addCurrentStructure(this.structuresSelected.get(0));
                structures.add(this.structuresSelected.get(0));
                for (int i = 1; i < this.structuresSelected.size(); ++i) {
                    this.mediator.getSecondaryCanvas().addShiftCurrentStructure(this.structuresSelected.get(i));
                    structures.add(this.structuresSelected.get(i));
                }
            }
            this.structuresSelected.clear();
        }
    }

    @Override
    Rna2DElement getWrapper(Residue residue) {
        if (this.mediator.getSecondaryCanvas() != null) {
            Model2D model2D = this.mediator.getSecondaryCanvas().getModel2D();
            for (Rna2D rna : model2D.getRnas()) {
                if (!residue.getMoleculeId().equals((Object)rna.getRnaMolecule().getParadiseID())) continue;
                for (Helix2D h : rna.getHelices()) {
                    if ((residue.getAbsolutePosition() < h.get5PrimeEnds()[0].getAbsolutePosition() || residue.getAbsolutePosition() >= h.get5PrimeEnds()[0].getAbsolutePosition() + h.getLength()) && (residue.getAbsolutePosition() < h.get5PrimeEnds()[1].getAbsolutePosition() || residue.getAbsolutePosition() >= h.get5PrimeEnds()[1].getAbsolutePosition() + h.getLength())) continue;
                    return h;
                }
                for (Sstrand2D ss : rna.getStrands()) {
                    if (residue.getAbsolutePosition() < ss.getBase5().getAbsolutePosition() || residue.getAbsolutePosition() > ss.getBase3().getAbsolutePosition()) continue;
                    return ss;
                }
            }
        }
        return null;
    }

    @Override
    public void select(SecondaryCanvas canvas, List<Residue2D> residues) {
        canvas.clearAllSelections();
        for (Residue2D r2D : residues) {
            if (r2D.getStructuralDomain() == null) continue;
            canvas.addShiftCurrentStructure(r2D.getStructuralDomain());
        }
    }
}

