/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.filechooser.FileFilter;

public class IoUtils {
    public static final String xml = "xml";
    public static final String pdb = "pdb";
    public static final String svg = "svg";
    public static final String png = "png";
    public static final String rnaml = "rnaml";
    public static final String fasta = "fasta";
    public static final String jython = "py";
    public static final String layout = "layout";

    public static String getExtension(File f) {
        StringBuffer ext = new StringBuffer();
        char[] letters = f.getName().toCharArray();
        for (int i = letters.length - 1; i >= 0 && letters[i] != '.'; --i) {
            ext.append(letters[i]);
        }
        return ext.reverse().toString();
    }

    public static String getExtension(URI uri) {
        StringBuffer ext = new StringBuffer();
        char[] letters = IoUtils.getLastElementInURI(uri).toCharArray();
        for (int i = letters.length - 1; i >= 0 && letters[i] != '.'; --i) {
            ext.append(letters[i]);
        }
        return ext.reverse().toString();
    }

    public static String getExtension(String fileName) {
        StringBuffer ext = new StringBuffer();
        char[] letters = fileName.toCharArray();
        for (int i = letters.length - 1; i >= 0 && letters[i] != '.'; --i) {
            ext.append(letters[i]);
        }
        return ext.reverse().toString();
    }

    public static String getLastElementInURI(URI uri) {
        String[] tokens = uri.toString().split("/");
        return tokens[tokens.length - 1];
    }

    public static FileFilter getSVGFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IoUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IoUtils.svg);
                }
                return false;
            }

            public String getDescription() {
                return "SVG file";
            }
        };
    }

    public static FileFilter getS2SLayoutFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IoUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IoUtils.layout);
                }
                return false;
            }

            public String getDescription() {
                return "S2S Layout file";
            }
        };
    }

    public static FileFilter getPNGFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IoUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IoUtils.png);
                }
                return false;
            }

            public String getDescription() {
                return "PNG file";
            }
        };
    }

    public static FileFilter getPDBFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IoUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IoUtils.pdb);
                }
                return false;
            }

            public String getDescription() {
                return "PDB files";
            }
        };
    }

    public static FileFilter getXMLFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IoUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IoUtils.rnaml) || extension.equals(IoUtils.xml);
                }
                return false;
            }

            public String getDescription() {
                return "RnaML files";
            }
        };
    }

    public static FileFilter getScriptFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IoUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IoUtils.jython);
                }
                return false;
            }

            public String getDescription() {
                return "Jython scripts";
            }
        };
    }

    public static FileFilter getAlignmentFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IoUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IoUtils.fasta);
                }
                return false;
            }

            public String getDescription() {
                return "Fasta files";
            }
        };
    }

    public static boolean isKnownFile(File f) {
        return IoUtils.getXMLFilter().accept(f) || IoUtils.getAlignmentFilter().accept(f) || IoUtils.getPDBFilter().accept(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String fileName, InputStream in) {
        File f = new File(fileName);
        FilterOutputStream fOut = null;
        try {
            fOut = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                ((BufferedOutputStream)fOut).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                fOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class CommandLineProgressBar {
        private Timer timer;

        private CommandLineProgressBar() {
        }

        private void start() {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new ProgressionTask(), 0L, 2000L);
        }

        private void stop() {
            this.timer.cancel();
        }

        private class ProgressionTask
        extends TimerTask {
            private ProgressionTask() {
            }

            public void run() {
                System.out.print(".");
            }
        }
    }
}

