/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.event.AtomListener;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.utils.TBMath;
import fr.unistra.ibmc.paradise.goloka.utils.matrix.Matrix;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atom
extends AbstractDrawable {
    private Residue3D.Atom paradiseAtom;
    private static int ID = 0;
    private Residue residue;
    private int nb;
    private int objId = 0;
    private String name;
    private float x;
    private float y;
    private float z;
    private float savedX;
    private float savedY;
    private float savedZ;
    private OpenGLColor color = new OpenGLColor(255, 255, 255);
    private OpenGLColor defaultColor = new OpenGLColor(255, 255, 255);
    private float covalence = 0.6f;
    private float vdw = 1.2f;
    private transient Vector<AtomListener> atomListeners;
    private String atomCode = "";

    public Atom(Mediator mediator, Residue3D.Atom atom, Residue residue, int atomCode) {
        super(mediator);
        this.paradiseAtom = atom;
        this.nb = atom.hashCode();
        this.objId = ++ID;
        this.x = atom.getX();
        this.y = atom.getY();
        this.z = atom.getZ();
        this.name = atom.getName();
        switch (atomCode) {
            case 6: {
                this.atomCode = "C";
                this.defaultColor = new OpenGLColor(Color.gray);
                this.covalence = 0.77f;
                this.vdw = 1.7f;
                break;
            }
            case 7: {
                this.atomCode = "N";
                this.defaultColor = new OpenGLColor(Color.blue);
                this.covalence = 0.73f;
                this.vdw = 1.55f;
                break;
            }
            case 8: {
                this.atomCode = "O";
                this.defaultColor = new OpenGLColor(Color.red);
                this.covalence = 0.75f;
                this.vdw = 1.52f;
                break;
            }
            case 15: {
                this.atomCode = "P";
                this.defaultColor = new OpenGLColor(Color.orange);
                this.covalence = 1.06f;
                this.vdw = 1.8f;
                break;
            }
            case 16: {
                this.atomCode = "S";
                this.defaultColor = new OpenGLColor(Color.yellow);
                this.covalence = 1.02f;
                this.vdw = 1.8f;
                break;
            }
            default: {
                this.atomCode = "H";
                this.defaultColor = new OpenGLColor(Color.white);
                this.covalence = 0.37f;
                this.vdw = 1.2f;
            }
        }
        this.color = new OpenGLColor(this.defaultColor.getR(), this.defaultColor.getG(), this.defaultColor.getB());
        this.residue = residue;
        this.residue.add(this);
    }

    public boolean isDisplayed() {
        return this.renderingMode != 7;
    }

    public OpenGLColor getDefaultColor() {
        return this.defaultColor;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setVdw(float vdw) {
        this.vdw = vdw;
    }

    public String getAtomCode() {
        return this.atomCode;
    }

    public int getObjId() {
        return this.objId;
    }

    public int getNumber() {
        return this.nb;
    }

    public void setNumber(int nb) {
        this.nb = nb;
    }

    public synchronized void addAtomListener(AtomListener l) {
        if (this.atomListeners == null) {
            this.atomListeners = new Vector();
        }
        this.atomListeners.addElement(l);
    }

    public void restoreCoord() {
        this.x = this.savedX;
        this.y = this.savedY;
        this.z = this.savedZ;
    }

    public synchronized void removeAtomListener(AtomListener l) {
        if (this.atomListeners == null) {
            this.atomListeners = new Vector();
        }
        this.atomListeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAtomMoved() {
        if (this.atomListeners != null && !this.atomListeners.isEmpty()) {
            Vector targets;
            Atom atom = this;
            synchronized (atom) {
                targets = (Vector)this.atomListeners.clone();
            }
            for (AtomListener l : targets) {
                l.atomMoved();
            }
        }
    }

    public float[] getFloat() {
        return new float[]{this.x, this.y, this.z};
    }

    public void setCoord(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String getName() {
        return this.name;
    }

    public void drawSelection(GL gl) {
        switch (this.residue.getRenderingMode()) {
            case 1: 
            case 7: {
                this.mediator.getRenderer().drawSelectionSphere(gl, this.getFloat(), this.color.getRGBOpenGl(), 0.2f);
                break;
            }
            case 5: {
                this.mediator.getRenderer().drawSelectionSphere(gl, this.getFloat(), this.color.getRGBOpenGl(), 1.25f * this.vdw);
                break;
            }
            case 3: {
                this.mediator.getRenderer().drawSelectionSphere(gl, this.getFloat(), this.color.getRGBOpenGl(), 1.25f * this.mediator.getRenderer().getBALL_RADIUS());
                break;
            }
            case 2: {
                this.mediator.getRenderer().drawSelectionSphere(gl, this.getFloat(), this.color.getRGBOpenGl(), 1.25f * this.covalence);
            }
        }
    }

    @Override
    public void draw(GL gl) {
        if (this.isDisplayed()) {
            switch (this.renderingMode) {
                case 1: {
                    gl.glPointSize((float)this.mediator.getRenderer().getDOT_ATOM_SIZE());
                    gl.glBegin(0);
                    gl.glColor3fv(this.color.getRGBOpenGl(), 0);
                    gl.glVertex3f(this.x, this.y, this.z);
                    gl.glEnd();
                    break;
                }
                case 2: 
                case 5: {
                    gl.glEnable(2896);
                    this.drawSphereVDW(gl);
                    gl.glDisable(2896);
                    break;
                }
                case 3: {
                    gl.glEnable(2896);
                    this.drawSphere(gl);
                    gl.glDisable(2896);
                    break;
                }
            }
        }
    }

    public void drawSphereVDW(GL gl) {
        gl.glColor4f(this.color.getRGBOpenGl()[0], this.color.getRGBOpenGl()[1], this.color.getRGBOpenGl()[2], 1.0f);
        this.mediator.getRenderer().displaySphere(gl, this.covalence, this.getFloat());
        this.mediator.getRenderer().displaySphere(gl, this.vdw, this.getFloat());
    }

    public void drawSphere(GL gl) {
        gl.glColor3fv(this.color.getRGBOpenGl(), 0);
        this.mediator.getRenderer().displaySphere(gl, this.mediator.getRenderer().getBALL_RADIUS(), this.getFloat());
    }

    public void translate(float[] vector) {
        this.translate(vector[0], vector[1], vector[2]);
    }

    public void translate(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void transform(Matrix t) {
        this.x = (float)((double)this.x * t.get(0, 0) + (double)this.y * t.get(0, 1) + (double)this.z * t.get(0, 2) + t.get(0, 3));
        this.y = (float)((double)this.x * t.get(1, 0) + (double)this.y * t.get(1, 1) + (double)this.z * t.get(1, 2) + t.get(1, 3));
        this.z = (float)((double)this.x * t.get(2, 0) + (double)this.y * t.get(2, 1) + (double)this.z * t.get(2, 2) + t.get(2, 3));
    }

    public void rotateAroundLinkDegree(Link axis, float angle) {
        float ang = angle * (float)Math.PI / 180.0f;
        float[] axe = TBMath.normalized((float[])axis.getVector());
        float[] offset = axis.getSecond().getFloat();
        this.x -= offset[0];
        this.y -= offset[1];
        this.z -= offset[2];
        float rx = axe[0];
        float ry = axe[1];
        float rz = axe[2];
        float c = 1.0f - (float)Math.cos(ang);
        float s = (float)Math.sin(ang);
        float[][] matrix = new float[][]{{1.0f + c * (rx * rx - 1.0f), -rz * s + c * rx * ry, ry * s + c * rx * rz}, {rz * s + c * rx * ry, 1.0f + c * (ry * ry - 1.0f), -rx * s + c * ry * rz}, {-ry * s + c * rx * rz, rx * s + c * ry * rz, 1.0f + c * (rz * rz - 1.0f)}};
        float newX = matrix[0][0] * this.x + matrix[1][0] * this.y + matrix[2][0] * this.z;
        float newY = matrix[0][1] * this.x + matrix[1][1] * this.y + matrix[2][1] * this.z;
        float newZ = matrix[0][2] * this.x + matrix[1][2] * this.y + matrix[2][2] * this.z;
        this.x = newX + offset[0];
        this.y = newY + offset[1];
        this.z = newZ + offset[2];
    }

    public OpenGLColor getColor() {
        return this.color;
    }

    public void setColor(OpenGLColor color) {
        this.color = new OpenGLColor(color.getAWTColor());
    }

    public void setColor(Color color) {
        this.color = new OpenGLColor(color);
    }

    public void setDefaultColor() {
        this.setColor(this.getDefaultColor());
    }

    public int getAtomIndex() {
        int i = 0;
        for (Atom atom : this.residue.getAtoms()) {
            if (this == atom) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean matches(Residue3D.Atom atom) {
        return this.paradiseAtom == atom;
    }

    public void saveCoordinatesToParadise() {
        this.paradiseAtom.setCoordinates(this.x, this.y, this.z);
        this.savedX = this.x;
        this.savedY = this.y;
        this.savedZ = this.z;
    }

    public void saveCoordinates() {
        this.savedX = this.x;
        this.savedY = this.y;
        this.savedZ = this.z;
    }

    public void updateCoordinatesFromParadise() {
        this.setCoord(this.paradiseAtom.getX(), this.paradiseAtom.getY(), this.paradiseAtom.getZ());
    }

    public Residue getResidue() {
        return this.residue;
    }

    public void addAtomAtomInteraction(Atom part, char type) {
        this.removeAtomAtomInteractions(part);
        Residue3D r = this.getResidue().getResidue3D();
        Residue3D rp = part.getResidue().getResidue3D();
        Molecule m = (Molecule)r.getMolecules().iterator().next();
        Molecule mp = (Molecule)rp.getMolecules().iterator().next();
        int l = m.getAnnotation((ParadiseFeature)r).getLocation().getStart();
        int lp = mp.getAnnotation((ParadiseFeature)rp).getLocation().getStart();
        StructuralFeatureFactory factory = this.mediator.getAssemble().getStructuralFeatureFactory();
        SecondaryStructure ss = this.mediator.get3DModel().getCurrentSecondaryStructure();
        if (m.getParadiseID().equals((Object)mp.getParadiseID())) {
            if (l < lp) {
                factory.createAtomAtomInteraction(ss, this.getName(), part.getName(), type, m, new Location(l, lp));
            } else {
                factory.createAtomAtomInteraction(ss, part.getName(), this.getName(), type, m, new Location(lp, l));
            }
        } else {
            factory.createAtomAtomInteraction(ss, this.getName(), part.getName(), type, m, new Location(l), mp, new Location(lp));
        }
        this.mediator.getRenderer().reComputeNeeded();
    }

    public void removeAtomAtomInteractions(Atom part) {
        for (AtomAtomInteraction aai : this.getAtomAtomInteractions(part)) {
            for (Molecule.Annotation annotation : aai.getAnnotations()) {
                annotation.getMolecule().removeFeature((ParadiseFeature)aai);
            }
        }
        this.mediator.getRenderer().reComputeNeeded();
    }

    public Set<AtomAtomInteraction> getAtomAtomInteractions(Atom part) {
        Residue3D r = this.getResidue().getResidue3D();
        Residue3D rp = part.getResidue().getResidue3D();
        Molecule m = (Molecule)r.getMolecules().iterator().next();
        Molecule mp = (Molecule)rp.getMolecules().iterator().next();
        int l = m.getAnnotation((ParadiseFeature)r).getLocation().getStart();
        int lp = mp.getAnnotation((ParadiseFeature)rp).getLocation().getStart();
        HashSet<AtomAtomInteraction> ret = new HashSet<AtomAtomInteraction>();
        for (AtomAtomInteraction aai : this.getAtomAtomInteractions()) {
            List anns = aai.getAnnotations();
            if (m.getParadiseID().equals((Object)mp.getParadiseID()) && anns.size() == 1) {
                if (l < lp) {
                    if (aai.getAtom1().equals(this.getName()) && aai.getAtom2().equals(part.getName())) {
                        ret.add(aai);
                    }
                } else if (aai.getAtom2().equals(this.getName()) && aai.getAtom1().equals(part.getName())) {
                    ret.add(aai);
                }
            }
            if (m.getParadiseID().equals((Object)mp.getParadiseID()) || anns.size() != 2 || !((Molecule.Annotation)anns.get(0)).getMolecule().getParadiseID().equals((Object)m.getParadiseID())) continue;
            if (aai.getAtom1().equals(this.getName()) && aai.getAtom2().equals(part.getName())) {
                ret.add(aai);
                continue;
            }
            if (!aai.getAtom2().equals(this.getName()) || !aai.getAtom1().equals(part.getName())) continue;
            ret.add(aai);
        }
        return ret;
    }

    public Set<AtomAtomInteraction> getAtomAtomInteractions() {
        HashSet<AtomAtomInteraction> ret = new HashSet<AtomAtomInteraction>();
        Residue3D r = this.getResidue().getResidue3D();
        Molecule m = (Molecule)r.getMolecules().iterator().next();
        int loc = m.getAnnotation((ParadiseFeature)r).getLocation().getStart();
        for (Molecule.Annotation annotation : m.getAnnotations(AtomAtomInteraction.class)) {
            if (!new Location(loc).isIncludedIn(annotation.getLocation())) continue;
            AtomAtomInteraction aai = (AtomAtomInteraction)annotation.getFeature();
            List anns = aai.getAnnotations();
            if (anns.size() == 1) {
                Location l = ((Molecule.Annotation)anns.get(0)).getLocation();
                if (l.getStart() == loc && aai.getAtom1().equals(this.getName())) {
                    ret.add(aai);
                }
                if (l.getEnd() == loc && aai.getAtom2().equals(this.getName())) {
                    ret.add(aai);
                }
            }
            if (anns.size() != 2) continue;
            if (anns.get(0) == annotation && aai.getAtom1().equals(this.getName())) {
                ret.add(aai);
            }
            if (anns.get(1) != annotation || !aai.getAtom1().equals(this.getName())) continue;
            ret.add(aai);
        }
        return ret;
    }

    public void drawSelectScene(GL gl) {
        gl.glLoadName(this.getObjId());
        switch (this.renderingMode) {
            case 1: {
                this.mediator.getRenderer().drawSelectionSphere(gl, this.getFloat(), this.color.getRGBOpenGl(), 0.4f);
                break;
            }
            case 5: {
                this.mediator.getRenderer().drawSelectionSphere(gl, this.getFloat(), this.color.getRGBOpenGl(), 1.25f * this.vdw);
                break;
            }
            case 3: {
                this.mediator.getRenderer().drawSelectionSphere(gl, this.getFloat(), this.color.getRGBOpenGl(), 1.25f * this.mediator.getRenderer().getBALL_RADIUS());
                break;
            }
            case 2: {
                this.mediator.getRenderer().drawSelectionSphere(gl, this.getFloat(), this.color.getRGBOpenGl(), 1.25f * this.covalence);
            }
        }
    }
}

