/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomSet
extends AbstractDrawable {
    protected Set<Atom> atoms;
    public List<Atom> unknownAtoms;
    public List<Link> links;
    private OpenGLColor color = new OpenGLColor(Color.white);
    public int colorationStyle = 0;

    public AtomSet(Mediator mediator) {
        super(mediator);
        this.atoms = new HashSet<Atom>();
        this.unknownAtoms = new ArrayList<Atom>();
        this.links = new ArrayList<Link>();
    }

    public void clear() {
        this.atoms.clear();
    }

    public void restoreCoord() {
        for (Atom atom : this.atoms) {
            atom.restoreCoord();
        }
    }

    public Atom getAtom(String atomName) {
        for (Atom atom : this.atoms) {
            if (!atom.getName().equals(atomName)) continue;
            return atom;
        }
        return null;
    }

    public float[] getCenter() {
        float[] center = new float[]{0.0f, 0.0f, 0.0f};
        for (Atom atom : this.atoms) {
            float[] atc = atom.getFloat();
            for (int i = 0; i < 3; ++i) {
                int n = i;
                center[n] = center[n] + atc[i];
            }
        }
        int s = this.atoms.size();
        if (s > 0) {
            for (int i = 0; i < 3; ++i) {
                center[i] = center[i] / (float)s;
            }
        }
        return center;
    }

    public void add(Atom atom) {
        this.atoms.add(atom);
    }

    public void add(AtomSet set) {
        for (Atom atom : set.getAtoms()) {
            this.add(atom);
        }
    }

    public void removeAtom(Atom atom) {
        this.atoms.remove(atom);
    }

    public boolean containsAtom(Atom atom) {
        return this.atoms.contains(atom);
    }

    public Set<Atom> getAtoms() {
        return this.atoms;
    }

    public void add(Collection<Atom> atoms) {
        this.atoms.addAll(atoms);
    }

    public int atomsCount() {
        return this.atoms.size();
    }

    public void setResidueDefaultColor() {
        for (Atom atom : this.atoms) {
            atom.setColor(this.getStandardColor());
        }
    }

    public void setAtomsDefaultColor() {
        for (Atom atom : this.atoms) {
            atom.setDefaultColor();
        }
        this.fireRenderingModified();
    }

    public void propagateBackboneColor() {
        for (Atom atom : this.atoms) {
            atom.setColor(this.getColor());
        }
    }

    @Override
    public void draw(GL gl) {
        for (Atom atom : this.atoms) {
            atom.draw(gl);
        }
        for (Link link : this.links) {
            link.draw(gl);
        }
    }

    public void drawSelectScene(GL gl) {
        for (Atom atom : this.atoms) {
            atom.drawSelectScene(gl);
        }
    }

    public void drawSphere(GL gl) {
        for (Atom atom : this.atoms) {
            atom.drawSphere(gl);
        }
        gl.glLineWidth(1.0f);
        gl.glBegin(1);
        for (Link link : this.links) {
            link.draw(gl);
        }
        gl.glEnd();
    }

    public void translate(float x, float y, float z) {
        for (Atom atom : this.atoms) {
            atom.translate(x, y, z);
        }
    }

    public OpenGLColor getColor() {
        return this.color;
    }

    public void setColor(OpenGLColor color) {
        this.color = new OpenGLColor(color.getAWTColor());
        if (this.mediator.getRenderer().getColorationStyle() == 0) {
            this.propagateBackboneColor();
        }
    }

    public void setColor(Color color) {
        this.color = new OpenGLColor(color);
        this.propagateBackboneColor();
        this.fireRenderingModified();
    }

    public void removeLinks(Atom at) {
        ArrayList<Link> tmp = new ArrayList<Link>();
        for (Link link : this.links) {
            if (link.getFirst() != at && link.getSecond() != at) continue;
            tmp.add(link);
        }
        for (Link link : tmp) {
            this.links.remove(link);
        }
    }

    public void removeLink(Atom a1, Atom a2) {
        ArrayList<Link> tmp = new ArrayList<Link>();
        for (Link link : this.links) {
            if ((link.getFirst() != a1 || link.getSecond() != a2) && (link.getFirst() != a2 || link.getSecond() != a1)) continue;
            tmp.add(link);
        }
        for (Link link : tmp) {
            this.links.remove(link);
        }
    }
}

