/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.paradise.goloka.utils.TBMath;
import javax.media.opengl.GL;

public class Link
extends AbstractDrawable {
    private Atom a;
    private Atom b;

    public Atom getFirst() {
        return this.a;
    }

    public Atom getSecond() {
        return this.b;
    }

    public void setFirst(Atom first) {
        this.a = first;
    }

    public void setSecond(Atom second) {
        this.b = second;
    }

    public void setAtoms(Atom first, Atom second) {
        this.a = first;
        this.b = second;
    }

    public Link(Mediator mediator, Atom first, Atom second) {
        super(mediator);
        this.a = first;
        this.b = second;
    }

    public static Link createLink(Mediator mediator, Atom first, Atom second) {
        if (first == null || second == null) {
            return null;
        }
        return new Link(mediator, first, second);
    }

    public void draw(GL gl) {
        if (this.a.isDisplayed() && this.b.isDisplayed()) {
            if (this.a.renderingMode == 3 && this.b.renderingMode == 3) {
                gl.glEnable(2896);
                float[] m = TBMath.middle((float[])this.a.getFloat(), (float[])this.b.getFloat());
                gl.glColor3fv(this.a.getColor().getRGBOpenGl(), 0);
                this.mediator.getRenderer().drawCylinder(this.a.getFloat(), m, this.mediator.getRenderer().getLINK_RADIUS());
                gl.glColor3fv(this.b.getColor().getRGBOpenGl(), 0);
                this.mediator.getRenderer().drawCylinder(m, this.b.getFloat(), this.mediator.getRenderer().getLINK_RADIUS());
                gl.glDisable(2896);
            } else {
                gl.glLineWidth((float)this.mediator.getRenderer().getLINE_LINK_WIDTH());
                gl.glBegin(1);
                gl.glColor3fv(this.a.getColor().getRGBOpenGl(), 0);
                gl.glVertex3fv(this.a.getFloat(), 0);
                gl.glColor3fv(this.b.getColor().getRGBOpenGl(), 0);
                gl.glVertex3fv(this.b.getFloat(), 0);
                gl.glEnd();
            }
        }
    }

    public float[] getVector() {
        float[] fa = this.a.getFloat();
        float[] fb = this.b.getFloat();
        return new float[]{fb[0] - fa[0], fb[1] - fa[1], fb[2] - fa[2]};
    }

    public float[] getNormalizedVector() {
        return TBMath.normalized((float[])this.getVector());
    }
}

