/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.structures.Angle;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomSet;
import fr.unistra.ibmc.assemble.structures.AtomsSelection;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Residue
extends AtomSet {
    protected Chain chain;
    protected String name;
    protected boolean showBackBone = true;
    protected boolean showPlane = false;
    Link withPrevious;
    public Set<String> types = new HashSet<String>();
    private Residue prev = null;
    private Residue next = null;
    public Atom backBone = null;
    public Atom begining = null;
    public Atom ending = null;
    public Residue3D res3D;
    public ArrayList<Angle> anglesInternal = new ArrayList();
    public ArrayList<Angle> anglesDirect = new ArrayList();
    public ArrayList<Angle> anglesIndirect = new ArrayList();

    public Residue(Residue3D res3D, Mediator mediator) {
        super(mediator);
        this.res3D = res3D;
        this.name = res3D.getName();
        this.setAtomsDefaultColor();
    }

    protected void launchResidue3DParsing() {
        for (Residue3D.Atom atom : this.res3D.getAtoms()) {
            if (!atom.hasCoordinatesFilled()) continue;
            this.parseResidue3D(atom);
        }
    }

    public boolean isOfType(String type) {
        for (String type1 : this.types) {
            if (!type1.toLowerCase().equals(type.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean parseResidue3D(Residue3D.Atom var1);

    protected abstract void generateAtoms();

    protected abstract void generateInternalLinks();

    public Chain getChain() {
        return this.chain;
    }

    public void setChain(Chain chain) {
        this.chain = chain;
    }

    public void setBackBoneDisplayed(boolean b) {
        this.showBackBone = b;
        this.fireRenderingModified();
    }

    public boolean isBackBoneDisplayed() {
        return this.showBackBone;
    }

    public boolean isPlaneDisplayed() {
        return this.showPlane;
    }

    public void setPlaneDisplayed(boolean showPlane) {
        this.showPlane = showPlane;
        this.fireRenderingModified();
    }

    public void setName(String s) {
        this.name = s;
        this.fireRenderingModified();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void draw(GL gl) {
        super.draw(gl);
        if (this.showBackBone && this.renderingMode != 7) {
            this.drawBackBone(gl);
        }
    }

    public void drawBackBone(GL gl) {
        gl.glLineWidth((float)this.mediator.getRenderer().getLINE_BACKBONE_WIDTH());
        if (this.getPrev() != null && this.getPrev().backBone != null && this.backBone != null) {
            gl.glBegin(1);
            gl.glColor3fv(this.getPrev().getColor().getRGBOpenGl(), 0);
            gl.glVertex3fv(this.getPrev().backBone.getFloat(), 0);
            gl.glColor3fv(this.getColor().getRGBOpenGl(), 0);
            gl.glVertex3fv(this.backBone.getFloat(), 0);
            gl.glEnd();
        }
    }

    public void drawBackBoneAsRod(GL gl) {
        gl.glLineWidth((float)this.mediator.getRenderer().getLINE_BACKBONE_WIDTH());
        if (this.getPrev() != null) {
            float[] a = this.getPrev().backBone.getFloat();
            float[] b = this.backBone.getFloat();
            float[] c = new float[]{(a[0] + b[0]) / 2.0f, (a[1] + b[1]) / 2.0f, (a[2] + b[2]) / 2.0f};
            gl.glColor3fv(this.getPrev().getColor().getRGBOpenGl(), 0);
            this.mediator.getRenderer().displaySphere(gl, this.mediator.getRenderer().getBB_RADIUS(), a);
            this.mediator.getRenderer().drawCylinder(a, c, this.mediator.getRenderer().getBB_RADIUS());
            gl.glColor3fv(this.getColor().getRGBOpenGl(), 0);
            this.mediator.getRenderer().drawCylinder(c, b, this.mediator.getRenderer().getBB_RADIUS());
            this.mediator.getRenderer().displaySphere(gl, this.mediator.getRenderer().getBB_RADIUS(), b);
        }
    }

    public int getNumber() {
        return ((Molecule.Annotation)this.getResidue3D().getAnnotations().get(0)).getLocation().getStart();
    }

    public abstract void generateInternalAngles();

    public abstract void generatePreviousAngles();

    public abstract void generateNextAngles();

    public void generatePreviousLinks() {
        this.links.remove(this.withPrevious);
        if (this.getPrev() != null && this.getPrev().ending != null && this.begining != null) {
            this.withPrevious = new Link(this.mediator, this.begining, this.getPrev().ending);
            this.links.add(this.withPrevious);
        } else {
            this.withPrevious = null;
        }
    }

    public abstract void generateNextLinks();

    public void addPreviousToSelection(AtomsSelection sel) {
        if (this.getPrev() != null) {
            sel.add(this.getPrev());
            this.getPrev().addPreviousToSelection(sel);
        }
    }

    public void addNextToSelection(AtomsSelection sel) {
        if (this.getNext() != null) {
            sel.add(this.getNext());
            this.getNext().addNextToSelection(sel);
        }
    }

    public Residue getPrev() {
        return this.prev;
    }

    public void setPrev(Residue prev) {
        this.prev = prev;
        this.generatePreviousLinks();
        this.generatePreviousAngles();
    }

    public Residue getNext() {
        return this.next;
    }

    public void setNext(Residue next) {
        this.next = next;
        this.generateNextLinks();
        this.generateNextAngles();
    }

    public int getResidueIndex() {
        int i = 0;
        for (Residue residue : this.chain.getResidues()) {
            if (this == residue) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void deleteAtom(Atom atom, boolean propagate) {
        for (Angle angle : this.anglesDirect) {
            angle.remove(atom);
        }
        for (Angle angle : this.anglesIndirect) {
            angle.remove(atom);
        }
        for (Angle angle : this.anglesInternal) {
            angle.remove(atom);
        }
        this.removeLinks(atom);
        if (this.getNext() != null && propagate) {
            this.getNext().deleteAtom(atom, false);
        }
        if (this.withPrevious != null && propagate && (this.withPrevious.getFirst() == atom || this.withPrevious.getSecond() == atom)) {
            this.withPrevious = null;
        }
        this.removeAtom(atom);
        Atom at = null;
        try {
            at = this.getAtoms().iterator().next();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.atomsCount() > 0) {
            if (this.begining == atom) {
                this.begining = at;
            }
            if (this.ending == atom) {
                this.ending = at;
            }
            if (this.backBone == atom) {
                this.backBone = at;
            }
        }
    }

    public Residue3D getResidue3D() {
        return this.res3D;
    }

    public Atom getAtomFor(Residue3D.Atom paradiseAtom) {
        for (Atom atom : this.getAtoms()) {
            if (!atom.matches(paradiseAtom)) continue;
            return atom;
        }
        return null;
    }

    public boolean matches(Residue3D paradiseResidue) {
        return this.res3D == paradiseResidue;
    }

    public void saveCoordinatesToParadise() {
        for (Atom atom : this.getAtoms()) {
            atom.saveCoordinatesToParadise();
        }
    }

    public void updateCoordinatesFromParadise() {
        for (Atom atom : this.getAtoms()) {
            atom.updateCoordinatesFromParadise();
        }
    }

    public static List<Residue> order(List<Residue> residues) {
        ArrayList<Residue> ret = new ArrayList<Residue>();
        for (Residue r : residues) {
            boolean added = false;
            for (Residue tmp : ret) {
                if (!r.before(tmp)) continue;
                ret.add(ret.indexOf(tmp), r);
                added = true;
                break;
            }
            if (added) continue;
            ret.add(r);
        }
        return ret;
    }

    public boolean before(Residue r) {
        Chain c2;
        Chain c1 = this.getChain();
        if (c1 == (c2 = r.getChain())) {
            return c1.getResidues().indexOf(this) <= c2.getResidues().indexOf(r);
        }
        return c1.before(c2);
    }
}

