/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import java.awt.Color;

public class AsnSC
extends SideChain {
    Atom CB;
    Atom H1B;
    Atom H2B;
    Atom CG;
    Atom OD1;
    Atom ND2;
    Atom H1D2;
    Atom H2D2;
    Link CBH1B;
    Link CBH2B;
    Link CBCG;
    Link CGOD1;
    Link CGND2;
    Link ND2H1D2;
    Link ND2H2D2;
    private static OpenGLColor standardColor = new OpenGLColor(Color.MAGENTA);

    public AsnSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HB")) {
            this.H1B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HB")) {
            this.H2B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG")) {
            this.CG = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("OD1")) {
            this.OD1 = new Atom(this.mediator, atom, this.residue, 8);
            return true;
        }
        if (name.equals("ND2")) {
            this.ND2 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("1HD2")) {
            this.H1D2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HD2")) {
            this.H2D2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.H1B != null) {
            this.add(this.H1B);
        }
        if (this.H2B != null) {
            this.add(this.H2B);
        }
        if (this.CG != null) {
            this.add(this.CG);
        }
        if (this.OD1 != null) {
            this.add(this.OD1);
        }
        if (this.ND2 != null) {
            this.add(this.ND2);
        }
        if (this.H1D2 != null) {
            this.add(this.H1D2);
        }
        if (this.H2D2 != null) {
            this.add(this.H2D2);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.H1B);
        this.CBH2B = Link.createLink(this.mediator, this.CB, this.H2B);
        this.CBCG = Link.createLink(this.mediator, this.CB, this.CG);
        this.CGOD1 = Link.createLink(this.mediator, this.CG, this.OD1);
        this.CGND2 = Link.createLink(this.mediator, this.CG, this.ND2);
        this.ND2H1D2 = Link.createLink(this.mediator, this.ND2, this.H1D2);
        this.ND2H2D2 = Link.createLink(this.mediator, this.ND2, this.H2D2);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if (this.CBH2B != null) {
            this.links.add(this.CBH2B);
        }
        if (this.CBCG != null) {
            this.links.add(this.CBCG);
        }
        if (this.CGOD1 != null) {
            this.links.add(this.CGOD1);
        }
        if (this.CGND2 != null) {
            this.links.add(this.CGND2);
        }
        if (this.ND2H1D2 != null) {
            this.links.add(this.ND2H1D2);
        }
        if (this.ND2H2D2 != null) {
            this.links.add(this.ND2H2D2);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

