/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import java.awt.Color;

public class AspSC
extends SideChain {
    Atom CB;
    Atom H1B;
    Atom H2B;
    Atom CG;
    Atom OD1;
    Atom OD2;
    Atom HD2;
    Link CBH1B;
    Link CBH2B;
    Link CBCG;
    Link CGOD1;
    Link CGOD2;
    Link OD2HD2;
    private static OpenGLColor standardColor = new OpenGLColor(Color.RED);

    public AspSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HB")) {
            this.H1B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HB")) {
            this.H2B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG")) {
            this.CG = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("OD1")) {
            this.OD1 = new Atom(this.mediator, atom, this.residue, 8);
            return true;
        }
        if (name.equals("OD2")) {
            this.OD2 = new Atom(this.mediator, atom, this.residue, 8);
            return true;
        }
        if (name.equals("HD2")) {
            this.HD2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.H1B != null) {
            this.add(this.H1B);
        }
        if (this.H2B != null) {
            this.add(this.H2B);
        }
        if (this.CG != null) {
            this.add(this.CG);
        }
        if (this.OD1 != null) {
            this.add(this.OD1);
        }
        if (this.OD2 != null) {
            this.add(this.OD2);
        }
        if (this.HD2 != null) {
            this.add(this.HD2);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.H1B);
        this.CBH2B = Link.createLink(this.mediator, this.CB, this.H2B);
        this.CBCG = Link.createLink(this.mediator, this.CB, this.CG);
        this.CGOD1 = Link.createLink(this.mediator, this.CG, this.OD1);
        this.CGOD2 = Link.createLink(this.mediator, this.CG, this.OD2);
        this.OD2HD2 = Link.createLink(this.mediator, this.OD2, this.HD2);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if (this.CBH2B != null) {
            this.links.add(this.CBH2B);
        }
        if (this.CBCG != null) {
            this.links.add(this.CBCG);
        }
        if (this.CGOD1 != null) {
            this.links.add(this.CGOD1);
        }
        if (this.CGOD2 != null) {
            this.links.add(this.CGOD2);
        }
        if (this.OD2HD2 != null) {
            this.links.add(this.OD2HD2);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

