/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import java.awt.Color;

public class IleSC
extends SideChain {
    Atom CB;
    Atom HB;
    Atom CG2;
    Atom H1G2;
    Atom H2G2;
    Atom H3G2;
    Atom CG1;
    Atom H1G1;
    Atom H2G1;
    Atom CD1;
    Atom H1D1;
    Atom H2D1;
    Atom H3D1;
    Link CBHB;
    Link CBCG2;
    Link CG2H1G2;
    Link CG2H2G2;
    Link CG2H3G2;
    Link CBCG1;
    Link CG1H1G1;
    Link CG1H2G1;
    Link CG1CD1;
    Link CDH1D1;
    Link CDH2D1;
    Link CDH3D1;
    private static OpenGLColor standardColor = new OpenGLColor(Color.GREEN);

    public IleSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HB")) {
            this.HB = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG2")) {
            this.CG2 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HG2")) {
            this.H1G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HG2")) {
            this.H2G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HG2")) {
            this.H3G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG1")) {
            this.CG1 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HG1")) {
            this.H1G1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HG1")) {
            this.H2G1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CD1")) {
            this.CD1 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HD1")) {
            this.H1D1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HD1")) {
            this.H2D1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HD1")) {
            this.H3D1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.HB != null) {
            this.add(this.HB);
        }
        if (this.CG2 != null) {
            this.add(this.CG2);
        }
        if (this.H1G2 != null) {
            this.add(this.H1G2);
        }
        if (this.H2G2 != null) {
            this.add(this.H2G2);
        }
        if (this.H3G2 != null) {
            this.add(this.H3G2);
        }
        if (this.CG1 != null) {
            this.add(this.CG1);
        }
        if (this.H1G1 != null) {
            this.add(this.H1G1);
        }
        if (this.H2G1 != null) {
            this.add(this.H2G1);
        }
        if (this.CD1 != null) {
            this.add(this.CD1);
        }
        if (this.H1D1 != null) {
            this.add(this.H1D1);
        }
        if (this.H2D1 != null) {
            this.add(this.H2D1);
        }
        if (this.H3D1 != null) {
            this.add(this.H3D1);
        }
    }

    public void generateInternalLinks() {
        this.CBHB = Link.createLink(this.mediator, this.CB, this.HB);
        this.CBCG2 = Link.createLink(this.mediator, this.CB, this.CG2);
        this.CG2H1G2 = Link.createLink(this.mediator, this.CG2, this.H1G2);
        this.CG2H2G2 = Link.createLink(this.mediator, this.CG2, this.H2G2);
        this.CG2H3G2 = Link.createLink(this.mediator, this.CG2, this.H3G2);
        this.CBCG1 = Link.createLink(this.mediator, this.CB, this.CG1);
        this.CG1H1G1 = Link.createLink(this.mediator, this.CG1, this.H1G1);
        this.CG1H2G1 = Link.createLink(this.mediator, this.CG1, this.H2G1);
        this.CG1CD1 = Link.createLink(this.mediator, this.CG1, this.CD1);
        this.CDH1D1 = Link.createLink(this.mediator, this.CD1, this.H1D1);
        this.CDH2D1 = Link.createLink(this.mediator, this.CD1, this.H2D1);
        this.CDH3D1 = Link.createLink(this.mediator, this.CD1, this.H3D1);
        if (this.CBHB != null) {
            this.links.add(this.CBHB);
        }
        if (this.CBCG2 != null) {
            this.links.add(this.CBCG2);
        }
        if (this.CG2H1G2 != null) {
            this.links.add(this.CG2H1G2);
        }
        if (this.CG2H2G2 != null) {
            this.links.add(this.CG2H2G2);
        }
        if (this.CG2H3G2 != null) {
            this.links.add(this.CG2H3G2);
        }
        if (this.CBCG1 != null) {
            this.links.add(this.CBCG1);
        }
        if (this.CG1H1G1 != null) {
            this.links.add(this.CG1H1G1);
        }
        if (this.CG1H2G1 != null) {
            this.links.add(this.CG1H2G1);
        }
        if (this.CG1CD1 != null) {
            this.links.add(this.CG1CD1);
        }
        if (this.CDH1D1 != null) {
            this.links.add(this.CDH1D1);
        }
        if (this.CDH2D1 != null) {
            this.links.add(this.CDH2D1);
        }
        if (this.CDH3D1 != null) {
            this.links.add(this.CDH3D1);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

