/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import java.awt.Color;

public class MetSC
extends SideChain {
    Atom CB;
    Atom H1B;
    Atom H2B;
    Atom CG;
    Atom H1G;
    Atom H2G;
    Atom SD;
    Atom CE;
    Atom H1E;
    Atom H2E;
    Atom H3E;
    Link CBH1B;
    Link CBH2B;
    Link CBCG;
    Link CGH1G;
    Link CGH2G;
    Link CGSD;
    Link SDCE;
    Link CEH1E;
    Link CEH2E;
    Link CEH3E;
    private static OpenGLColor standardColor = new OpenGLColor(Color.GREEN);

    public MetSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HB")) {
            this.H1B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HB")) {
            this.H2B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG")) {
            this.CG = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HG")) {
            this.H1G = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HG")) {
            this.H2G = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("SD")) {
            this.SD = new Atom(this.mediator, atom, this.residue, 16);
            return true;
        }
        if (name.equals("CE")) {
            this.CE = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HE")) {
            this.H1E = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HE")) {
            this.H2E = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HE")) {
            this.H3E = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.H1B != null) {
            this.add(this.H1B);
        }
        if (this.H2B != null) {
            this.add(this.H2B);
        }
        if (this.CG != null) {
            this.add(this.CG);
        }
        if (this.H1G != null) {
            this.add(this.H1G);
        }
        if (this.H2G != null) {
            this.add(this.H2G);
        }
        if (this.SD != null) {
            this.add(this.SD);
        }
        if (this.CE != null) {
            this.add(this.CE);
        }
        if (this.H1E != null) {
            this.add(this.H1E);
        }
        if (this.H2E != null) {
            this.add(this.H2E);
        }
        if (this.H3E != null) {
            this.add(this.H3E);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.H1B);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if ((this.CBH2B = Link.createLink(this.mediator, this.CB, this.H2B)) != null) {
            this.links.add(this.CBH2B);
        }
        if ((this.CBCG = Link.createLink(this.mediator, this.CB, this.CG)) != null) {
            this.links.add(this.CBCG);
        }
        if ((this.CGH1G = Link.createLink(this.mediator, this.CG, this.H1G)) != null) {
            this.links.add(this.CGH1G);
        }
        if ((this.CGH2G = Link.createLink(this.mediator, this.CG, this.H2G)) != null) {
            this.links.add(this.CGH2G);
        }
        if ((this.CGSD = Link.createLink(this.mediator, this.CG, this.SD)) != null) {
            this.links.add(this.CGSD);
        }
        if ((this.SDCE = Link.createLink(this.mediator, this.SD, this.CE)) != null) {
            this.links.add(this.SDCE);
        }
        if ((this.CEH1E = Link.createLink(this.mediator, this.CE, this.H1E)) != null) {
            this.links.add(this.CEH1E);
        }
        if ((this.CEH2E = Link.createLink(this.mediator, this.CE, this.H2E)) != null) {
            this.links.add(this.CEH2E);
        }
        if ((this.CEH3E = Link.createLink(this.mediator, this.CE, this.H3E)) != null) {
            this.links.add(this.CEH3E);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

