/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import java.awt.Color;

public class SerSC
extends SideChain {
    Atom CB;
    Atom H1B;
    Atom H2B;
    Atom OG;
    Atom HG;
    Link CBH1B;
    Link CBH2B;
    Link CBOG;
    Link OGHG;
    private static OpenGLColor standardColor = new OpenGLColor(Color.MAGENTA);

    public SerSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HB")) {
            this.H1B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HB")) {
            this.H2B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("OG")) {
            this.OG = new Atom(this.mediator, atom, this.residue, 8);
            return true;
        }
        if (name.equals("HG")) {
            this.HG = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.H1B != null) {
            this.add(this.H1B);
        }
        if (this.H2B != null) {
            this.add(this.H2B);
        }
        if (this.OG != null) {
            this.add(this.OG);
        }
        if (this.HG != null) {
            this.add(this.HG);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.H1B);
        this.CBH2B = Link.createLink(this.mediator, this.CB, this.H2B);
        this.CBOG = Link.createLink(this.mediator, this.CB, this.OG);
        this.OGHG = Link.createLink(this.mediator, this.OG, this.HG);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if (this.CBH2B != null) {
            this.links.add(this.CBH2B);
        }
        if (this.CBOG != null) {
            this.links.add(this.CBOG);
        }
        if (this.OGHG != null) {
            this.links.add(this.OGHG);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

