/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.nucleicAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.Base;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import java.awt.Color;
import javax.media.opengl.GL;

public class Adenine
extends Base {
    Atom N9 = null;
    Atom C8 = null;
    Atom HC8 = null;
    Atom N7 = null;
    Atom C5 = null;
    Atom C6 = null;
    Atom N6 = null;
    Atom H1N6 = null;
    Atom H2N6 = null;
    Atom N1 = null;
    Atom C2 = null;
    Atom HC2 = null;
    Atom N3 = null;
    Atom C4 = null;
    Link N9C8 = null;
    Link C8HC8 = null;
    Link C8N7 = null;
    Link N7C5 = null;
    Link C5C6 = null;
    Link C6N6 = null;
    Link N6H1N6 = null;
    Link N6H2N6 = null;
    Link C6N1 = null;
    Link N1C2 = null;
    Link C2HC2 = null;
    Link C2N3 = null;
    Link N3C4 = null;
    Link C4C5 = null;
    Link C4N9 = null;
    private static OpenGLColor standardColor = new OpenGLColor(Color.RED);

    public Adenine(Residue r, Mediator mediator) {
        super(mediator);
        this.setColor(standardColor);
        this.residue = r;
        this.residue.types.add("Adenine");
        this.residue.types.add("A");
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("N9")) {
            this.firstChi = this.N9 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("C8")) {
            this.C8 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("H8")) {
            this.HC8 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("N7")) {
            this.N7 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("C5")) {
            this.C5 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("C6")) {
            this.C6 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("N6")) {
            this.N6 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("1H6")) {
            this.H1N6 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2H6")) {
            this.H2N6 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("N1")) {
            this.N1 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("C2")) {
            this.C2 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("H2")) {
            this.HC2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("N3")) {
            this.N3 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("C4")) {
            this.secondChi = this.C4 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        return false;
    }

    public void generateInternalLinks() {
        this.N9C8 = Link.createLink(this.mediator, this.N9, this.C8);
        this.C8HC8 = Link.createLink(this.mediator, this.C8, this.HC8);
        this.C8N7 = Link.createLink(this.mediator, this.C8, this.N7);
        this.N7C5 = Link.createLink(this.mediator, this.N7, this.C5);
        this.C5C6 = Link.createLink(this.mediator, this.C5, this.C6);
        this.C6N6 = Link.createLink(this.mediator, this.C6, this.N6);
        this.N6H1N6 = Link.createLink(this.mediator, this.N6, this.H1N6);
        this.N6H2N6 = Link.createLink(this.mediator, this.N6, this.H2N6);
        this.C6N1 = Link.createLink(this.mediator, this.C6, this.N1);
        this.N1C2 = Link.createLink(this.mediator, this.N1, this.C2);
        this.C2HC2 = Link.createLink(this.mediator, this.C2, this.HC2);
        this.C2N3 = Link.createLink(this.mediator, this.C2, this.N3);
        this.N3C4 = Link.createLink(this.mediator, this.N3, this.C4);
        this.C4C5 = Link.createLink(this.mediator, this.C4, this.C5);
        this.C4N9 = Link.createLink(this.mediator, this.C4, this.N9);
        if (this.N9C8 != null) {
            this.links.add(this.N9C8);
        }
        if (this.C8HC8 != null) {
            this.links.add(this.C8HC8);
        }
        if (this.C8N7 != null) {
            this.links.add(this.C8N7);
        }
        if (this.N7C5 != null) {
            this.links.add(this.N7C5);
        }
        if (this.C5C6 != null) {
            this.links.add(this.C5C6);
        }
        if (this.C6N6 != null) {
            this.links.add(this.C6N6);
        }
        if (this.N6H1N6 != null) {
            this.links.add(this.N6H1N6);
        }
        if (this.N6H2N6 != null) {
            this.links.add(this.N6H2N6);
        }
        if (this.C6N1 != null) {
            this.links.add(this.C6N1);
        }
        if (this.N1C2 != null) {
            this.links.add(this.N1C2);
        }
        if (this.C2HC2 != null) {
            this.links.add(this.C2HC2);
        }
        if (this.C2N3 != null) {
            this.links.add(this.C2N3);
        }
        if (this.N3C4 != null) {
            this.links.add(this.N3C4);
        }
        if (this.C4C5 != null) {
            this.links.add(this.C4C5);
        }
        if (this.C4N9 != null) {
            this.links.add(this.C4N9);
        }
    }

    public void generateAtoms() {
        if (this.N9 != null) {
            this.add(this.N9);
            this.firstChi = this.N9;
        }
        if (this.C8 != null) {
            this.add(this.C8);
        }
        if (this.HC8 != null) {
            this.add(this.HC8);
        }
        if (this.N7 != null) {
            this.add(this.N7);
        }
        if (this.C5 != null) {
            this.add(this.C5);
        }
        if (this.C6 != null) {
            this.add(this.C6);
        }
        if (this.N6 != null) {
            this.add(this.N6);
        }
        if (this.H1N6 != null) {
            this.add(this.H1N6);
        }
        if (this.H2N6 != null) {
            this.add(this.H2N6);
        }
        if (this.N1 != null) {
            this.add(this.N1);
        }
        if (this.C2 != null) {
            this.add(this.C2);
        }
        if (this.HC2 != null) {
            this.add(this.HC2);
        }
        if (this.N3 != null) {
            this.add(this.N3);
        }
        if (this.C4 != null) {
            this.add(this.C4);
            this.secondChi = this.C4;
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }

    public void drawPlane(GL gl) {
        gl.glBegin(9);
        gl.glColor3fv(this.getStandardColor().getRGBOpenGl(), 0);
        gl.glVertex3fv(this.N1.getFloat(), 0);
        gl.glVertex3fv(this.C2.getFloat(), 0);
        gl.glVertex3fv(this.N3.getFloat(), 0);
        gl.glVertex3fv(this.C4.getFloat(), 0);
        gl.glVertex3fv(this.C5.getFloat(), 0);
        gl.glVertex3fv(this.C6.getFloat(), 0);
        gl.glEnd();
        gl.glBegin(9);
        gl.glVertex3fv(this.N9.getFloat(), 0);
        gl.glVertex3fv(this.C8.getFloat(), 0);
        gl.glVertex3fv(this.N7.getFloat(), 0);
        gl.glVertex3fv(this.C5.getFloat(), 0);
        gl.glVertex3fv(this.C4.getFloat(), 0);
        gl.glEnd();
        gl.glBegin(9);
        gl.glVertex3fv(this.C6.getFloat(), 0);
        gl.glVertex3fv(this.C5.getFloat(), 0);
        gl.glVertex3fv(this.C4.getFloat(), 0);
        gl.glVertex3fv(this.N3.getFloat(), 0);
        gl.glVertex3fv(this.C2.getFloat(), 0);
        gl.glVertex3fv(this.N1.getFloat(), 0);
        gl.glEnd();
        gl.glBegin(9);
        gl.glVertex3fv(this.C4.getFloat(), 0);
        gl.glVertex3fv(this.C5.getFloat(), 0);
        gl.glVertex3fv(this.N7.getFloat(), 0);
        gl.glVertex3fv(this.C8.getFloat(), 0);
        gl.glVertex3fv(this.N9.getFloat(), 0);
        gl.glEnd();
    }
}

