/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.nucleicAcids;

import Jama.Matrix;
import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.ChooseDominant;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.gui.event.AtomListener;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Angle;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomSet;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.AdenineRNA;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.Base;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.CytosineRNA;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.GuanineRNA;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.SugarPhosphate;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.UridineRNA;
import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.Uridine3D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResidueNA
extends Residue
implements AtomListener {
    public SugarPhosphate sugar;
    public Base base;
    public Link sugarBase = null;
    Angle alpha53;
    Angle beta53;
    Angle gamma53;
    Angle epsilon53;
    Angle zeta53;
    Angle alpha35;
    Angle beta35;
    Angle gamma35;
    Angle epsilon35;
    Angle zeta35;
    Angle chi;
    public Atom C1prim;
    public Atom C2prim;
    public Atom C3prim;
    public Atom C4prim;
    public Atom O4prim;

    public static ResidueNA createResidueNA(Residue3D residue3D, Mediator mediator) {
        if (residue3D instanceof Adenine3D) {
            return new AdenineRNA((Adenine3D)residue3D, mediator);
        }
        if (residue3D instanceof Cytosine3D) {
            return new CytosineRNA((Cytosine3D)residue3D, mediator);
        }
        if (residue3D instanceof Guanine3D) {
            return new GuanineRNA((Guanine3D)residue3D, mediator);
        }
        if (residue3D instanceof Uridine3D) {
            return new UridineRNA((Uridine3D)residue3D, mediator);
        }
        System.err.println("Unknown residue3D for Assemble: " + residue3D.getClass().getName());
        return null;
    }

    public Matrix getStackBeforeMatrix(ResidueNA residue) {
        float ap = -0.51939f;
        float bp = 1.70925f;
        float cp = -1.08467f;
        float ao1 = -0.60246f;
        float bo1 = 0.530618f;
        float co1 = -0.883508f;
        float ao2 = -1.52441f;
        float bo2 = 4.57711f;
        float co2 = -1.77632f;
        float ao5 = 0.33345f;
        float bo5 = 1.29635f;
        float co5 = -1.54795f;
        float ax = this.getCoordC2()[0] - this.getCoordO3()[0];
        float bx = this.getCoordC3()[0] - this.getCoordO3()[0];
        float cx = this.getCoordC4()[0] - this.getCoordO3()[0];
        float dx = this.getCoordO3()[0];
        float ay = this.getCoordC2()[1] - this.getCoordO3()[1];
        float by = this.getCoordC3()[1] - this.getCoordO3()[1];
        float cy = this.getCoordC4()[1] - this.getCoordO3()[1];
        float dy = this.getCoordO3()[1];
        float az = this.getCoordC2()[2] - this.getCoordO3()[2];
        float bz = this.getCoordC3()[2] - this.getCoordO3()[2];
        float cz = this.getCoordC4()[2] - this.getCoordO3()[2];
        float dz = this.getCoordO3()[2];
        float px = ap * ax + bp * bx + cp * cx + dx;
        float py = ap * ay + bp * by + cp * cy + dy;
        float pz = ap * az + bp * bz + cp * cz + dz;
        float o1x = ao1 * ax + bo1 * bx + co1 * cx + dx;
        float o1y = ao1 * ay + bo1 * by + co1 * cy + dy;
        float o1z = ao1 * az + bo1 * bz + co1 * cz + dz;
        float o2x = ao2 * ax + bo2 * bx + co2 * cx + dx;
        float o2y = ao2 * ay + bo2 * by + co2 * cy + dy;
        float o2z = ao2 * az + bo2 * bz + co2 * cz + dz;
        float o5x = ao5 * ax + bo5 * bx + co5 * cx + dx;
        float o5y = ao5 * ay + bo5 * by + co5 * cy + dy;
        float o5z = ao5 * az + bo5 * bz + co5 * cz + dz;
        float[] ra = new float[]{px, py, pz};
        float[] rb = new float[]{o1x, o1y, o1z};
        float[] rc = new float[]{o2x, o2y, o2z};
        float[] rd = new float[]{o5x, o5y, o5z};
        float[] oa = residue.getCoordP();
        float[] ob = residue.getCoordO1P();
        float[] oc = residue.getCoordO2P();
        float[] od = residue.getCoordO5();
        double[][] mr = new double[][]{{ra[0], rb[0], rc[0], rd[0]}, {ra[1], rb[1], rc[1], rd[1]}, {ra[2], rb[2], rc[2], rd[2]}, {1.0, 1.0, 1.0, 1.0}};
        double[][] mo = new double[][]{{oa[0], ob[0], oc[0], od[0]}, {oa[1], ob[1], oc[1], od[1]}, {oa[2], ob[2], oc[2], od[2]}, {1.0, 1.0, 1.0, 1.0}};
        Matrix r = new Matrix((double[][])mr);
        Matrix o = new Matrix((double[][])mo);
        return o.times(r.inverse());
    }

    public Matrix getStackAfterMatrix(ResidueNA residue) {
        float ap = -0.51939f;
        float bp = 1.70925f;
        float cp = -1.08467f;
        float ao1 = -0.60246f;
        float bo1 = 0.530618f;
        float co1 = -0.883508f;
        float ao2 = -1.52441f;
        float bo2 = 4.57711f;
        float co2 = -1.77632f;
        float ao5 = 0.33345f;
        float bo5 = 1.29635f;
        float co5 = -1.54795f;
        float ax = this.getCoordC2()[0] - this.getCoordO3()[0];
        float bx = this.getCoordC3()[0] - this.getCoordO3()[0];
        float cx = this.getCoordC4()[0] - this.getCoordO3()[0];
        float dx = this.getCoordO3()[0];
        float ay = this.getCoordC2()[1] - this.getCoordO3()[1];
        float by = this.getCoordC3()[1] - this.getCoordO3()[1];
        float cy = this.getCoordC4()[1] - this.getCoordO3()[1];
        float dy = this.getCoordO3()[1];
        float az = this.getCoordC2()[2] - this.getCoordO3()[2];
        float bz = this.getCoordC3()[2] - this.getCoordO3()[2];
        float cz = this.getCoordC4()[2] - this.getCoordO3()[2];
        float dz = this.getCoordO3()[2];
        float px = ap * ax + bp * bx + cp * cx + dx;
        float py = ap * ay + bp * by + cp * cy + dy;
        float pz = ap * az + bp * bz + cp * cz + dz;
        float o1x = ao1 * ax + bo1 * bx + co1 * cx + dx;
        float o1y = ao1 * ay + bo1 * by + co1 * cy + dy;
        float o1z = ao1 * az + bo1 * bz + co1 * cz + dz;
        float o2x = ao2 * ax + bo2 * bx + co2 * cx + dx;
        float o2y = ao2 * ay + bo2 * by + co2 * cy + dy;
        float o2z = ao2 * az + bo2 * bz + co2 * cz + dz;
        float o5x = ao5 * ax + bo5 * bx + co5 * cx + dx;
        float o5y = ao5 * ay + bo5 * by + co5 * cy + dy;
        float o5z = ao5 * az + bo5 * bz + co5 * cz + dz;
        float[] ra = new float[]{px, py, pz};
        float[] rb = new float[]{o1x, o1y, o1z};
        float[] rc = new float[]{o2x, o2y, o2z};
        float[] rd = new float[]{o5x, o5y, o5z};
        float[] oa = residue.getCoordP();
        float[] ob = residue.getCoordO1P();
        float[] oc = residue.getCoordO2P();
        float[] od = residue.getCoordO5();
        double[][] mr = new double[][]{{ra[0], rb[0], rc[0], rd[0]}, {ra[1], rb[1], rc[1], rd[1]}, {ra[2], rb[2], rc[2], rd[2]}, {1.0, 1.0, 1.0, 1.0}};
        double[][] mo = new double[][]{{oa[0], ob[0], oc[0], od[0]}, {oa[1], ob[1], oc[1], od[1]}, {oa[2], ob[2], oc[2], od[2]}, {1.0, 1.0, 1.0, 1.0}};
        Matrix r = new Matrix((double[][])mr);
        Matrix o = new Matrix((double[][])mo);
        return r.times(o.inverse());
    }

    public void stackResidueAfter(ResidueNA r) {
        Matrix q = this.getStackAfterMatrix(r);
        if (q != null) {
            for (Atom atom : r.getAtoms()) {
                float x = atom.getFloat()[0];
                float y = atom.getFloat()[1];
                float z = atom.getFloat()[2];
                double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                atom.setCoord((float)x2, (float)y2, (float)z2);
            }
        }
    }

    public void stackResidueBefore(ResidueNA r) {
        Matrix q = this.getStackBeforeMatrix(r);
        if (q != null) {
            for (Atom atom : this.getAtoms()) {
                float x = atom.getFloat()[0];
                float y = atom.getFloat()[1];
                float z = atom.getFloat()[2];
                double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                atom.setCoord((float)x2, (float)y2, (float)z2);
            }
        }
    }

    public void splitChain() {
        Chain newChain = new Chain(this.mediator, this.chain.getName());
        Residue[] residues = this.chain.getResidues().toArray(new Residue[0]);
        for (int i = this.chain.getResidues().indexOf(this); i < residues.length; ++i) {
            newChain.extendChain(residues[i]);
        }
        this.mediator.get3DModel().addChain(newChain);
    }

    public void bind(ResidueNA r) {
        int pos2;
        int pos1;
        if (this.chain != r.chain && this.chain.getMolecule() == r.chain.getMolecule() && this.chain.getLength() > 0 && r.chain.getLength() > 0 && Math.abs((pos1 = this.getResidue3D().getFullLocation(this.chain.getMolecule()).getStart()) - (pos2 = r.getResidue3D().getFullLocation(r.chain.getMolecule()).getStart())) == 1) {
            if (pos1 > pos2) {
                Residue[] residues;
                for (Residue _r : residues = this.chain.getResidues().toArray(new Residue[0])) {
                    r.chain.extendChain(_r);
                }
            } else {
                Residue[] residues;
                for (Residue _r : residues = r.chain.getResidues().toArray(new Residue[0])) {
                    this.chain.extendChain(_r);
                }
            }
            System.gc();
        }
    }

    public boolean stackChainAfter(ResidueNA r) {
        if (r.chain.getResidues().get(0) == r && this.chain.getResidues().get(this.chain.getLength() - 1) == this || this.chain.getResidues().get(0) == this && r.chain.getResidues().get(r.chain.getLength() - 1) == r) {
            Matrix q = this.getStackAfterMatrix(r);
            if (q != null) {
                for (Residue residue : r.getChain().getResidues()) {
                    for (Atom atom : residue.getAtoms()) {
                        float x = atom.getFloat()[0];
                        float y = atom.getFloat()[1];
                        float z = atom.getFloat()[2];
                        double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                        double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                        double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                        atom.setCoord((float)x2, (float)y2, (float)z2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean stackChainBefore(ResidueNA r) {
        if (r.chain.getResidues().get(0) == r && this.chain.getResidues().get(this.chain.getLength() - 1) == this || this.chain.getResidues().get(0) == this && r.chain.getResidues().get(r.chain.getLength() - 1) == r) {
            Matrix q = this.getStackBeforeMatrix(r);
            if (q != null) {
                for (Residue residue : this.getChain().getResidues()) {
                    for (Atom atom : residue.getAtoms()) {
                        float x = atom.getFloat()[0];
                        float y = atom.getFloat()[1];
                        float z = atom.getFloat()[2];
                        double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                        double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                        double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                        atom.setCoord((float)x2, (float)y2, (float)z2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean stackStructuralDomainAfter(ResidueNA r) {
        if (r.chain.getResidues().get(0) == r && this.chain.getResidues().get(this.chain.getLength() - 1) == this || this.chain.getResidues().get(0) == this && r.chain.getResidues().get(r.chain.getLength() - 1) == r) {
            Matrix q = this.getStackAfterMatrix(r);
            if (q != null) {
                StructuralDomain sd = this.mediator.get3DModel().getSecondaryStructure().getEnclosingStructuralDomain((fr.unistra.ibmc.paradise.goloka.core.utils.Residue)r.getResidue3D().getResidues().iterator().next());
                for (Atom atom : this.mediator.getAssemble().getAtomsForStructuralDomain(sd).getAtoms()) {
                    float x = atom.getFloat()[0];
                    float y = atom.getFloat()[1];
                    float z = atom.getFloat()[2];
                    double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                    double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                    double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                    atom.setCoord((float)x2, (float)y2, (float)z2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean stackStructuralDomainBefore(ResidueNA r) {
        if (r.chain.getResidues().get(0) == r && this.chain.getResidues().get(this.chain.getLength() - 1) == this || this.chain.getResidues().get(0) == this && r.chain.getResidues().get(r.chain.getLength() - 1) == r) {
            Matrix q = this.getStackBeforeMatrix(r);
            if (q != null) {
                StructuralDomain sd = this.mediator.get3DModel().getSecondaryStructure().getEnclosingStructuralDomain((fr.unistra.ibmc.paradise.goloka.core.utils.Residue)this.getResidue3D().getResidues().iterator().next());
                for (Atom atom : this.mediator.getAssemble().getAtomsForStructuralDomain(sd).getAtoms()) {
                    float x = atom.getFloat()[0];
                    float y = atom.getFloat()[1];
                    float z = atom.getFloat()[2];
                    double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                    double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                    double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                    atom.setCoord((float)x2, (float)y2, (float)z2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean stackUserSelectionAfter(ResidueNA r, UserSelection selection) {
        if (r.chain.getResidues().get(0) == r && this.chain.getResidues().get(this.chain.getLength() - 1) == this || this.chain.getResidues().get(0) == this && r.chain.getResidues().get(r.chain.getLength() - 1) == r) {
            Matrix q = this.getStackAfterMatrix(r);
            if (q != null) {
                for (Atom atom : selection.getSelectedAtoms()) {
                    float x = atom.getFloat()[0];
                    float y = atom.getFloat()[1];
                    float z = atom.getFloat()[2];
                    double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                    double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                    double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                    atom.setCoord((float)x2, (float)y2, (float)z2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean stackUserSelectionBefore(ResidueNA r, UserSelection selection) {
        if (r.chain.getResidues().get(0) == r && this.chain.getResidues().get(this.chain.getLength() - 1) == this || this.chain.getResidues().get(0) == this && r.chain.getResidues().get(r.chain.getLength() - 1) == r) {
            Matrix q = this.getStackBeforeMatrix(r);
            if (q != null) {
                for (Atom atom : selection.getSelectedAtoms()) {
                    float x = atom.getFloat()[0];
                    float y = atom.getFloat()[1];
                    float z = atom.getFloat()[2];
                    double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                    double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                    double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                    atom.setCoord((float)x2, (float)y2, (float)z2);
                }
            }
            return true;
        }
        return false;
    }

    public ResidueNA(Residue3D res3D, Mediator mediator) {
        super(res3D, mediator);
        this.types.add("NA");
    }

    @Override
    public boolean parseResidue3D(Residue3D.Atom atom) {
        boolean ret = false;
        if (!ret) {
            ret = this.sugar.parseResidue3D(atom);
        }
        if (!ret) {
            ret = this.base.parseResidue3D(atom);
        }
        if (!ret) {
            this.unknownAtoms.add(new Atom(this.mediator, atom, this, 1));
        }
        return ret;
    }

    @Override
    public void setResidueDefaultColor() {
        this.sugar.setResidueDefaultColor();
        this.base.setResidueDefaultColor();
    }

    @Override
    public void generateInternalLinks() {
        int i;
        this.sugar.generateInternalLinks();
        this.base.generateInternalLinks();
        this.sugarBase = Link.createLink(this.mediator, this.sugar.C1, this.base.firstChi);
        if (this.sugarBase != null) {
            this.sugar.links.add(this.sugarBase);
        }
        for (i = 0; i < this.sugar.links.size(); ++i) {
            this.links.add((Link)this.sugar.links.get(i));
        }
        for (i = 0; i < this.base.links.size(); ++i) {
            this.links.add((Link)this.base.links.get(i));
        }
    }

    @Override
    public void generatePreviousLinks() {
        super.generatePreviousLinks();
    }

    @Override
    public void generatePreviousAngles() {
        Atom prevC4 = null;
        Atom prevC3 = null;
        Atom prevO3 = null;
        if (this.getPrev() != null && this.getPrev() instanceof ResidueNA) {
            ResidueNA tmpPrev = (ResidueNA)this.getPrev();
            prevC4 = tmpPrev.sugar.C4;
            prevC3 = tmpPrev.sugar.C3;
            prevO3 = tmpPrev.sugar.O3;
        }
        this.epsilon53.setAtoms(prevC4, prevC3, prevO3, this.sugar.P);
        this.epsilon53.willBeRotated = new AtomSet(this.mediator);
        this.epsilon53.willBeRotated.add(this);
        this.zeta53.setAtoms(prevC3, prevO3, this.sugar.P, this.sugar.O5);
        this.zeta53.willBeRotated = new AtomSet(this.mediator);
        this.zeta53.willBeRotated.add(this);
        this.alpha53.setAtoms(prevO3, this.sugar.P, this.sugar.O5, this.sugar.C5);
        this.alpha53.willBeRotated = new AtomSet(this.mediator);
        this.alpha53.willBeRotated.add(this);
        this.alpha53.willBeRotated.removeAtom(this.sugar.P);
        this.alpha53.willBeRotated.removeAtom(this.sugar.O1P);
        this.alpha53.willBeRotated.removeAtom(this.sugar.O2P);
        this.epsilon35.setAtoms(this.sugar.P, prevO3, prevC3, prevC4);
        this.zeta35.setAtoms(this.sugar.O5, this.sugar.P, prevO3, prevC3);
        this.alpha35.setAtoms(this.sugar.C5, this.sugar.O5, this.sugar.P, prevO3);
        this.alpha35.willBeRotated = new AtomSet(this.mediator);
        this.alpha35.willBeRotated.add(this.sugar.O1P);
        this.alpha35.willBeRotated.add(this.sugar.O2P);
    }

    @Override
    public void generateNextLinks() {
    }

    @Override
    public void generateNextAngles() {
    }

    @Override
    public void generateAtoms() {
        this.sugar.generateAtoms();
        this.base.generateAtoms();
        this.begining = this.sugar.P;
        if (this.begining == null) {
            this.begining = this.getAtoms().iterator().next();
        }
        this.ending = this.sugar.O3;
        if (this.ending == null) {
            this.ending = this.getAtoms().iterator().next();
        }
        this.backBone = this.sugar.P;
        if (this.backBone == null) {
            this.backBone = this.getAtoms().iterator().next();
        }
        this.C1prim = this.sugar.C1;
        this.C2prim = this.sugar.C2;
        this.C3prim = this.sugar.C3;
        this.C4prim = this.sugar.C4;
        this.O4prim = this.sugar.O4;
        if (this.begining != null) {
            this.begining.addAtomListener(this);
        }
        if (this.ending != null) {
            this.ending.addAtomListener(this);
        }
        if (this.backBone != null) {
            this.backBone.addAtomListener(this);
        }
        if (this.C1prim != null) {
            this.C1prim.addAtomListener(this);
        }
        if (this.C2prim != null) {
            this.C2prim.addAtomListener(this);
        }
        if (this.C3prim != null) {
            this.C3prim.addAtomListener(this);
        }
        if (this.C4prim != null) {
            this.C4prim.addAtomListener(this);
        }
        if (this.O4prim != null) {
            this.O4prim.addAtomListener(this);
        }
        for (Atom atom : this.unknownAtoms) {
            this.getAtoms().add(atom);
        }
    }

    @Override
    public void generateInternalAngles() {
        this.epsilon53 = new Angle(this, null, null, null, this.sugar.P, "\u03b5 5'-3' (C3'-O3')", false, true, this.mediator);
        this.zeta53 = new Angle(this, null, null, this.sugar.P, this.sugar.O5, "\u03b6 5'-3' (O3'-P)", false, true, this.mediator);
        this.alpha53 = new Angle(this, null, this.sugar.P, this.sugar.O5, this.sugar.C5, "\u03b1 5'-3' (P-O5')", false, true, this.mediator);
        this.epsilon35 = new Angle(this, this.sugar.P, null, null, null, "\u03b5 3-'5' (O3'-C3')", true, false, this.mediator);
        this.zeta35 = new Angle(this, this.sugar.O5, this.sugar.P, null, null, "\u03b6 3'-5' (P-O3')", true, false, this.mediator);
        this.alpha35 = new Angle(this, this.sugar.C5, this.sugar.O5, this.sugar.P, null, "\u03b1 3'-5' (O5'-P)", true, false, this.mediator);
        this.beta53 = new Angle(this, this.sugar.P, this.sugar.O5, this.sugar.C5, this.sugar.C4, "\u03b2 5'-3' (O5'-C5')", false, true, this.mediator);
        this.beta53.willBeRotated.add(this);
        this.beta53.willBeRotated.removeAtom(this.sugar.P);
        this.beta53.willBeRotated.removeAtom(this.sugar.O1P);
        this.beta53.willBeRotated.removeAtom(this.sugar.O2P);
        this.beta53.willBeRotated.removeAtom(this.sugar.O5);
        this.gamma53 = new Angle(this, this.sugar.O5, this.sugar.C5, this.sugar.C4, this.sugar.C3, "\u03b3 5'-3' (C5'-C4')", false, true, this.mediator);
        this.gamma53.willBeRotated.add(this);
        this.gamma53.willBeRotated.removeAtom(this.sugar.P);
        this.gamma53.willBeRotated.removeAtom(this.sugar.O1P);
        this.gamma53.willBeRotated.removeAtom(this.sugar.O2P);
        this.gamma53.willBeRotated.removeAtom(this.sugar.O5);
        this.gamma53.willBeRotated.removeAtom(this.sugar.H1C5);
        this.gamma53.willBeRotated.removeAtom(this.sugar.H2C5);
        this.gamma53.willBeRotated.removeAtom(this.sugar.C5);
        this.beta35 = new Angle(this, this.sugar.C4, this.sugar.C5, this.sugar.O5, this.sugar.P, "\u03b2 3'-5' (C5'-O5')", true, false, this.mediator);
        this.beta35.willBeRotated.add(this.sugar.P);
        this.beta35.willBeRotated.add(this.sugar.O1P);
        this.beta35.willBeRotated.add(this.sugar.O2P);
        this.gamma35 = new Angle(this, this.sugar.C3, this.sugar.C4, this.sugar.C5, this.sugar.O5, "\u03b3 3'-5' (C4'-C5')", true, false, this.mediator);
        this.gamma35.willBeRotated.add(this.sugar.P);
        this.gamma35.willBeRotated.add(this.sugar.O1P);
        this.gamma35.willBeRotated.add(this.sugar.O2P);
        this.gamma35.willBeRotated.add(this.sugar.O5);
        this.gamma35.willBeRotated.add(this.sugar.H1C5);
        this.gamma35.willBeRotated.add(this.sugar.H2C5);
        this.chi = new Angle(this, this.sugar.O4, this.sugar.C1, this.base.firstChi, this.base.secondChi, "\u03c7", false, false, this.mediator);
        this.chi.willBeRotated.add(this.base);
        this.chi.willBeRotated.removeAtom(this.base.firstChi);
        this.anglesDirect.add(this.epsilon53);
        this.anglesIndirect.add(this.epsilon35);
        this.anglesDirect.add(this.zeta53);
        this.anglesIndirect.add(this.zeta35);
        this.anglesDirect.add(this.alpha53);
        this.anglesIndirect.add(this.alpha35);
        this.anglesDirect.add(this.beta53);
        this.anglesIndirect.add(this.beta35);
        this.anglesDirect.add(this.gamma53);
        this.anglesIndirect.add(this.gamma35);
        this.anglesInternal.add(this.chi);
    }

    @Override
    public void draw(GL gl) {
        super.draw(gl);
        if (this.isPlaneDisplayed()) {
            this.base.drawPlane(gl);
        }
    }

    public void drawP(GL gl) {
        float ap = -0.51939f;
        float bp = 1.70925f;
        float cp = -1.08467f;
        float ao1 = -0.60246f;
        float bo1 = 0.530618f;
        float co1 = -0.883508f;
        float ao2 = -1.52441f;
        float bo2 = 4.57711f;
        float co2 = -1.77632f;
        float ao5 = 0.33345f;
        float bo5 = 1.29635f;
        float co5 = -1.54795f;
        float ax = this.getCoordC2()[0] - this.getCoordO3()[0];
        float bx = this.getCoordC3()[0] - this.getCoordO3()[0];
        float cx = this.getCoordC4()[0] - this.getCoordO3()[0];
        float dx = this.getCoordO3()[0];
        float ay = this.getCoordC2()[1] - this.getCoordO3()[1];
        float by = this.getCoordC3()[1] - this.getCoordO3()[1];
        float cy = this.getCoordC4()[1] - this.getCoordO3()[1];
        float dy = this.getCoordO3()[1];
        float az = this.getCoordC2()[2] - this.getCoordO3()[2];
        float bz = this.getCoordC3()[2] - this.getCoordO3()[2];
        float cz = this.getCoordC4()[2] - this.getCoordO3()[2];
        float dz = this.getCoordO3()[2];
        float px = ap * ax + bp * bx + cp * cx + dx;
        float py = ap * ay + bp * by + cp * cy + dy;
        float pz = ap * az + bp * bz + cp * cz + dz;
        float o1x = ao1 * ax + bo1 * bx + co1 * cx + dx;
        float o1y = ao1 * ay + bo1 * by + co1 * cy + dy;
        float o1z = ao1 * az + bo1 * bz + co1 * cz + dz;
        float o2x = ao2 * ax + bo2 * bx + co2 * cx + dx;
        float o2y = ao2 * ay + bo2 * by + co2 * cy + dy;
        float o2z = ao2 * az + bo2 * bz + co2 * cz + dz;
        float o5x = ao5 * ax + bo5 * bx + co5 * cx + dx;
        float o5y = ao5 * ay + bo5 * by + co5 * cy + dy;
        float o5z = ao5 * az + bo5 * bz + co5 * cz + dz;
        gl.glLineWidth(2.0f);
        gl.glBegin(1);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glVertex3f(px - 0.25f, py, pz);
        gl.glVertex3f(px + 0.25f, py, pz);
        gl.glVertex3f(px, py - 0.25f, pz);
        gl.glVertex3f(px, py + 0.25f, pz);
        gl.glVertex3f(px, py, pz - 0.25f);
        gl.glVertex3f(px, py, pz + 0.25f);
        gl.glColor3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(o1x - 0.25f, o1y, o1z);
        gl.glVertex3f(o1x + 0.25f, o1y, o1z);
        gl.glVertex3f(o1x, o1y - 0.25f, o1z);
        gl.glVertex3f(o1x, o1y + 0.25f, o1z);
        gl.glVertex3f(o1x, o1y, o1z - 0.25f);
        gl.glVertex3f(o1x, o1y, o1z + 0.25f);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(o2x - 0.25f, o2y, o2z);
        gl.glVertex3f(o2x + 0.25f, o2y, o2z);
        gl.glVertex3f(o2x, o2y - 0.25f, o2z);
        gl.glVertex3f(o2x, o2y + 0.25f, o2z);
        gl.glVertex3f(o2x, o2y, o2z - 0.25f);
        gl.glVertex3f(o2x, o2y, o2z + 0.25f);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(o5x - 0.25f, o5y, o5z);
        gl.glVertex3f(o5x + 0.25f, o5y, o5z);
        gl.glVertex3f(o5x, o5y - 0.25f, o5z);
        gl.glVertex3f(o5x, o5y + 0.25f, o5z);
        gl.glVertex3f(o5x, o5y, o5z - 0.25f);
        gl.glVertex3f(o5x, o5y, o5z + 0.25f);
        gl.glEnd();
    }

    public float[] getCoord(String atomName) {
        Atom a = this.sugar.getAtom(atomName);
        if (a != null) {
            return a.getFloat();
        }
        a = this.base.getAtom(atomName);
        if (a != null) {
            return a.getFloat();
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public float[] getCoordC2() {
        if (this.sugar.C2 == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.C2.getFloat();
    }

    public float[] getCoordC1() {
        if (this.sugar.C1 == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.C1.getFloat();
    }

    public float[] getCoordC3() {
        if (this.sugar.C3 == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.C3.getFloat();
    }

    public float[] getCoordC4() {
        if (this.sugar.C4 == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.C4.getFloat();
    }

    public float[] getCoordO3() {
        if (this.sugar.O3 == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.O3.getFloat();
    }

    public float[] getCoordP() {
        if (this.sugar.P == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.P.getFloat();
    }

    public float[] getCoordO1P() {
        if (this.sugar.O1P == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.O1P.getFloat();
    }

    public float[] getCoordO2P() {
        if (this.sugar.O2P == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.O2P.getFloat();
    }

    public float[] getCoordO5() {
        if (this.sugar.O5 == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.sugar.O5.getFloat();
    }

    public void restoreAFormConformation() {
        if (((Angle)this.anglesDirect.get(0)).isValid()) {
            ((Angle)this.anglesDirect.get(0)).torsToDegree(-151.7f, false);
        }
        if (((Angle)this.anglesDirect.get(1)).isValid()) {
            ((Angle)this.anglesDirect.get(1)).torsToDegree(-73.6f, false);
        }
        if (((Angle)this.anglesDirect.get(2)).isValid()) {
            ((Angle)this.anglesDirect.get(2)).torsToDegree(-62.1f, false);
        }
        if (((Angle)this.anglesDirect.get(3)).isValid()) {
            ((Angle)this.anglesDirect.get(3)).torsToDegree(-179.9f, false);
        }
        if (((Angle)this.anglesDirect.get(4)).isValid()) {
            ((Angle)this.anglesDirect.get(4)).torsToDegree(47.4f, false);
        }
        if (((Angle)this.anglesInternal.get(0)).isValid()) {
            ((Angle)this.anglesInternal.get(0)).torsToDegree(-165.7f, false);
        }
    }

    public ResidueNA getPair() {
        for (BaseBaseInteraction bbi : this.getBaseBaseInteractions('W')) {
            if (bbi.getOrientation() != 'C' || bbi.getEdge1() != 'W' || bbi.getEdge2() != 'W') continue;
            return this.getPartner(bbi);
        }
        return null;
    }

    public Set<ResidueNA> getPartners() {
        HashSet<ResidueNA> partners = new HashSet<ResidueNA>();
        for (BaseBaseInteraction bbi : this.getBaseBaseInteractions()) {
            partners.add(this.getPartner(bbi));
        }
        return partners;
    }

    public ResidueNA getPartner(BaseBaseInteraction bbi) {
        Molecule molecule = (Molecule)this.getResidue3D().getMolecules().iterator().next();
        Location rloc = this.getResidue3D().getFullLocation(molecule);
        List annotations = bbi.getAnnotations();
        if (annotations.size() == 1) {
            Location loc = bbi.getFullLocation(molecule);
            int other = loc.getStart() == rloc.getStart() ? loc.getEnd() : loc.getStart();
            if (molecule.getAnnotations(Residue3D.class, new Location(other)).size() != 0) {
                return (ResidueNA)this.mediator.get3DModel().getResidueFor((Residue3D)((Molecule.Annotation)molecule.getAnnotations(Residue3D.class, new Location(other)).get(0)).getFeature());
            }
            return null;
        }
        Molecule.Annotation an = ((Molecule.Annotation)annotations.get(0)).getMolecule() == molecule ? (Molecule.Annotation)annotations.get(1) : (Molecule.Annotation)annotations.get(0);
        if (an.getMolecule().getAnnotations(Residue3D.class, new Location(an.getLocation())).size() != 0) {
            return (ResidueNA)this.mediator.get3DModel().getResidueFor((Residue3D)((Molecule.Annotation)an.getMolecule().getAnnotations(Residue3D.class, new Location(an.getLocation())).get(0)).getFeature());
        }
        return null;
    }

    public void removeBaseBaseInteractions(char edge) {
        Residue3D r3d = this.getResidue3D();
        SecondaryStructure ss = this.mediator.get3DModel().getCurrentSecondaryStructure();
        for (BaseBaseInteraction bbi : this.getBaseBaseInteractions(edge)) {
            if (!ss.getAllBaseBaseInteractions().contains(bbi)) continue;
            for (Molecule.Annotation annotation : bbi.getAnnotations()) {
                for (AtomAtomInteraction aai : bbi.getAllAtomAtomInteractions()) {
                    annotation.getMolecule().removeFeature((ParadiseFeature)aai);
                }
                annotation.getMolecule().removeFeature((ParadiseFeature)bbi);
            }
        }
    }

    public void setBaseBaseInteraction(ResidueNA pair, char edge1, char edge2, char orientation) throws BiologicalSymbolException {
        Residue3D r3d = this.getResidue3D();
        Residue3D pair3D = pair.getResidue3D();
        Molecule mol = (Molecule)r3d.getMolecules().iterator().next();
        Molecule pairMol = (Molecule)pair3D.getMolecules().iterator().next();
        int loc = mol.getAnnotation((ParadiseFeature)r3d).getLocation().getStart();
        int pairLoc = pairMol.getAnnotation((ParadiseFeature)pair3D).getLocation().getStart();
        SecondaryStructure ss = this.mediator.get3DModel().getCurrentSecondaryStructure();
        this.removeBaseBaseInteractions(edge1);
        pair.removeBaseBaseInteractions(edge2);
        StructuralFeatureFactory factory = this.mediator.getAssemble().getStructuralFeatureFactory();
        if (BaseBaseInteraction.isAmbiguous((char)this.getName().charAt(0), (char)pair.getName().charAt(0), (char)edge1, (char)edge2, (char)orientation)) {
            new ChooseDominant(this, pair, edge1, edge2, orientation);
        } else if (mol.getParadiseID().equals((Object)pairMol.getParadiseID())) {
            if (loc <= pairLoc) {
                Location location = new Location(new Location(loc), new Location(pairLoc));
                BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge1, edge2, orientation, 1, ss, mol, location);
                bbi.generateAtomAtomInteractions();
            } else {
                Location location = new Location(new Location(pairLoc), new Location(loc));
                BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge2, edge1, orientation, 1, ss, mol, location);
                bbi.generateAtomAtomInteractions();
            }
        } else {
            BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge1, edge2, orientation, 1, ss, mol, new Location(loc), pairMol, new Location(pairLoc));
            bbi.generateAtomAtomInteractions();
        }
    }

    public void setBaseBaseInteraction(ResidueNA pair, char edge1, char edge2, char orientation, int dominant) throws BiologicalSymbolException {
        Residue3D r3d = this.getResidue3D();
        Residue3D pair3D = pair.getResidue3D();
        Molecule mol = (Molecule)r3d.getMolecules().iterator().next();
        Molecule pairMol = (Molecule)pair3D.getMolecules().iterator().next();
        int loc = mol.getAnnotation((ParadiseFeature)r3d).getLocation().getStart();
        int pairLoc = pairMol.getAnnotation((ParadiseFeature)pair3D).getLocation().getStart();
        StructuralFeatureFactory factory = this.mediator.getAssemble().getStructuralFeatureFactory();
        SecondaryStructure ss = this.mediator.get3DModel().getCurrentSecondaryStructure();
        if (mol.getParadiseID().equals((Object)pairMol.getParadiseID())) {
            if (loc <= pairLoc) {
                Location location = new Location(new Location(loc), new Location(pairLoc));
                BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge1, edge2, orientation, dominant, ss, mol, location);
                bbi.generateAtomAtomInteractions();
            } else {
                Location location = new Location(new Location(pairLoc), new Location(loc));
                BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge2, edge1, orientation, 3 - dominant, ss, mol, location);
                bbi.generateAtomAtomInteractions();
            }
        } else {
            BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge1, edge2, orientation, dominant, ss, mol, new Location(loc), pairMol, new Location(pairLoc));
            bbi.generateAtomAtomInteractions();
        }
    }

    public Set<BaseBaseInteraction> getBaseBaseInteractions() {
        HashSet<BaseBaseInteraction> bbis = new HashSet<BaseBaseInteraction>();
        bbis.addAll(this.getBaseBaseInteractions('H'));
        bbis.addAll(this.getBaseBaseInteractions('S'));
        bbis.addAll(this.getBaseBaseInteractions('W'));
        return bbis;
    }

    public Set<BaseBaseInteraction> getBaseBaseInteractions(char edge) {
        HashSet<BaseBaseInteraction> ret = new HashSet<BaseBaseInteraction>();
        Residue3D r3d = this.getResidue3D();
        Molecule mol = (Molecule)r3d.getMolecules().iterator().next();
        for (Molecule.Annotation annotation : mol.getAnnotations(BaseBaseInteraction.class)) {
            if (!annotation.getLocation().contains(mol.getAnnotation((ParadiseFeature)r3d).getLocation())) continue;
            BaseBaseInteraction bbi = (BaseBaseInteraction)annotation.getFeature();
            List anns = bbi.getAnnotations();
            if (anns.size() == 1) {
                if (((Molecule.Annotation)anns.get(0)).getLocation().getStart() == mol.getAnnotation((ParadiseFeature)r3d).getLocation().getStart() && edge == bbi.getEdge1()) {
                    ret.add(bbi);
                    continue;
                }
                if (((Molecule.Annotation)anns.get(0)).getLocation().getEnd() != mol.getAnnotation((ParadiseFeature)r3d).getLocation().getStart() || edge != bbi.getEdge2()) continue;
                ret.add(bbi);
                continue;
            }
            if (((Molecule.Annotation)anns.get(0)).getMolecule().getParadiseID().equals((Object)mol.getParadiseID()) && bbi.getEdge1() == edge) {
                ret.add(bbi);
                continue;
            }
            if (!((Molecule.Annotation)anns.get(1)).getMolecule().getParadiseID().equals((Object)mol.getParadiseID()) || bbi.getEdge1() != edge) continue;
            ret.add(bbi);
        }
        return ret;
    }

    public void setPair(ResidueNA p) throws BiologicalSymbolException {
        if (p != null) {
            this.setBaseBaseInteraction(p, 'W', 'W', 'C');
        } else {
            this.removeBaseBaseInteractions('W');
        }
        if (this == p) {
            this.setPair(null);
        }
        this.mediator.get3DModel().fireModelModified();
        this.fireRenderingModified();
    }

    @Override
    public void setPrev(Residue prev) {
        super.setPrev(prev);
        this.mediator.get3DModel().fireModelModified();
    }

    @Override
    public void setNext(Residue next) {
        super.setNext(next);
        this.mediator.get3DModel().fireModelModified();
    }

    @Override
    public void atomMoved() {
        this.mediator.get3DModel().fireModelModified();
    }

    public float[] getPNext() {
        float a = -0.51939f;
        float b = 1.70925f;
        float c = -1.08467f;
        float[] P = new float[3];
        for (int i = 0; i < 3; ++i) {
            P[i] = a * (this.getCoordC2()[i] - this.getCoordO3()[i]) + b * (this.getCoordC3()[i] - this.getCoordO3()[i]) + c * (this.getCoordC4()[i] - this.getCoordO3()[i]) + this.getCoordO3()[i];
        }
        return P;
    }

    public float[] getPPrev() {
        float a = -5.44361f;
        float b = 14.3799f;
        float c = -0.773307f;
        float[] P = new float[3];
        for (int i = 0; i < 3; ++i) {
            P[i] = a * (this.getCoordC2()[i] - this.getCoordO3()[i]) + b * (this.getCoordC3()[i] - this.getCoordO3()[i]) + c * (this.getCoordC4()[i] - this.getCoordO3()[i]) + this.getCoordO3()[i];
        }
        return P;
    }

    public float[] getPPair() {
        float a = 2.96263f;
        float b = 14.3449f;
        float c = -6.88677f;
        float[] P = new float[3];
        for (int i = 0; i < 3; ++i) {
            P[i] = a * (this.getCoordC2()[i] - this.getCoordO3()[i]) + b * (this.getCoordC3()[i] - this.getCoordO3()[i]) + c * (this.getCoordC4()[i] - this.getCoordO3()[i]) + this.getCoordO3()[i];
        }
        return P;
    }

    public void deleteAtom(Atom atom) {
        super.deleteAtom(atom, true);
        this.sugar.removeAtom(atom);
        this.base.removeAtom(atom);
        this.sugar.removeLinks(atom);
        this.base.removeLinks(atom);
    }

    @Override
    public OpenGLColor getStandardColor() {
        return this.base.getStandardColor();
    }
}

