/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.nucleicAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.SugarPhosphate;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import java.awt.Color;

public class Ribose
extends SugarPhosphate {
    Atom O2 = null;
    Atom HO2 = null;
    Link C2O2 = null;
    Link O2HO2 = null;
    private static OpenGLColor standardColor = new OpenGLColor(Color.cyan);

    public Ribose(Residue r, Mediator mediator) {
        super(r, mediator);
        this.setColor(standardColor);
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        boolean ret = super.parseResidue3D(atom);
        if (ret) {
            return ret;
        }
        if (name.equals("O2'")) {
            this.O2 = new Atom(this.mediator, atom, this.residue, 8);
            return true;
        }
        if (name.equals("2HO'")) {
            this.HO2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return ret;
    }

    public void generateAtoms() {
        super.generateAtoms();
        if (this.O2 != null) {
            this.add(this.O2);
        }
        if (this.HO2 != null) {
            this.add(this.HO2);
        }
    }

    public void generateInternalLinks() {
        this.C2O2 = Link.createLink(this.mediator, this.C2, this.O2);
        this.O2HO2 = Link.createLink(this.mediator, this.O2, this.HO2);
        if (this.C2O2 != null) {
            this.links.add(this.C2O2);
        }
        if (this.O2HO2 != null) {
            this.links.add(this.O2HO2);
        }
        super.generateInternalLinks();
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

