/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.utils;

import fr.unistra.ibmc.assemble.gui.Assemble;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AssembleConfig {
    private static Document document;

    public static void parseConfigFile() throws BackingStoreException, IOException {
        File configFile;
        File rnalignUserDir = new File(Assemble.getUserDirPath());
        if (!rnalignUserDir.exists()) {
            rnalignUserDir.mkdir();
        }
        if (!(configFile = new File(rnalignUserDir, "config.xml")).exists()) {
            Element root = new Element("assemble-config");
            root.setAttribute("version", "Assemble 1.0, Release Candidate 1");
            document = new Document(root);
            root.addContent((Content)new Element("platform-addresses"));
            AssembleConfig.save();
        } else {
            SAXBuilder builder = new SAXBuilder();
            try {
                document = builder.build(configFile);
                if (document.getRootElement().getAttribute("version") == null || !document.getRootElement().getAttributeValue("version").equals("Assemble 1.0, Release Candidate 1")) {
                    configFile.delete();
                    Element root = new Element("assemble-config");
                    root.setAttribute("version", "Assemble 1.0, Release Candidate 1");
                    document = new Document(root);
                    root.addContent((Content)new Element("platform-addresses"));
                    AssembleConfig.save();
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] getPlatformAddresses() {
        ArrayList<String> adresses = new ArrayList<String>();
        for (Object o : document.getRootElement().getChild("platform-addresses").getChildren()) {
            adresses.add(((Element)o).getText());
        }
        adresses.add("localhost");
        return adresses.toArray(new String[0]);
    }

    public static void addPlatformAddress(String address) {
        Element e = new Element("platform-address");
        e.setText(address);
        document.getRootElement().getChild("platform-addresses").addContent((Content)e);
    }

    public static void save() throws BackingStoreException, IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        FileWriter writer = new FileWriter(new File(new StringBuffer(Assemble.getUserDirPath()).append("config.xml").toString()));
        outputter.output(document, (Writer)writer);
        writer.close();
    }
}

