/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.utils;

import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.goloka.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.goloka.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.goloka.tools.component.ProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssembleModelParser
extends AbstractParadiseFileIO {
    private List<Molecule> molecules;
    private List<TertiaryStructure> tertiaryStructures;

    public AssembleModelParser(MoleculeFactory moleculeFactory) {
        super("Assemble model parser", moleculeFactory);
    }

    public List<Molecule> getNewMolecules() {
        return this.molecules;
    }

    public List<TertiaryStructure> getAllTertiaryStructures() {
        return new ArrayList<TertiaryStructure>(this.tertiaryStructures);
    }

    public List<SecondaryStructure> getAllSecondaryStructures() {
        return new ArrayList<SecondaryStructure>();
    }

    public List<StructuralAlignment> getAllStructuralAlignments() {
        return new ArrayList<StructuralAlignment>();
    }

    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException, InterruptedException {
        this.molecules = new ArrayList<Molecule>();
        this.tertiaryStructures = new ArrayList<TertiaryStructure>();
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            Object o = ois.readObject();
            if (TertiaryStructure.class.isInstance(o)) {
                this.tertiaryStructures.add((TertiaryStructure)o);
                this.molecules.addAll(((TertiaryStructure)o).getMolecules());
                ((ParadiseWorkingSession)this.moleculeFactory).addAllMolecules(this.molecules);
            }
            ois.close();
        }
        catch (Exception e) {
            throw new FileParsingException((Throwable)e);
        }
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                String suffix = AssembleModelParser.this.getFileSuffix(file);
                return file.isDirectory() || suffix != null && suffix.equals("assemble");
            }

            public String getDescription() {
                return "Assemble models";
            }
        };
    }
}

