/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkSecurityManager;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import com.wolfram.jlink.NativeLink;
import com.wolfram.jlink.Reader;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.WrappedKernelLink;
import com.wolfram.jlink.ui.ConsoleStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;

public class Install {
    static final int CALLJAVA = 1;
    static final int LOADCLASS = 2;
    static final int THROW = 3;
    static final int RELEASEOBJECT = 4;
    static final int VAL = 5;
    static final int ONLOADCLASS = 6;
    static final int ONUNLOADCLASS = 7;
    static final int SETCOMPLEX = 8;
    static final int REFLECT = 9;
    static final int SHOW = 10;
    static final int SAMEQ = 11;
    static final int INSTANCEOF = 12;
    static final int ALLOWRAGGED = 13;
    static final int GETEXCEPTION = 14;
    static final int CONNECTTOFE = 15;
    static final int DISCONNECTTOFE = 16;
    static final int PEEKCLASSES = 17;
    static final int PEEKOBJECTS = 18;
    static final int CLASSPATH = 19;
    static final int ADDTOCLASSPATH = 20;
    static final int SETUSERDIR = 21;
    static final int ALLOWUICOMPUTATIONS = 22;
    static final int UITHREADWAITING = 23;
    static final int YIELDTIME = 24;
    static final int GETCONSOLE = 25;
    static final int EXTRALINKS = 26;
    static final int GETWINDOWID = 27;
    static final int ADDTITLECHANGELISTENER = 28;
    static final int SETVMNAME = 29;
    static final int SETEXCEPTION = 30;
    static /* synthetic */ Class array$Ljava$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        MathLink impl;
        int i;
        KernelLink ml;
        int timeout = 25000;
        System.out.println("J/Link (tm)");
        System.out.println("Copyright (C) 1999-2007, Wolfram Research, Inc. All Rights Reserved.");
        System.out.println("www.wolfram.com");
        System.out.println("Version 4.0.2");
        System.out.println("");
        System.out.flush();
        ConsoleStream.setSystemStdoutStream(System.out);
        ConsoleStream.setSystemStderrStream(System.err);
        try {
            System.setSecurityManager(JLinkSecurityManager.getInstance());
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            ml = MathLinkFactory.createKernelLink(args);
        }
        catch (MathLinkException e) {
            System.err.println("FATAL ERROR: link creation failed.");
            return;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-init") || i >= args.length - 1) continue;
            String initFile = args[i + 1];
            if (initFile.startsWith("\"")) {
                initFile = initFile.substring(1, initFile.length() - 2);
            }
            BufferedReader rdr = null;
            try {
                String line;
                rdr = new BufferedReader(new FileReader(initFile));
                while ((line = rdr.readLine()) != null) {
                    String[] cmd;
                    String addToClassPath;
                    if (line.startsWith("cp ")) {
                        addToClassPath = line.substring(3);
                        ml.getClassLoader().addLocations(new String[]{addToClassPath}, true);
                        continue;
                    }
                    if (line.startsWith("cpf ")) {
                        addToClassPath = line.substring(4);
                        ml.getClassLoader().addLocations(new String[]{addToClassPath}, false);
                        continue;
                    }
                    if (!line.startsWith("run ") || (cmd = (line = line.substring(4)).split(" ")).length <= 0) continue;
                    String clsName = cmd[0];
                    String[] argv = new String[cmd.length - 1];
                    for (int c = 0; c < argv.length; ++c) {
                        argv[c] = cmd[c + 1].replaceAll("%20", " ");
                    }
                    try {
                        Class<?> c = ml.getClassLoader().loadClass(clsName);
                        Method mainMeth = c.getMethod("main", array$Ljava$lang$String == null ? Install.class$("[Ljava.lang.String;") : array$Ljava$lang$String);
                        mainMeth.invoke(null, new Object[]{argv});
                    }
                    catch (Throwable t) {}
                }
                continue;
            }
            catch (Exception e) {
                continue;
            }
            finally {
                if (rdr != null) {
                    try {
                        rdr.close();
                        new File(initFile).delete();
                    }
                    catch (Exception ee) {}
                }
            }
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-timeout") && i < args.length - 1) {
                try {
                    timeout = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!args[i].equalsIgnoreCase("-linklisten") && (!args[i].equalsIgnoreCase("-linkmode") || i >= args.length - 1 || !args[i + 1].equalsIgnoreCase("listen"))) continue;
            timeout = Integer.MAX_VALUE;
            break;
        }
        if (!Install.install(ml, timeout)) {
            ml.close();
            JLinkSecurityManager.setAllowExit(true);
            System.exit(1);
        }
        if (Utils.isWindows() && ml instanceof WrappedKernelLink && (impl = ((WrappedKernelLink)ml).getMathLink()) instanceof NativeLink) {
            NativeLink.hideJavaWindow();
        }
        Reader.startReader(ml, true, false);
    }

    public static KernelLink getStdLink() {
        return StdLink.getLink();
    }

    public static boolean install(MathLink ml) {
        return Install.install(ml, Integer.MAX_VALUE);
    }

    public static boolean install(MathLink ml, int timeout) {
        try {
            ml.connect(timeout);
            return true;
        }
        catch (MathLinkException e) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

