/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;

public class JLinkClassLoader
extends URLClassLoader {
    private static boolean jvmHasURIClass;
    static /* synthetic */ Class class$com$wolfram$jlink$JLinkClassLoader;

    public static JLinkClassLoader getInstance() {
        return StdLink.getLink().getClassLoader();
    }

    public static Class classFromName(String name) throws ClassNotFoundException {
        return Class.forName(name, false, JLinkClassLoader.getInstance());
    }

    public JLinkClassLoader() {
        this((class$com$wolfram$jlink$JLinkClassLoader == null ? (class$com$wolfram$jlink$JLinkClassLoader = JLinkClassLoader.class$("com.wolfram.jlink.JLinkClassLoader")) : class$com$wolfram$jlink$JLinkClassLoader).getClassLoader());
    }

    public JLinkClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public synchronized void addLocations(String[] locations, boolean searchForJars) {
        if (locations == null) {
            return;
        }
        URL[] existingLocs = this.getURLs();
        for (int i = 0; i < locations.length; ++i) {
            String thisLocation = locations[i];
            if (thisLocation.toLowerCase().startsWith("http:")) {
                try {
                    this.addIfNew(new URL(thisLocation), existingLocs);
                }
                catch (MalformedURLException e) {}
                continue;
            }
            if (!thisLocation.toLowerCase().endsWith(".jar") && !thisLocation.toLowerCase().endsWith(".zip")) {
                String dirName = thisLocation.endsWith(File.separator) ? thisLocation : thisLocation + File.separator;
                try {
                    String[] filesInDir;
                    this.addIfNew(JLinkClassLoader.fileToURL(new File(dirName)), existingLocs);
                    if (!searchForJars || (filesInDir = new File(dirName).list()) == null) continue;
                    for (int j = 0; j < filesInDir.length; ++j) {
                        String lowerCaseFile = filesInDir[j].toLowerCase();
                        if (!lowerCaseFile.endsWith(".jar") && !lowerCaseFile.endsWith(".zip")) continue;
                        File f = new File(dirName, filesInDir[j]);
                        this.addIfNew(JLinkClassLoader.fileToURL(f), existingLocs);
                    }
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
            }
            try {
                this.addIfNew(JLinkClassLoader.fileToURL(new File(thisLocation)), existingLocs);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public synchronized String[] getClassPath() {
        URL[] existingLocs = this.getURLs();
        String[] result = new String[existingLocs.length];
        for (int i = 0; i < existingLocs.length; ++i) {
            if (existingLocs[i].getProtocol().equals("file")) {
                String fileString = existingLocs[i].getFile();
                if (jvmHasURIClass) {
                    try {
                        URI u = new URI(existingLocs[i].toString());
                        fileString = u.getPath();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                result[i] = fileString;
                continue;
            }
            result[i] = existingLocs[i].toString();
        }
        return result;
    }

    public Class classFromBytes(String className, byte[] bytes) {
        Class<?> c = this.defineClass(className, bytes, 0, bytes.length);
        this.resolveClass(c);
        return c;
    }

    protected String findLibrary(String libName) {
        String platformSpecificName = System.mapLibraryName(libName);
        URL[] locs = this.getURLs();
        for (int i = 0; i < locs.length; ++i) {
            boolean isJarOrZip;
            if (!locs[i].getProtocol().equals("file")) continue;
            String fileName = locs[i].getFile();
            boolean bl = isJarOrZip = fileName.toLowerCase().endsWith(".zip") || fileName.toLowerCase().endsWith(".jar");
            if (isJarOrZip) continue;
            File f = new File(fileName, platformSpecificName);
            if (f.exists()) {
                return f.getAbsolutePath();
            }
            f = new File(fileName, "Libraries" + File.separator + Utils.getSystemID() + File.separator + platformSpecificName);
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    private void addIfNew(URL u, URL[] existingLocs) {
        for (int j = 0; j < existingLocs.length; ++j) {
            if (!existingLocs[j].equals(u)) continue;
            return;
        }
        this.addURL(u);
    }

    private static URL fileToURL(File f) throws MalformedURLException {
        if (jvmHasURIClass) {
            return f.toURI().toURL();
        }
        return f.toURL();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class.forName("java.net.URI");
            jvmHasURIClass = true;
        }
        catch (Throwable t) {
            jvmHasURIClass = false;
        }
    }
}

