/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.NativeLink;
import com.wolfram.jlink.NativeLoopbackLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.WrappedKernelLink;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.StringTokenizer;

public class MathLinkFactory {
    static /* synthetic */ Class class$com$wolfram$jlink$MathLinkFactory;
    static /* synthetic */ Class class$java$lang$String;

    public static KernelLink createKernelLink(String cmdLine) throws MathLinkException {
        return MathLinkFactory.createKernelLink0(cmdLine, null);
    }

    public static KernelLink createKernelLink(String[] argv) throws MathLinkException {
        return MathLinkFactory.createKernelLink0(null, argv);
    }

    public static KernelLink createKernelLink(MathLink ml) throws MathLinkException {
        return new WrappedKernelLink(ml);
    }

    private static KernelLink createKernelLink0(String cmdLine, String[] argv) throws MathLinkException {
        String protocol;
        if (cmdLine == null && argv == null) {
            throw new MathLinkException(1004, "Null argument to KernelLink constructor");
        }
        boolean usingCmdLine = cmdLine != null;
        String string = protocol = usingCmdLine ? MathLinkFactory.determineProtocol(cmdLine) : MathLinkFactory.determineProtocol(argv);
        if (!protocol.equals("native")) {
            String implClassName = null;
            try {
                implClassName = System.getProperty("KernelLink." + protocol);
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (implClassName == null) {
                Properties props = MathLinkFactory.loadProperties();
                implClassName = props.getProperty("KernelLink." + protocol);
            }
            if (implClassName != null) {
                Class<?> implementingClass = null;
                try {
                    implementingClass = (class$com$wolfram$jlink$MathLinkFactory == null ? (class$com$wolfram$jlink$MathLinkFactory = MathLinkFactory.class$("com.wolfram.jlink.MathLinkFactory")) : class$com$wolfram$jlink$MathLinkFactory).getClassLoader().loadClass(implClassName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (implementingClass != null) {
                    try {
                        Object[] objectArray;
                        Class clazz = usingCmdLine ? (class$java$lang$String == null ? (class$java$lang$String = MathLinkFactory.class$("java.lang.String")) : class$java$lang$String) : Class.forName("[Ljava.lang.String;");
                        Class argsClass = clazz;
                        Constructor<?> ctor = implementingClass.getConstructor(argsClass);
                        if (usingCmdLine) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = cmdLine;
                        } else {
                            Object[] objectArray3 = new Object[1];
                            objectArray = objectArray3;
                            objectArray3[0] = argv;
                        }
                        return (KernelLink)ctor.newInstance(objectArray);
                    }
                    catch (Exception e) {
                        if (e instanceof InvocationTargetException) {
                            throw new MathLinkException(((InvocationTargetException)e).getTargetException(), "Error instantiating link object of class " + implementingClass.getName());
                        }
                        throw new MathLinkException(e, "Error instantiating link object of class " + implementingClass.getName());
                    }
                }
            }
        }
        return new WrappedKernelLink(usingCmdLine ? MathLinkFactory.createMathLink(cmdLine) : MathLinkFactory.createMathLink(argv));
    }

    public static MathLink createMathLink(String cmdLine) throws MathLinkException {
        return MathLinkFactory.createMathLink0(cmdLine, null);
    }

    public static MathLink createMathLink(String[] argv) throws MathLinkException {
        return MathLinkFactory.createMathLink0(null, argv);
    }

    private static MathLink createMathLink0(String cmdLine, String[] argv) throws MathLinkException {
        String protocol;
        if (cmdLine == null && argv == null) {
            throw new MathLinkException(1004, "Null argument to MathLink constructor");
        }
        boolean usingCmdLine = cmdLine != null;
        String string = protocol = usingCmdLine ? MathLinkFactory.determineProtocol(cmdLine) : MathLinkFactory.determineProtocol(argv);
        if (!protocol.equals("native")) {
            String implClassName = null;
            try {
                implClassName = System.getProperty("MathLink." + protocol);
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (implClassName == null) {
                Properties props = MathLinkFactory.loadProperties();
                implClassName = props.getProperty("MathLink." + protocol);
            }
            if (implClassName != null) {
                Class<?> implementingClass = null;
                try {
                    implementingClass = (class$com$wolfram$jlink$MathLinkFactory == null ? (class$com$wolfram$jlink$MathLinkFactory = MathLinkFactory.class$("com.wolfram.jlink.MathLinkFactory")) : class$com$wolfram$jlink$MathLinkFactory).getClassLoader().loadClass(implClassName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (implementingClass != null) {
                    try {
                        Object[] objectArray;
                        Class clazz = usingCmdLine ? (class$java$lang$String == null ? (class$java$lang$String = MathLinkFactory.class$("java.lang.String")) : class$java$lang$String) : Class.forName("[Ljava.lang.String;");
                        Class argsClass = clazz;
                        Constructor<?> ctor = implementingClass.getConstructor(argsClass);
                        if (usingCmdLine) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = cmdLine;
                        } else {
                            Object[] objectArray3 = new Object[1];
                            objectArray = objectArray3;
                            objectArray3[0] = argv;
                        }
                        return (MathLink)ctor.newInstance(objectArray);
                    }
                    catch (Exception e) {
                        if (e instanceof InvocationTargetException) {
                            throw new MathLinkException(((InvocationTargetException)e).getTargetException(), "Error instantiating link object of class " + implementingClass.getName());
                        }
                        throw new MathLinkException(e, "Error instantiating link object of class " + implementingClass.getName());
                    }
                }
                System.err.println("J/Link Warning: could not find any Java class that implements the requested " + protocol + " protocol. This protocol name will be passed to the MathLink library to " + "see if it has a native implementation.");
            }
        }
        return usingCmdLine ? new NativeLink(cmdLine) : new NativeLink(argv);
    }

    public static LoopbackLink createLoopbackLink() throws MathLinkException {
        return new NativeLoopbackLink();
    }

    private static String determineProtocol(String cmdLine) {
        StringTokenizer st = new StringTokenizer(cmdLine);
        String prot = "native";
        while (st != null && st.hasMoreTokens()) {
            if (!st.nextToken().toLowerCase().equals("-linkprotocol") || !st.hasMoreTokens()) continue;
            prot = st.nextToken().toLowerCase();
            break;
        }
        return MathLinkFactory.isNative(prot) ? "native" : prot;
    }

    private static String determineProtocol(String[] argv) {
        String prot = "native";
        if (argv != null) {
            for (int i = 0; i < argv.length - 1; ++i) {
                if (!argv[i].toLowerCase().equals("-linkprotocol")) continue;
                prot = argv[i + 1].toLowerCase();
                break;
            }
        }
        return MathLinkFactory.isNative(prot) ? "native" : prot;
    }

    private static boolean isNative(String prot) {
        return prot.equals("native") || prot.equals("local") || prot.equals("filemap") || prot.equals("fm") || prot.equals("ppc") || prot.equals("tcp") || prot.equals("tcpip") || prot.equals("pipes") || prot.equals("sharedmemory") || prot.equals("");
    }

    private static Properties loadProperties() {
        Properties props = new Properties();
        try {
            String jarDir = Utils.getJLinkJarDir();
            if (jarDir != null) {
                FileInputStream in = new FileInputStream(jarDir + "JLink.properties");
                props.load(in);
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

