/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink.util;

import com.wolfram.jlink.Expr;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import com.wolfram.jlink.NativeLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.WrappedKernelLink;
import com.wolfram.jlink.ui.ConsoleWindow;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class LinkSnooper
extends Thread {
    private PrintStream strm;
    private PrintStream logFileStrm;
    private KernelLink kernelMain = null;
    private KernelLink feMain = null;
    private KernelLink kernelService = null;
    private KernelLink feService = null;
    private KernelLink kernelPreemptive = null;
    private KernelLink fePreemptive = null;
    private String feSideName = "FE";
    private String kernelSideName = "K";
    private String toKernelArrow;
    private String toFEArrow;
    private String preemptiveLinkPrefix = "   -Pre-  ";
    private String serviceLinkPrefix = "      -Serv-  ";
    private boolean skipInitTraffic = false;
    private boolean doPrint = true;
    static /* synthetic */ Class class$com$wolfram$jlink$util$LinkSnooper;

    public static void main(String[] argv) throws MathLinkException {
        LinkSnooper snooper = new LinkSnooper(argv);
        snooper.start();
    }

    public LinkSnooper(String[] argv) throws MathLinkException {
        this(argv, null);
    }

    public LinkSnooper(String[] argv, PrintStream pstrm) throws MathLinkException {
        MathLink ml;
        int i;
        this.strm = pstrm;
        for (i = 0; i < argv.length - 1; ++i) {
            if (!argv[i].equalsIgnoreCase("-logfile")) continue;
            try {
                this.logFileStrm = new PrintStream(new FileOutputStream(argv[i + 1]));
                continue;
            }
            catch (Exception e) {
                System.err.println("Could not open file " + argv[i] + " for writing.");
            }
        }
        if (this.strm == null) {
            boolean useWindow = true;
            for (int i2 = 0; i2 < argv.length; ++i2) {
                if (!argv[i2].equalsIgnoreCase("-nowindow")) continue;
                useWindow = false;
            }
            if (useWindow) {
                ConsoleWindow cw = ConsoleWindow.getInstance();
                cw.setMaxLines(15000);
                cw.setCapture(3);
                cw.setSize(700, 600);
                cw.setVisible(true);
            }
        }
        this.output("LinkSnooper command-line params:");
        for (i = 0; i < argv.length; ++i) {
            this.output("   " + argv[i]);
        }
        this.feMain = MathLinkFactory.createKernelLink(argv);
        this.feMain.connect();
        if (this.feMain instanceof WrappedKernelLink && (ml = ((WrappedKernelLink)this.feMain).getMathLink()) instanceof NativeLink) {
            String linkedEnvId = ((NativeLink)ml).getLinkedEnvID();
            NativeLink.setEnvID("Mathematica Notebook Front End");
        }
        ArrayList<String> kernelLinkArgs = new ArrayList<String>();
        for (int i3 = 0; i3 < argv.length; ++i3) {
            if (argv[i3].equalsIgnoreCase("-kernelname")) {
                kernelLinkArgs.add("-linkname");
                String kname = argv[i3 + 1];
                if (Utils.isWindows() && kname.startsWith("'") && kname.endsWith("'")) {
                    kname = kname.substring(1, kname.length() - 1);
                }
                kernelLinkArgs.add(kname);
                continue;
            }
            if (argv[i3].equalsIgnoreCase("-kernelmode")) {
                kernelLinkArgs.add("-linkmode");
                kernelLinkArgs.add(argv[i3 + 1]);
                continue;
            }
            if (argv[i3].equalsIgnoreCase("-kernelprot")) {
                kernelLinkArgs.add("-linkprotocol");
                kernelLinkArgs.add(argv[i3 + 1]);
                continue;
            }
            if (argv[i3].equalsIgnoreCase("-kernelside")) {
                this.kernelSideName = argv[i3 + 1];
                continue;
            }
            if (argv[i3].equalsIgnoreCase("-feside")) {
                this.feSideName = argv[i3 + 1];
                continue;
            }
            if (!argv[i3].equalsIgnoreCase("-noinit")) continue;
            this.skipInitTraffic = true;
        }
        if (!kernelLinkArgs.contains("-linkmode")) {
            kernelLinkArgs.add("-linkmode");
            kernelLinkArgs.add("launch");
        }
        this.kernelMain = MathLinkFactory.createKernelLink(kernelLinkArgs.toArray(new String[0]));
        this.kernelMain.connect();
        this.toKernelArrow = this.feSideName + " ---> " + this.kernelSideName + ": ";
        this.toFEArrow = this.feSideName + " <--- " + this.kernelSideName + ": ";
        this.feMain.addMessageHandler(class$com$wolfram$jlink$util$LinkSnooper == null ? (class$com$wolfram$jlink$util$LinkSnooper = LinkSnooper.class$("com.wolfram.jlink.util.LinkSnooper")) : class$com$wolfram$jlink$util$LinkSnooper, this, "feMainMessageHandler");
        this.kernelMain.addMessageHandler(class$com$wolfram$jlink$util$LinkSnooper == null ? (class$com$wolfram$jlink$util$LinkSnooper = LinkSnooper.class$("com.wolfram.jlink.util.LinkSnooper")) : class$com$wolfram$jlink$util$LinkSnooper, this, "kernelMainMessageHandler");
    }

    public void run() {
        if (this.feMain == null || this.kernelMain == null) {
            this.output("Broken Link. Cannot Relay.");
            return;
        }
        this.output("Start Monitoring...");
        this.doPrint = !this.skipInitTraffic;
        Expr expr = null;
        block4: while (true) {
            try {
                while (true) {
                    String head;
                    if (this.feMain.ready()) {
                        expr = this.feMain.getExpr();
                        if (this.skipInitTraffic && !this.doPrint && ((head = expr.head().toString()).equals("EnterTextPacket") || head.equals("EnterExpressionPacket"))) {
                            this.doPrint = true;
                        }
                        this.output(this.toKernelArrow + expr.toString());
                        this.kernelMain.put(expr);
                        this.kernelMain.flush();
                        expr.dispose();
                    }
                    if (this.kernelMain.ready()) {
                        String func;
                        expr = this.kernelMain.getExpr();
                        head = expr.head().toString();
                        String exprToPrint = head.equals("CallPacket") ? ((func = expr.part(1).head().toString()).equals("FrontEnd`SetKernelSymbolContexts") || func.equals("FrontEnd`AddFunctionTemplateInformationToFunctions") || func.equals("FrontEnd`SetFunctionInformation") ? "CallPacket[" + expr.part(1).head().toString() + "[ -- large contents not printed -- ]]" : expr.toString()) : expr.toString();
                        this.output(this.toFEArrow + exprToPrint);
                        if (this.fePreemptive == null && head.equals("CallPacket") && expr.part(1).head().toString().equals("FrontEnd`OpenParallelLinksPacket")) {
                            this.output(" --- Opening special FE links --- ");
                            Expr links = expr.part(new int[]{1, 1});
                            String serviceName = links.part(1).toString();
                            String preemptiveName = links.part(2).toString();
                            String protocol = links.part(3).toString();
                            String protString = protocol.equals("Automatic") ? "" : " -linkprotocol " + protocol;
                            this.kernelService = MathLinkFactory.createKernelLink("-linkmode connect -linkname " + serviceName + protString);
                            this.kernelPreemptive = MathLinkFactory.createKernelLink("-linkmode connect -linkname " + preemptiveName + protString);
                            this.kernelService.addMessageHandler(class$com$wolfram$jlink$util$LinkSnooper == null ? LinkSnooper.class$("com.wolfram.jlink.util.LinkSnooper") : class$com$wolfram$jlink$util$LinkSnooper, this, "kernelServiceMessageHandler");
                            this.kernelPreemptive.addMessageHandler(class$com$wolfram$jlink$util$LinkSnooper == null ? LinkSnooper.class$("com.wolfram.jlink.util.LinkSnooper") : class$com$wolfram$jlink$util$LinkSnooper, this, "kernelPreemptiveMessageHandler");
                            this.kernelMain.putFunction("EvaluatePacket", 1);
                            this.kernelMain.putFunction("LinkConnect", 1);
                            this.kernelMain.putSymbol("MathLink`$ServiceLink");
                            this.kernelMain.flush();
                            this.kernelService.connect();
                            this.kernelMain.discardAnswer();
                            this.kernelMain.putFunction("EvaluatePacket", 1);
                            this.kernelMain.putFunction("LinkConnect", 1);
                            this.kernelMain.putSymbol("MathLink`$PreemptiveLink");
                            this.kernelMain.flush();
                            this.kernelPreemptive.connect();
                            this.kernelMain.discardAnswer();
                            this.kernelMain.putFunction("ReturnPacket", 1);
                            this.kernelMain.putSymbol("Null");
                            this.kernelMain.flush();
                            this.feService = MathLinkFactory.createKernelLink("-linkmode listen " + protString + " -linkoptions MLDontInteract");
                            this.fePreemptive = MathLinkFactory.createKernelLink("-linkmode listen " + protString + " -linkoptions MLDontInteract");
                            this.feService.addMessageHandler(class$com$wolfram$jlink$util$LinkSnooper == null ? LinkSnooper.class$("com.wolfram.jlink.util.LinkSnooper") : class$com$wolfram$jlink$util$LinkSnooper, this, "feServiceMessageHandler");
                            this.fePreemptive.addMessageHandler(class$com$wolfram$jlink$util$LinkSnooper == null ? LinkSnooper.class$("com.wolfram.jlink.util.LinkSnooper") : class$com$wolfram$jlink$util$LinkSnooper, this, "fePreemptiveMessageHandler");
                            expr = new Expr(new Expr(4, "List"), new Expr[]{new Expr(this.feService.name()), new Expr(this.fePreemptive.name()), links.part(3)});
                            expr = new Expr(new Expr(4, "FrontEnd`OpenParallelLinksPacket"), new Expr[]{expr});
                            expr = new Expr(new Expr(4, "CallPacket"), new Expr[]{expr});
                            this.feMain.put(expr);
                            this.feMain.flush();
                            expr.dispose();
                            this.feService.connect();
                            this.feMain.nextPacket();
                            this.feMain.newPacket();
                            this.feMain.putFunction("ReturnPacket", 1);
                            this.feMain.putSymbol("Null");
                            this.feMain.flush();
                            this.fePreemptive.connect();
                            this.feMain.nextPacket();
                            this.feMain.newPacket();
                            this.feMain.putFunction("ReturnPacket", 1);
                            this.feMain.putSymbol("Null");
                            this.feMain.discardAnswer();
                        } else {
                            this.feMain.put(expr);
                            this.feMain.flush();
                            expr.dispose();
                        }
                    }
                    if (this.fePreemptive != null && this.fePreemptive.ready()) {
                        expr = this.fePreemptive.getExpr();
                        this.output(this.preemptiveLinkPrefix + this.toKernelArrow + expr.toString());
                        this.kernelPreemptive.put(expr);
                        this.kernelPreemptive.flush();
                        expr.dispose();
                    }
                    if (this.kernelPreemptive != null && this.kernelPreemptive.ready()) {
                        expr = this.kernelPreemptive.getExpr();
                        this.output(this.preemptiveLinkPrefix + this.toFEArrow + expr.toString());
                        this.fePreemptive.put(expr);
                        this.fePreemptive.flush();
                        expr.dispose();
                    }
                    if (this.feService != null && this.feService.ready()) {
                        expr = this.feService.getExpr();
                        this.output(this.serviceLinkPrefix + this.toKernelArrow + expr.toString());
                        this.kernelService.put(expr);
                        this.kernelService.flush();
                        expr.dispose();
                    }
                    if (this.kernelService != null && this.kernelService.ready()) {
                        expr = this.kernelService.getExpr();
                        this.output(this.serviceLinkPrefix + this.toFEArrow + expr.toString());
                        this.feService.put(expr);
                        this.feService.flush();
                        expr.dispose();
                    }
                    try {
                        Thread.sleep(10L);
                        continue block4;
                    }
                    catch (InterruptedException err1) {
                        continue;
                    }
                    break;
                }
            }
            catch (MathLinkException err) {
                int errCode = err.getErrCode();
                this.output("MathLinkException: Code " + errCode + " : " + err.getMessage());
                if (errCode == this.kernelMain.error()) {
                    this.output("Exception was from the " + this.kernelSideName + " side.");
                } else if (errCode == this.feMain.error()) {
                    this.output("Exception was from the " + this.feSideName + " side.");
                } else if (this.kernelPreemptive != null && errCode == this.kernelPreemptive.error()) {
                    this.output("Exception was from the " + this.kernelSideName + " side, on the Preemptive link.");
                } else if (this.fePreemptive != null && errCode == this.fePreemptive.error()) {
                    this.output("Exception was from the " + this.feSideName + " side, on the Preemptive link.");
                } else if (this.kernelService != null && errCode == this.kernelService.error()) {
                    this.output("Exception was from the " + this.kernelSideName + " side, on the Service link.");
                } else if (this.feService != null && errCode == this.feService.error()) {
                    this.output("Exception was from the " + this.feSideName + " side, on the Service link.");
                }
                if (this.logFileStrm != null) {
                    this.logFileStrm.close();
                }
                this.feMain.close();
                this.kernelMain.close();
                if (this.kernelService != null) {
                    this.kernelService.close();
                }
                if (this.feService != null) {
                    this.feService.close();
                }
                if (this.kernelPreemptive != null) {
                    this.kernelPreemptive.close();
                }
                if (this.fePreemptive != null) {
                    this.fePreemptive.close();
                }
                return;
            }
        }
    }

    private void output(String s) {
        if (this.doPrint) {
            PrintStream p = this.strm != null ? this.strm : System.out;
            p.println(s);
            if (this.logFileStrm != null) {
                this.logFileStrm.println(s);
            }
        }
    }

    public void feMainMessageHandler(int msgType, int ignore) throws MathLinkException {
        this.output("****** Message " + this.toKernelArrow + " on Main: " + msgType);
        this.kernelMain.putMessage(msgType);
    }

    public void kernelMainMessageHandler(int msgType, int ignore) throws MathLinkException {
        this.output("****** Message " + this.toFEArrow + " on Main: " + msgType);
        this.feMain.putMessage(msgType);
    }

    public void fePreemptiveMessageHandler(int msgType, int ignore) throws MathLinkException {
        this.output(this.preemptiveLinkPrefix + "****** Message " + this.toKernelArrow + " on Preemptive: " + msgType);
        this.kernelPreemptive.putMessage(msgType);
    }

    public void kernelPreemptiveMessageHandler(int msgType, int ignore) throws MathLinkException {
        this.output(this.preemptiveLinkPrefix + "****** Message " + this.toFEArrow + " on Preemptive: " + msgType);
        this.fePreemptive.putMessage(msgType);
    }

    public void feServiceMessageHandler(int msgType, int ignore) throws MathLinkException {
        this.output(this.serviceLinkPrefix + "****** Message " + this.toKernelArrow + " on Service: " + msgType);
        this.kernelService.putMessage(msgType);
    }

    public void kernelServiceMessageHandler(int msgType, int ignore) throws MathLinkException {
        this.output(this.serviceLinkPrefix + "****** Message " + this.toFEArrow + " on Service: " + msgType);
        this.feService.putMessage(msgType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

