/*
 * Decompiled with CFR 0.152.
 */
package com.developpez.adiguba.shell;

import com.developpez.adiguba.shell.ReadableCharSequence;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessConsumer {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadGroup threadGroup = new ThreadGroup("ProcessConsumerThreadGroup");
        private int count = 0;

        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(this.threadGroup, runnable, "ProcessConsumerThread-" + ++this.count);
            t.setPriority(5);
            t.setDaemon(true);
            return t;
        }
    });
    private static final int BUF_SIZE = 8192;
    private final Charset charset;
    private Readable stdin = null;
    private Appendable stdout = System.out;
    private Appendable stderr = System.err;
    private boolean started = false;
    private final Process userProcess;
    private final ProcessBuilder builder;

    public ProcessConsumer(Process process) {
        this(null, process, null);
    }

    public ProcessConsumer(Process process, Charset cs) {
        this(null, process, cs);
    }

    public ProcessConsumer(ProcessBuilder pb) {
        this(pb, null, null);
    }

    public ProcessConsumer(ProcessBuilder pb, Charset cs) {
        this(pb, null, cs);
    }

    private ProcessConsumer(ProcessBuilder builder, Process process, Charset charset) {
        this.builder = builder;
        this.userProcess = process;
        Charset charset2 = this.charset = charset != null ? charset : Charset.defaultCharset();
        if (this.builder == null && this.userProcess == null) {
            throw new NullPointerException("null");
        }
    }

    private Readable readable(InputStream in) {
        if (in == null) {
            return null;
        }
        return new InputStreamReader(in, this.charset);
    }

    private Readable readable(CharSequence in) {
        if (in == null) {
            return null;
        }
        return new ReadableCharSequence(in);
    }

    public ProcessConsumer input(Readable in) throws IllegalStateException {
        if (this.stdin != null) {
            throw new IllegalStateException("INPUT already set.");
        }
        this.stdin = in;
        return this;
    }

    public ProcessConsumer input(InputStream in) throws IllegalStateException {
        if (in == System.in) {
            throw new IllegalStateException("System.in cannot be used as 'input'");
        }
        return this.input(this.readable(in));
    }

    public ProcessConsumer input(CharSequence in) throws IllegalStateException {
        return this.input(this.readable(in));
    }

    public ProcessConsumer input() throws IllegalStateException {
        return this.input((Readable)null);
    }

    private Appendable appendable(OutputStream out) {
        if (out == null) {
            return null;
        }
        return new OutputStreamWriter(out, this.charset);
    }

    public ProcessConsumer output(Appendable out) throws IllegalStateException {
        if (this.stdout != System.out) {
            throw new IllegalStateException("OUTPUT already set.");
        }
        this.stdout = out;
        return this;
    }

    public ProcessConsumer output(OutputStream out) throws IllegalStateException {
        return this.output(this.appendable(out));
    }

    public ProcessConsumer output(PrintStream out) throws IllegalStateException {
        return this.output((Appendable)out);
    }

    public ProcessConsumer output() throws IllegalStateException {
        return this.output((Appendable)null);
    }

    public ProcessConsumer error(Appendable err) throws IllegalStateException {
        if (this.stderr != System.err) {
            throw new IllegalStateException("ERROR already set.");
        }
        this.stderr = err;
        return this;
    }

    public ProcessConsumer error(OutputStream err) throws IllegalStateException {
        return this.error(this.appendable(err));
    }

    public ProcessConsumer error(PrintStream err) throws IllegalStateException {
        return this.error((Appendable)err);
    }

    public ProcessConsumer error() throws IllegalStateException {
        return this.error((Appendable)null);
    }

    public ProcessConsumer errorRedirect() throws IllegalStateException {
        if (this.builder == null) {
            throw new IllegalStateException("No ProcessBuilder");
        }
        this.error();
        this.builder.redirectErrorStream(true);
        return this;
    }

    private Process getProcess() throws IOException {
        if (this.started) {
            throw new IOException("Process already started");
        }
        if (this.builder == null) {
            return this.userProcess;
        }
        return this.builder.start();
    }

    public int consume() throws IOException {
        Future<Void> inputTask = null;
        Future<Void> errorTask = null;
        Process process = this.getProcess();
        try {
            OutputStream pIn = process.getOutputStream();
            if (this.stdin == null) {
                pIn.close();
            } else {
                inputTask = this.dumpInBackground(this.stdin, this.appendable(pIn));
            }
            InputStream pErr = process.getErrorStream();
            if (this.stderr == null) {
                pErr.close();
            } else {
                errorTask = this.dumpInBackground(this.readable(pErr), this.stderr);
            }
            InputStream pOut = process.getInputStream();
            if (this.stdout == null) {
                pOut.close();
            } else {
                this.dump(this.readable(pOut), this.stdout);
            }
            try {
                int n = process.waitFor();
                return n;
            }
            catch (InterruptedException e) {
                InterruptedIOException ioe = new InterruptedIOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        finally {
            process.destroy();
            if (inputTask != null) {
                inputTask.cancel(true);
            }
            if (errorTask != null) {
                errorTask.cancel(true);
            }
        }
    }

    public String consumeAsString() throws IOException, IllegalStateException {
        StringBuilder builder = new StringBuilder();
        this.output(builder).consume();
        return builder.toString();
    }

    public Future<Integer> consumeInBackground() {
        return ProcessConsumer.inBackground(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ProcessConsumer.this.consume();
            }
        });
    }

    public Future<String> consumeAsStringInBackground() {
        return ProcessConsumer.inBackground(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ProcessConsumer.this.consumeAsString();
            }
        });
    }

    private void tryToClose(Object c) {
        if (c instanceof Closeable && c != System.in && c != System.out && c != System.err) {
            try {
                ((Closeable)c).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (c == this.stdin) {
                this.stdin = null;
            } else if (c == this.stdout) {
                this.stdout = null;
            } else if (c == this.stderr) {
                this.stderr = null;
            }
        }
    }

    protected void finalize() {
        this.tryToClose(this.stdin);
        this.tryToClose(this.stdout);
        this.tryToClose(this.stderr);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void dump(Readable in, Appendable out) throws IOException {
        try {
            try {
                block11: {
                    int len;
                    CharBuffer cb;
                    Thread current;
                    Flushable flushable;
                    block10: {
                        flushable = null;
                        if (out instanceof Flushable) {
                            flushable = (Flushable)((Object)out);
                        }
                        current = Thread.currentThread();
                        cb = CharBuffer.allocate(8192);
                        cb.clear();
                        if (!true) break block10;
                        if (current.isInterrupted()) return;
                        len = in.read(cb);
                        if (len <= 0) return;
                        if (current.isInterrupted()) break block11;
                    }
                    do {
                        cb.position(0).limit(len);
                        out.append(cb);
                        cb.clear();
                        if (flushable != null) {
                            flushable.flush();
                        }
                        if (current.isInterrupted()) return;
                        len = in.read(cb);
                        if (len <= 0) return;
                    } while (!current.isInterrupted());
                }
                return;
            }
            finally {
                this.tryToClose(in);
            }
        }
        finally {
            this.tryToClose(out);
        }
    }

    public final Future<Void> dumpInBackground(final Readable in, final Appendable out) {
        return ProcessConsumer.inBackground(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ProcessConsumer.this.dump(in, out);
                return null;
            }
        });
    }

    protected static <T> Future<T> inBackground(Callable<T> task) {
        return EXECUTOR.submit(task);
    }
}

