/*
 * Decompiled with CFR 0.152.
 */
package com.developpez.adiguba.shell;

import java.io.Closeable;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;

public class ReadableCharSequence
implements Readable,
Closeable {
    private final CharSequence cs;
    private int pos = 0;

    public ReadableCharSequence(CharSequence cs) {
        this.cs = cs;
        if (this.cs == null) {
            throw new NullPointerException("null");
        }
    }

    public void close() throws IOException {
        if (this.cs instanceof Closeable) {
            ((Closeable)((Object)this.cs)).close();
        }
        this.pos = -1;
    }

    public int read(CharBuffer cb) throws IOException {
        if (this.pos < 0) {
            throw new ClosedChannelException();
        }
        int remaining = this.cs.length() - this.pos;
        if (remaining > 0) {
            int len = Math.min(cb.remaining(), remaining);
            cb.append(this.cs, this.pos, len);
            this.pos += len;
            return len;
        }
        return -1;
    }
}

