/*
 * Decompiled with CFR 0.152.
 */
package com.developpez.adiguba.shell;

import com.developpez.adiguba.shell.ProcessConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shell {
    private static final String[] DEFAULT_WIN9X_SHELL = new String[]{"command.com", "/C"};
    private static final String[] DEFAULT_WINNT_SHELL = new String[]{"cmd.exe", "/C"};
    private static final String[] DEFAULT_UNIX_SHELL = new String[]{"/bin/sh", "-c"};
    private static final String[] SYSTEM_SHELL = Shell.getSystemShell();
    private final String[] shell;
    private Charset charset = null;
    private File directory = null;
    private Map<String, String> userEnv = null;
    private boolean systemEnvInherited = true;

    private static String[] getSystemShell() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            String comspec = System.getenv("ComSpec");
            if (comspec != null) {
                return new String[]{comspec, "/C"};
            }
            if (osName.startsWith("Windows 3") || osName.startsWith("Windows 95") || osName.startsWith("Windows 98") || osName.startsWith("Windows ME")) {
                return DEFAULT_WIN9X_SHELL;
            }
            return DEFAULT_WINNT_SHELL;
        }
        String shell = System.getenv("SHELL");
        if (shell != null) {
            return new String[]{shell, "-c"};
        }
        return DEFAULT_UNIX_SHELL;
    }

    public Shell() {
        this.shell = SYSTEM_SHELL;
    }

    public Shell(String ... cmds) {
        this.shell = new String[cmds.length];
        System.arraycopy(cmds, 0, this.shell, 0, this.shell.length);
    }

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = Charset.defaultCharset();
        }
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setCharset(String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        this.charset = Charset.forName(charsetName);
    }

    public Map<String, String> getUserEnv() {
        if (this.userEnv == null) {
            this.userEnv = new HashMap<String, String>();
        }
        return this.userEnv;
    }

    public File getDirectory() {
        if (this.directory == null) {
            this.directory = new File("").getAbsoluteFile();
        }
        return this.directory;
    }

    public void setDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory");
        }
        this.directory = directory;
    }

    public boolean isSystemEnvInherited() {
        return this.systemEnvInherited;
    }

    public void setSystemEnvInherited(boolean inheritSystemEnv) {
        this.systemEnvInherited = inheritSystemEnv;
    }

    private ProcessBuilder create(String ... args) {
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(this.directory);
        if (!this.systemEnvInherited) {
            pb.environment().clear();
        }
        if (this.userEnv != null) {
            pb.environment().putAll(this.userEnv);
        }
        return pb;
    }

    public ProcessConsumer shell() {
        return new ProcessConsumer(this.create(this.shell[0]), this.charset);
    }

    public ProcessConsumer command(String commandLine) {
        ProcessBuilder pb = this.create(this.shell);
        pb.command().add(commandLine);
        return new ProcessConsumer(pb, this.charset);
    }

    public ProcessConsumer command(String commandLine, Object ... arguments) {
        return this.command(MessageFormat.format(commandLine, arguments));
    }

    public ProcessConsumer exec(String ... args) {
        return new ProcessConsumer(this.create(args), this.charset);
    }

    public String toString() {
        return this.shell[0];
    }

    public static int system(String commandLine) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(SYSTEM_SHELL);
        pb.command().add(commandLine);
        return new ProcessConsumer(pb, null).consume();
    }

    public static int system(String commandLine, Object ... arguments) throws IOException {
        return Shell.system(MessageFormat.format(commandLine, arguments));
    }

    public static int execute(String ... args) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(args);
        return new ProcessConsumer(pb, null).consume();
    }
}

