/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowBar;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.DockedContainer;
import org.noos.xing.mydoggy.plaf.ui.FloatingContainer;
import org.noos.xing.mydoggy.plaf.ui.FloatingLiveContainer;
import org.noos.xing.mydoggy.plaf.ui.SlidingContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.DebugSplitPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.JToolScrollBar;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.ToolsOnBarMouseListener;
import org.noos.xing.mydoggy.plaf.ui.drag.ToolWindowBarDropTarget;
import org.noos.xing.mydoggy.plaf.ui.drag.ToolWindowDropTarget;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MyDoggyToolWindowBar
extends PropertyChangeEventSource
implements ToolWindowBar,
SwingConstants,
PropertyChangeListener {
    public static final int VERTICAL_LEFT = 2;
    public static final int VERTICAL_RIGHT = 3;
    public static final int HORIZONTAL = 1;
    static int dragComponentLength;
    protected MyDoggyToolWindowManager manager;
    protected ToolWindowAnchor anchor;
    protected int dividerSize;
    protected boolean aggregateMode;
    protected JToolScrollBar toolScrollBar;
    protected JPanel representativeButtonsPanel;
    protected TableLayout representativeButtonsPanelLayout;
    protected JSplitPane splitPane;
    protected MultiSplitDockableContainer multiSplitDockableContainer;
    protected ContentPanel contentPanel;
    protected JPopupMenu popupMenu;
    protected int length;
    protected int availableTools;
    protected int orientation;
    protected boolean horizontal;
    protected PropertyChangeSupport propertyChangeSupport;
    protected boolean tempShowed;
    boolean valueAdjusting = false;

    public MyDoggyToolWindowBar(MyDoggyToolWindowManager manager, JSplitPane splitPane, ToolWindowAnchor anchor) {
        this.manager = manager;
        this.splitPane = splitPane;
        if (splitPane instanceof DebugSplitPane) {
            ((DebugSplitPane)splitPane).setToolWindowBar(this);
        }
        this.anchor = anchor;
        this.availableTools = 0;
        this.dividerSize = 3;
        this.length = manager.getResourceManager().getInt("toolwindowbar." + anchor.toString().toLowerCase() + ".length", 23);
        this.initComponents();
        this.initListeners();
        if (anchor == ToolWindowAnchor.LEFT || anchor == ToolWindowAnchor.TOP) {
            this.setSplitDividerLocation(0);
        }
    }

    public ToolWindowManager getToolWindowManager() {
        return this.manager;
    }

    public ToolWindowAnchor getAnchor() {
        return this.anchor;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int size) {
        if (this.dividerSize == size) {
            return;
        }
        if (size < 1) {
            throw new IllegalArgumentException("Size cannot be lesser than 1");
        }
        int old = this.dividerSize;
        this.dividerSize = size;
        this.firePropertyChangeEvent("dividerSize", old, size);
    }

    public void setAggregateMode(boolean enable) {
        if (this.aggregateMode == enable) {
            return;
        }
        boolean old = this.aggregateMode;
        this.aggregateMode = enable;
        this.firePropertyChangeEvent("aggregateMode", old, enable);
    }

    public boolean isAggregateMode() {
        return this.aggregateMode;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setLength(int length) {
        if (this.length == length) {
            return;
        }
        int old = this.length;
        this.length = length;
        this.firePropertyChangeEvent("length", old, length);
    }

    public int getLength() {
        return this.length;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (this.popupMenu != null && this.popupMenu.equals(popupMenu)) {
            return;
        }
        JPopupMenu old = this.popupMenu;
        this.popupMenu = popupMenu;
        this.firePropertyChangeEvent("popupMenu", old, popupMenu);
    }

    public ToolWindow[] getToolWindows() {
        return this.manager.getToolsByAnchor(this.anchor);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public String toString() {
        return "MyDoggyToolWindowBar{anchor=" + this.anchor + ", availableTools=" + this.availableTools + ", orientation=" + this.orientation + '}';
    }

    public Object getLayout() {
        return this.multiSplitDockableContainer.getModel();
    }

    public void setLayout(Object layout) {
        this.multiSplitDockableContainer.setModel((MultiSplitLayout.Node)layout);
    }

    public Container getContainer() {
        return this.toolScrollBar;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void ensureVisible(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MyDoggyToolWindowBar.this.toolScrollBar.ensureVisible(component);
            }
        });
    }

    public int getAvailableTools() {
        return this.availableTools;
    }

    public boolean isTempShowed() {
        return this.tempShowed;
    }

    public void setTempShowed(boolean tempShowed) {
        boolean old = this.tempShowed;
        this.tempShowed = tempShowed;
        this.manager.syncPanel(this.anchor);
        this.firePropertyChangeEvent("tempShowed", old, tempShowed);
    }

    public int getRepresentativeAnchorIndex(Component representativeAnchor) {
        TableLayoutConstraints constraints = this.representativeButtonsPanelLayout.getConstraints(representativeAnchor);
        if (constraints == null) {
            return -1;
        }
        if (this.horizontal) {
            return constraints.col1 / 2 - 1;
        }
        return constraints.row1 / 2 - 1;
    }

    public void deactiveTool(ToolWindow toolWindow) {
        this.valueAdjusting = true;
        toolWindow.setActive(false);
        this.valueAdjusting = false;
    }

    public int getSize() {
        return this.getAvailableTools() > 0 ? this.getLength() : 0;
    }

    protected void initComponents() {
        this.splitPane.setName(this.anchor.toString());
        this.splitPane.setFocusCycleRoot(true);
        this.contentPanel = new ContentPanel("toolWindow.container.");
        this.contentPanel.setDropTarget(new ToolWindowDropTarget(this.contentPanel, this.manager, this.anchor));
        this.representativeButtonsPanel = (JPanel)this.manager.getResourceManager().createComponent("ANCHOR_CONTENT_PANE", this.manager.getContext());
        this.representativeButtonsPanel.setName("toolWindowManager.bar." + this.anchor.toString());
        this.representativeButtonsPanel.setFocusable(false);
        this.representativeButtonsPanel.setFocusCycleRoot(true);
        switch (this.anchor) {
            case LEFT: 
            case RIGHT: {
                this.horizontal = false;
                this.representativeButtonsPanelLayout = new ExtendedTableLayout(new double[][]{{2.0, this.getLength() - 4, 2.0}, {0.0}});
                this.representativeButtonsPanel.setLayout((LayoutManager)this.representativeButtonsPanelLayout);
                this.orientation = 0;
                break;
            }
            default: {
                this.horizontal = true;
                this.representativeButtonsPanelLayout = new ExtendedTableLayout(new double[][]{{0.0}, {2.0, this.getLength() - 4, 2.0}});
                this.representativeButtonsPanel.setLayout((LayoutManager)this.representativeButtonsPanelLayout);
                this.orientation = 1;
            }
        }
        this.multiSplitDockableContainer = new MultiSplitDockableContainer(this.manager, this.orientation);
        this.toolScrollBar = new JToolScrollBar(this.manager.getResourceManager(), this.orientation, this.representativeButtonsPanel);
        this.representativeButtonsPanel.setDropTarget(new ToolWindowBarDropTarget(this.manager, this.anchor, this.representativeButtonsPanel));
        this.representativeButtonsPanel.addMouseListener(new ToolsOnBarMouseListener(this.manager, this));
    }

    protected void initListeners() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        AvailableListener availableListener = new AvailableListener();
        this.propertyChangeSupport.addPropertyChangeListener("available", availableListener);
        this.propertyChangeSupport.addPropertyChangeListener("representativeAnchorButtonVisible", availableListener);
        this.propertyChangeSupport.addPropertyChangeListener("showUnavailableTools", new ShowUnavailableToolsListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.before", new VisibleBeforeListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.DOCKED", new VisibleDockedListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.FLOATING", new VisibleFloatingListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.FLOATING_FREE", new VisibleFloatingFreeListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.SLIDING", new VisibleSlidingListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.FLOATING_LIVE", new VisibleFloatingLiveListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible", new VisibleListener());
        this.propertyChangeSupport.addPropertyChangeListener("active.before", new ActiveBeforeListener());
        this.propertyChangeSupport.addPropertyChangeListener("active", new ActiveListener());
        this.propertyChangeSupport.addPropertyChangeListener("type", new TypeListener());
        this.propertyChangeSupport.addPropertyChangeListener("index", new IndexListener());
        this.propertyChangeSupport.addPropertyChangeListener("title", new TitleListener());
        this.propertyChangeSupport.addPropertyChangeListener("icon", new IconListener());
        this.propertyChangeSupport.addPropertyChangeListener("dockLength", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ToolWindow toolWindow = (ToolWindow)evt.getSource();
                if (toolWindow.isVisible()) {
                    MyDoggyToolWindowBar.this.setSplitDividerLocation((Integer)evt.getNewValue());
                    SwingUtil.repaint(MyDoggyToolWindowBar.this.splitPane);
                }
            }
        });
        DragListener dragListener = new DragListener();
        this.propertyChangeSupport.addPropertyChangeListener("startDrag", dragListener);
        this.propertyChangeSupport.addPropertyChangeListener("endDrag", dragListener);
        this.propertyChangeSupport.addPropertyChangeListener("maximized", new MaximizedListener());
        this.addPropertyChangeListener("dividerSize", new DividerSizeListener());
        this.addPropertyChangeListener("length", new BarLengthListener());
    }

    protected int getSplitDividerLocation() {
        int dividerLocation = 0;
        switch (this.anchor) {
            case LEFT: 
            case TOP: {
                dividerLocation = this.splitPane.getDividerLocation();
                break;
            }
            case RIGHT: {
                dividerLocation = this.splitPane.getWidth() - this.splitPane.getDividerLocation();
                break;
            }
            case BOTTOM: {
                dividerLocation = this.splitPane.getHeight() - this.splitPane.getDividerLocation();
            }
        }
        return dividerLocation;
    }

    protected void setSplitDividerLocation(int divederLocation) {
        if (divederLocation == -1) {
            switch (this.anchor) {
                case LEFT: {
                    this.splitPane.setDividerLocation(this.splitPane.getWidth());
                    break;
                }
                case TOP: {
                    this.splitPane.setDividerLocation(this.splitPane.getHeight());
                    break;
                }
                case RIGHT: {
                    this.splitPane.setDividerLocation(0);
                    break;
                }
                case BOTTOM: {
                    this.splitPane.setDividerLocation(0);
                }
            }
        } else {
            switch (this.anchor) {
                case LEFT: 
                case TOP: {
                    this.splitPane.setDividerLocation(divederLocation);
                    break;
                }
                case RIGHT: {
                    this.splitPane.setDividerLocation(Math.abs(this.splitPane.getWidth() - divederLocation));
                    break;
                }
                case BOTTOM: {
                    this.splitPane.setDividerLocation(Math.abs(this.splitPane.getHeight() - divederLocation));
                }
            }
        }
    }

    protected Component getSplitPaneContent() {
        return this.contentPanel.getComponent();
    }

    protected void addRepresentativeAnchor(Component representativeAnchor, int index) {
        ++this.availableTools;
        if (this.horizontal) {
            int width = representativeAnchor.getPreferredSize().width + 6;
            this.representativeButtonsPanelLayout.insertColumn(this.representativeButtonsPanelLayout.getNumColumn(), this.representativeButtonsPanelLayout.getNumColumn() > 0 ? 5.0 : 1.0);
            this.representativeButtonsPanelLayout.insertColumn(this.representativeButtonsPanelLayout.getNumColumn(), (double)width);
            int finalCol = index * 2 + 2;
            if (finalCol >= this.representativeButtonsPanelLayout.getNumColumn()) {
                index = -1;
            }
            if (index >= 0) {
                Component[] components = this.representativeButtonsPanel.getComponents();
                Hashtable<Integer, Double> olds = new Hashtable<Integer, Double>();
                for (Component component : components) {
                    TableLayoutConstraints constraints = this.representativeButtonsPanelLayout.getConstraints(component);
                    if (constraints.col1 < finalCol) continue;
                    int newCol1 = constraints.col1 + 2;
                    this.representativeButtonsPanelLayout.setConstraints(component, new TableLayoutConstraints(newCol1 + ",1,"));
                    olds.put(newCol1, this.representativeButtonsPanelLayout.getColumn(newCol1));
                    Double colSize = (Double)olds.get(constraints.col1);
                    if (colSize == null) {
                        colSize = this.representativeButtonsPanelLayout.getColumn(constraints.col1);
                    }
                    this.representativeButtonsPanelLayout.setColumn(newCol1, colSize.doubleValue());
                }
                this.representativeButtonsPanelLayout.setColumn(finalCol, (double)width);
                this.representativeButtonsPanel.add(representativeAnchor, index * 2 + 2 + ",1");
            } else {
                this.representativeButtonsPanel.add(representativeAnchor, this.representativeButtonsPanelLayout.getNumColumn() - 1 + ",1");
            }
        } else {
            int height = Math.max(representativeAnchor.getHeight(), Math.max(representativeAnchor.getPreferredSize().height, representativeAnchor.getSize().height)) + 12;
            this.representativeButtonsPanelLayout.insertRow(this.representativeButtonsPanelLayout.getNumRow(), this.representativeButtonsPanelLayout.getNumRow() > 0 ? 5.0 : 1.0);
            this.representativeButtonsPanelLayout.insertRow(this.representativeButtonsPanelLayout.getNumRow(), (double)height);
            int finalRow = index * 2 + 2;
            if (finalRow >= this.representativeButtonsPanelLayout.getNumRow()) {
                index = -1;
            }
            if (index >= 0) {
                Component[] components = this.representativeButtonsPanel.getComponents();
                Hashtable<Integer, Double> olds = new Hashtable<Integer, Double>();
                for (Component component : components) {
                    TableLayoutConstraints constraints = this.representativeButtonsPanelLayout.getConstraints(component);
                    if (constraints.row1 < finalRow) continue;
                    int newRow1 = constraints.row1 + 2;
                    this.representativeButtonsPanelLayout.setConstraints(component, new TableLayoutConstraints("1," + newRow1));
                    olds.put(newRow1, this.representativeButtonsPanelLayout.getRow(newRow1));
                    Double rowSize = (Double)olds.get(constraints.row1);
                    if (rowSize == null) {
                        rowSize = this.representativeButtonsPanelLayout.getRow(constraints.row1);
                    }
                    this.representativeButtonsPanelLayout.setRow(newRow1, rowSize.doubleValue());
                }
                if (this.representativeButtonsPanelLayout.getNumRow() <= finalRow) {
                    this.representativeButtonsPanelLayout.setRow(this.representativeButtonsPanelLayout.getNumRow() - 1, (double)height);
                } else {
                    this.representativeButtonsPanelLayout.setRow(finalRow, (double)height);
                }
                this.representativeButtonsPanel.add(representativeAnchor, "1," + (index * 2 + 2));
            } else {
                this.representativeButtonsPanel.add(representativeAnchor, "1," + (this.representativeButtonsPanelLayout.getNumRow() - 1));
            }
        }
        SwingUtil.repaint(this.toolScrollBar);
    }

    protected void removeRepresentativeAnchor(Component representativeAnchor, DockableDescriptor descriptor) {
        if (representativeAnchor == null) {
            return;
        }
        TableLayoutConstraints constraints = this.representativeButtonsPanelLayout.getConstraints(representativeAnchor);
        if (constraints == null) {
            return;
        }
        --this.availableTools;
        int toDelete = this.horizontal ? constraints.col1 : constraints.row1;
        this.representativeButtonsPanel.remove(representativeAnchor);
        if (this.horizontal) {
            this.representativeButtonsPanelLayout.deleteColumn(toDelete);
            this.representativeButtonsPanelLayout.deleteColumn(toDelete - 1);
        } else {
            this.representativeButtonsPanelLayout.deleteRow(toDelete);
            this.representativeButtonsPanelLayout.deleteRow(toDelete - 1);
        }
        SwingUtil.repaint(this.toolScrollBar);
        descriptor.resetRepresentativeAnchor();
    }

    protected class DividerSizeListener
    implements PropertyChangeListener {
        protected DividerSizeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (MyDoggyToolWindowBar.this.splitPane.getDividerSize() > 0) {
                MyDoggyToolWindowBar.this.splitPane.setDividerSize((Integer)evt.getNewValue());
            }
        }
    }

    protected class MaximizedListener
    implements PropertyChangeListener {
        protected MaximizedListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            if (descriptor.getToolWindow().getType() == ToolWindowType.DOCKED) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    descriptor.setTempDivederLocation(MyDoggyToolWindowBar.this.getSplitDividerLocation());
                    MyDoggyToolWindow maximizedTool = descriptor.getToolWindow();
                    for (ToolWindow tool : descriptor.getManager().getToolWindows()) {
                        if (tool == maximizedTool || tool.getType() == ToolWindowType.FLOATING || tool.getType() == ToolWindowType.FLOATING_FREE || tool.getType() == ToolWindowType.EXTERN) continue;
                        tool.setVisible(false);
                    }
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(-1);
                    SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                } else {
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(descriptor.getTempDivederLocation());
                    SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                }
            }
        }
    }

    protected class DragListener
    implements PropertyChangeListener {
        protected DragListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("startDrag".equals(evt.getPropertyName())) {
                Component cmp = SwingUtil.getComponentWhoseParentIs((Component)evt.getSource(), MyDoggyToolWindowBar.this.representativeButtonsPanel);
                TableLayout layout = (TableLayout)MyDoggyToolWindowBar.this.representativeButtonsPanel.getLayout();
                switch (MyDoggyToolWindowBar.this.anchor) {
                    case LEFT: 
                    case RIGHT: {
                        dragComponentLength = cmp.getHeight();
                        layout.setRow(layout.getConstraints((Component)cmp).row1, 0.0);
                        break;
                    }
                    case TOP: 
                    case BOTTOM: {
                        dragComponentLength = cmp.getWidth();
                        layout.setColumn(layout.getConstraints((Component)cmp).col1, 0.0);
                    }
                }
                SwingUtil.repaint(MyDoggyToolWindowBar.this.representativeButtonsPanel);
            } else if ("endDrag".equals(evt.getPropertyName())) {
                for (Component cmp : MyDoggyToolWindowBar.this.representativeButtonsPanel.getComponents()) {
                    Component source = SwingUtil.getComponentWhoseParentIs((Component)evt.getSource(), MyDoggyToolWindowBar.this.representativeButtonsPanel);
                    if (cmp != source) continue;
                    TableLayout layout = (TableLayout)MyDoggyToolWindowBar.this.representativeButtonsPanel.getLayout();
                    switch (MyDoggyToolWindowBar.this.anchor) {
                        case LEFT: 
                        case RIGHT: {
                            layout.setRow(layout.getConstraints((Component)cmp).row1, (double)dragComponentLength);
                            break;
                        }
                        case TOP: 
                        case BOTTOM: {
                            layout.setColumn(layout.getConstraints((Component)cmp).col1, (double)dragComponentLength);
                        }
                    }
                    SwingUtil.repaint(MyDoggyToolWindowBar.this.representativeButtonsPanel);
                    MyDoggyToolWindowBar.this.manager.syncPanel(MyDoggyToolWindowBar.this.anchor);
                }
            } else {
                throw new IllegalArgumentException("Invalid property name. [property : " + evt.getPropertyName() + "]");
            }
        }
    }

    protected class BarLengthListener
    implements PropertyChangeListener {
        protected BarLengthListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int oldValue = (Integer)evt.getOldValue() - 4;
            int newValue = (Integer)evt.getNewValue() - 4;
            switch (MyDoggyToolWindowBar.this.anchor) {
                case LEFT: 
                case RIGHT: {
                    int size = MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.getNumColumn();
                    for (int i = 0; i < size; ++i) {
                        if (MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.getColumn(i) != (double)oldValue) continue;
                        MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.setColumn(i, (double)newValue);
                    }
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    int size = MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.getNumRow();
                    for (int i = 0; i < size; ++i) {
                        if (MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.getRow(i) != (double)oldValue) continue;
                        MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.setRow(i, (double)newValue);
                    }
                    break;
                }
            }
            SwingUtil.repaint(MyDoggyToolWindowBar.this.representativeButtonsPanel);
        }
    }

    protected class TitleListener
    extends IndexListener {
        protected TitleListener() {
        }
    }

    protected class IconListener
    extends IndexListener {
        protected IconListener() {
        }
    }

    protected class IndexListener
    implements PropertyChangeListener {
        protected IndexListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            JLabel representativeAnchor = descriptor.getRepresentativeAnchor();
            if (representativeAnchor != null) {
                TableLayoutConstraints constraints = MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.getConstraints((Component)representativeAnchor);
                if (MyDoggyToolWindowBar.this.horizontal) {
                    int width = representativeAnchor.getPreferredSize().width + 6;
                    MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.setColumn(constraints.col1, (double)width);
                } else {
                    int height = Math.max(representativeAnchor.getPreferredSize().height, representativeAnchor.getSize().height);
                    MyDoggyToolWindowBar.this.representativeButtonsPanelLayout.setRow(constraints.row1, (double)height);
                }
                SwingUtil.repaint(MyDoggyToolWindowBar.this.representativeButtonsPanel);
            }
        }
    }

    protected class VisibleFloatingLiveListener
    implements PropertyChangeListener {
        protected VisibleFloatingLiveListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = (ToolWindowDescriptor)evt.getSource();
            boolean visible = (Boolean)evt.getNewValue();
            Component content = visible ? toolWindowDescriptor.getComponent() : null;
            FloatingLiveContainer container = (FloatingLiveContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.FLOATING_LIVE);
            if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                return;
            }
            container.setVisible(visible);
        }
    }

    protected class VisibleSlidingListener
    implements PropertyChangeListener {
        protected VisibleSlidingListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = (ToolWindowDescriptor)evt.getSource();
            boolean visible = (Boolean)evt.getNewValue();
            Component content = visible ? toolWindowDescriptor.getComponent() : null;
            SlidingContainer container = (SlidingContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.SLIDING);
            if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                return;
            }
            container.setVisible(visible, MyDoggyToolWindowBar.this.getContainer());
        }
    }

    protected static class VisibleFloatingFreeListener
    implements PropertyChangeListener {
        protected VisibleFloatingFreeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = (ToolWindowDescriptor)evt.getSource();
            boolean visible = (Boolean)evt.getNewValue();
            Component content = visible ? toolWindowDescriptor.getComponent() : null;
            FloatingContainer container = (FloatingContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.FLOATING_FREE);
            if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                return;
            }
            container.propertyChange(evt);
            container.setVisible(visible);
        }
    }

    protected static class VisibleFloatingListener
    implements PropertyChangeListener {
        protected VisibleFloatingListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = (ToolWindowDescriptor)evt.getSource();
            boolean visible = (Boolean)evt.getNewValue();
            Component content = visible ? toolWindowDescriptor.getComponent() : null;
            FloatingContainer container = (FloatingContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.FLOATING);
            if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                return;
            }
            container.propertyChange(evt);
            container.setVisible(visible);
        }
    }

    protected class VisibleDockedListener
    implements PropertyChangeListener {
        protected final SplitAnimation splitAnimation = new SplitAnimation();
        protected boolean vsdValueAdjusting = false;
        protected Map<ToolWindowDescriptor, Integer> poss = new HashMap<ToolWindowDescriptor, Integer>();

        public VisibleDockedListener() {
            MyDoggyToolWindowBar.this.splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    int dividerLocation = MyDoggyToolWindowBar.this.getSplitDividerLocation();
                    if (VisibleDockedListener.this.splitAnimation.isAnimating() || VisibleDockedListener.this.vsdValueAdjusting || dividerLocation <= 5) {
                        return;
                    }
                    for (ToolWindow toolWindow : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                        if (!toolWindow.isVisible()) continue;
                        MyDoggyToolWindowBar.this.manager.getDescriptor(toolWindow).setDividerLocation(dividerLocation);
                    }
                }
            });
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!MyDoggyToolWindowBar.this.manager.getContentManager().isEnabled() && MyDoggyToolWindowBar.this.manager.dockableMainContentMode) {
                this.disabledContentManagerPropertyChange(evt);
            } else {
                this.enabledContentManagerPropertyChange(evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enabledContentManagerPropertyChange(PropertyChangeEvent evt) {
            EventListener container;
            Component content;
            boolean shiftShow = false;
            AggregationPosition aggregationPosition = AggregationPosition.DEFAULT;
            ToolWindow aggregationOnTool = null;
            if (evt instanceof UserPropertyChangeEvent) {
                UserPropertyChangeEvent upce = (UserPropertyChangeEvent)evt;
                Object[] args = (Object[])upce.getUserObject();
                shiftShow = (Boolean)args[0];
                aggregationPosition = (AggregationPosition)args[1];
                aggregationOnTool = (ToolWindow)args[2];
            }
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            boolean visible = (Boolean)evt.getNewValue();
            if (descriptor.getDockedTypeDescriptor().isHideRepresentativeButtonOnVisible()) {
                if (visible) {
                    this.poss.put(descriptor, descriptor.getAnchorIndex());
                    MyDoggyToolWindowBar.this.removeRepresentativeAnchor(descriptor.getRepresentativeAnchor(), descriptor);
                } else {
                    int index = -1;
                    if (this.poss.containsKey(descriptor)) {
                        index = this.poss.get(descriptor);
                    }
                    MyDoggyToolWindowBar.this.addRepresentativeAnchor(descriptor.getRepresentativeAnchor(MyDoggyToolWindowBar.this.representativeButtonsPanel), index);
                }
            }
            if (visible) {
                descriptor.setIdOnTitleBar();
            }
            Component component = content = visible ? descriptor.getComponent() : null;
            if (content != null) {
                container = (DockedContainer)descriptor.getToolWindowContainer();
                content = container.getContentContainer();
            }
            if (content == null || descriptor.getDividerLocation() > 0 && MyDoggyToolWindowBar.this.splitPane.getDividerSize() != 0) {
                container = this.splitAnimation;
                synchronized (container) {
                    if (this.splitAnimation.isAnimating()) {
                        this.splitAnimation.stop();
                    }
                }
                if (MyDoggyToolWindowBar.this.manager.getShowingGroup() == null) {
                    descriptor.setDividerLocation(MyDoggyToolWindowBar.this.getSplitDividerLocation());
                } else {
                    int divederLocation = descriptor.getDividerLocation();
                    for (ToolWindow toolWindow : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                        if (!toolWindow.isVisible()) continue;
                        MyDoggyToolWindowBar.this.manager.getDescriptor(toolWindow).setDividerLocation(divederLocation);
                    }
                }
            }
            if (content == null && descriptor.getToolWindow().isVisible()) {
                return;
            }
            int divederLocation = Math.max(descriptor.getDividerLocation(), descriptor.getDockedTypeDescriptor().getMinimumDockLength());
            if (MyDoggyToolWindowBar.this.getSplitDividerLocation() != 0) {
                for (ToolWindow toolWindow : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                    if (descriptor.getToolWindow() == toolWindow || !toolWindow.isVisible() || toolWindow.getType() != ToolWindowType.DOCKED) continue;
                    divederLocation = MyDoggyToolWindowBar.this.getSplitDividerLocation();
                    break;
                }
            }
            Component splitPaneContent = MyDoggyToolWindowBar.this.getSplitPaneContent();
            boolean animate = true;
            if (splitPaneContent != null) {
                if (splitPaneContent instanceof MultiSplitDockableContainer) {
                    MultiSplitDockableContainer multiSplitDockableContainer = (MultiSplitDockableContainer)splitPaneContent;
                    if (content == null) {
                        multiSplitDockableContainer.removeDockable((Dockable)descriptor.getToolWindow(), !visible && !MyDoggyToolWindowBar.this.manager.isShowingGroup());
                        animate = false;
                        if (multiSplitDockableContainer.isEmpty()) {
                            animate = true;
                            content = null;
                        } else if (multiSplitDockableContainer.getContentCount() == 1) {
                            animate = false;
                            MultiSplitDockableContainer.DockableEntry dockableEntry = multiSplitDockableContainer.getContents().get(0);
                            content = multiSplitDockableContainer.getContents().get(0).getComponent();
                            multiSplitDockableContainer.removeDockable(dockableEntry.getDockable(), !visible && !MyDoggyToolWindowBar.this.manager.isShowingGroup());
                            int temp = MyDoggyToolWindowBar.this.getSplitDividerLocation();
                            this.setSplitPaneContent(content);
                            MyDoggyToolWindowBar.this.setSplitDividerLocation(temp);
                        }
                    } else if (MyDoggyToolWindowBar.this.manager.getShowingGroup() != null) {
                        multiSplitDockableContainer.addDockable((Dockable)descriptor.getToolWindow(), content, (Dockable)aggregationOnTool, -1, aggregationPosition);
                    } else {
                        this.setSplitPaneContent(content);
                    }
                } else if (MyDoggyToolWindowBar.this.manager.getShowingGroup() != null && content != null) {
                    MyDoggyToolWindowBar.this.multiSplitDockableContainer.clear();
                    if (shiftShow) {
                        MyDoggyToolWindowBar.this.multiSplitDockableContainer.addDockable((Dockable)((JComponent)splitPaneContent).getClientProperty(ToolWindow.class), splitPaneContent, null, -1, AggregationPosition.DEFAULT);
                    }
                    MyDoggyToolWindowBar.this.multiSplitDockableContainer.addDockable((Dockable)descriptor.getToolWindow(), content, null, -1, aggregationPosition);
                    this.setSplitPaneContent(MyDoggyToolWindowBar.this.multiSplitDockableContainer);
                } else if (content != null) {
                    this.setSplitPaneContent(content);
                }
            } else if (MyDoggyToolWindowBar.this.manager.getShowingGroup() != null && content != null) {
                MyDoggyToolWindowBar.this.multiSplitDockableContainer.clear();
                MyDoggyToolWindowBar.this.multiSplitDockableContainer.addDockable((Dockable)descriptor.getToolWindow(), content, null, -1, AggregationPosition.DEFAULT);
                this.setSplitPaneContent(MyDoggyToolWindowBar.this.multiSplitDockableContainer);
            } else if (content != null) {
                this.setSplitPaneContent(content);
            }
            if (animate) {
                if (content != null) {
                    MyDoggyToolWindowBar.this.splitPane.setDividerSize(MyDoggyToolWindowBar.this.getDividerSize());
                    if (MyDoggyToolWindowBar.this.manager.getShowingGroup() == null && descriptor.getTypeDescriptor(ToolWindowType.DOCKED).isAnimating()) {
                        this.splitAnimation.show(divederLocation);
                    } else if (divederLocation != 0) {
                        this.vsdValueAdjusting = true;
                        MyDoggyToolWindowBar.this.setSplitDividerLocation(divederLocation);
                        this.vsdValueAdjusting = false;
                        SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                    }
                } else {
                    MyDoggyToolWindowBar.this.splitPane.setDividerSize(0);
                    this.setSplitPaneContent(null);
                    this.vsdValueAdjusting = true;
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(0);
                    SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                    this.vsdValueAdjusting = false;
                }
            } else {
                MyDoggyToolWindowBar.this.setSplitDividerLocation(divederLocation);
                SwingUtil.repaint(MyDoggyToolWindowBar.this.splitPane);
            }
        }

        public void disabledContentManagerPropertyChange(PropertyChangeEvent evt) {
            MultiSplitDockableContainer managerDockableContainer = (MultiSplitDockableContainer)((ContentPanel)MyDoggyToolWindowBar.this.manager.getMainContent()).getComponent();
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            boolean visible = (Boolean)evt.getNewValue();
            if (visible) {
                AggregationPosition aggregationPosition;
                ToolWindow aggregationOnTool = null;
                if (evt instanceof UserPropertyChangeEvent) {
                    UserPropertyChangeEvent upce = (UserPropertyChangeEvent)evt;
                    Object[] args = (Object[])upce.getUserObject();
                    aggregationPosition = (AggregationPosition)args[1];
                    aggregationOnTool = (ToolWindow)args[2];
                } else {
                    aggregationPosition = AggregationPosition.valueOf((String)MyDoggyToolWindowBar.this.anchor.toString());
                }
                DockedContainer container = (DockedContainer)descriptor.getToolWindowContainer();
                managerDockableContainer.addDockable((Dockable)descriptor.getToolWindow(), container.getContentContainer(), (Dockable)aggregationOnTool, -1, aggregationPosition);
            } else {
                managerDockableContainer.removeDockable((Dockable)descriptor.getToolWindow());
            }
            SwingUtil.repaint(managerDockableContainer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setSplitPaneContent(Component content) {
            this.vsdValueAdjusting = true;
            try {
                if (content != null && MyDoggyToolWindowBar.this.splitPane.getDividerLocation() == 0) {
                    MyDoggyToolWindowBar.this.splitPane.setDividerLocation(1);
                }
                Component splitPaneContent = content;
                if (content != null) {
                    MyDoggyToolWindowBar.this.contentPanel.setComponent(content);
                    splitPaneContent = MyDoggyToolWindowBar.this.contentPanel;
                } else {
                    MyDoggyToolWindowBar.this.contentPanel.resetComponent();
                }
                switch (MyDoggyToolWindowBar.this.anchor) {
                    case LEFT: {
                        MyDoggyToolWindowBar.this.splitPane.setLeftComponent(splitPaneContent);
                        break;
                    }
                    case RIGHT: {
                        MyDoggyToolWindowBar.this.splitPane.setRightComponent(splitPaneContent);
                        if (splitPaneContent == null) break;
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(MyDoggyToolWindowBar.this.splitPane.getWidth());
                        break;
                    }
                    case BOTTOM: {
                        MyDoggyToolWindowBar.this.splitPane.setBottomComponent(splitPaneContent);
                        if (splitPaneContent == null) break;
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(MyDoggyToolWindowBar.this.splitPane.getHeight());
                        break;
                    }
                    case TOP: {
                        MyDoggyToolWindowBar.this.splitPane.setTopComponent(splitPaneContent);
                    }
                }
                if (splitPaneContent != null) {
                    content.setVisible(true);
                }
            }
            finally {
                this.vsdValueAdjusting = false;
            }
        }

        protected class SplitAnimation
        extends AbstractAnimation {
            protected int dividerLocation;
            protected int sheetLen;

            public SplitAnimation() {
                super(60.0f);
            }

            protected float onAnimating(float animationPercent) {
                AbstractAnimation.Direction direction = this.getAnimationDirection();
                int animatingHeight = direction == AbstractAnimation.Direction.INCOMING ? (int)(animationPercent * (float)this.sheetLen) : (int)((1.0f - animationPercent) * (float)this.sheetLen);
                switch (MyDoggyToolWindowBar.this.anchor) {
                    case LEFT: 
                    case TOP: {
                        if (direction == AbstractAnimation.Direction.INCOMING) {
                            if (MyDoggyToolWindowBar.this.splitPane.getDividerLocation() > animatingHeight) break;
                            MyDoggyToolWindowBar.this.splitPane.setDividerLocation(animatingHeight);
                            break;
                        }
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(animatingHeight);
                        break;
                    }
                    case RIGHT: {
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(MyDoggyToolWindowBar.this.splitPane.getWidth() - animatingHeight);
                        break;
                    }
                    case BOTTOM: {
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(MyDoggyToolWindowBar.this.splitPane.getHeight() - animatingHeight);
                    }
                }
                return animationPercent;
            }

            protected void onFinishAnimation() {
                if (MyDoggyToolWindowBar.this.splitPane.getDividerSize() == 0) {
                    VisibleDockedListener.this.setSplitPaneContent(null);
                } else if (this.getAnimationDirection() == AbstractAnimation.Direction.OUTGOING) {
                    VisibleDockedListener.this.vsdValueAdjusting = true;
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(0);
                    VisibleDockedListener.this.vsdValueAdjusting = false;
                } else {
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(this.sheetLen);
                    SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                }
            }

            protected void onHide(Object ... params) {
                this.dividerLocation = (Integer)params[0];
            }

            protected void onShow(Object ... params) {
                this.dividerLocation = (Integer)params[0];
            }

            protected void onStartAnimation(AbstractAnimation.Direction direction) {
                this.sheetLen = this.dividerLocation;
            }

            protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
                return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
            }
        }
    }

    protected class VisibleListener
    implements PropertyChangeListener {
        protected VisibleListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindow sourceTool = ((ToolWindowDescriptor)evt.getSource()).getToolWindow();
            boolean oldValue = (Boolean)evt.getOldValue();
            boolean newValue = (Boolean)evt.getNewValue();
            if (evt instanceof UserPropertyChangeEvent) {
                MyDoggyToolWindowBar.this.propertyChange(new UserPropertyChangeEvent(evt.getSource(), "visible." + sourceTool.getType().toString(), null, !oldValue && newValue, ((UserPropertyChangeEvent)evt).getUserObject()));
            } else {
                MyDoggyToolWindowBar.this.propertyChange(new PropertyChangeEvent(evt.getSource(), "visible." + sourceTool.getType().toString(), null, !oldValue && newValue));
            }
        }
    }

    protected class VisibleBeforeListener
    implements PropertyChangeListener {
        protected VisibleBeforeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindow sourceTool = ((ToolWindowDescriptor)evt.getSource()).getToolWindow();
            if (sourceTool.getType() == ToolWindowType.FLOATING || sourceTool.getType() == ToolWindowType.FLOATING_FREE) {
                return;
            }
            boolean oldValue = (Boolean)evt.getOldValue();
            boolean newValue = (Boolean)evt.getNewValue();
            if (!oldValue && newValue) {
                ToolWindow[] toolWindows;
                for (ToolWindow toolWindow : toolWindows = MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.getAnchor())) {
                    if (toolWindow == sourceTool) continue;
                    if (MyDoggyToolWindowBar.this.manager.getShowingGroup() == null) {
                        if (toolWindow.getType() == ToolWindowType.FLOATING || toolWindow.getType() == ToolWindowType.FLOATING_FREE || toolWindow.getType() == ToolWindowType.FLOATING_LIVE || toolWindow.getType() == ToolWindowType.EXTERN) continue;
                        if (toolWindow.getAnchor().equals((Object)sourceTool.getAnchor())) {
                            toolWindow.setVisible(false);
                        } else if (toolWindow.isAutoHide() || toolWindow.getType() == ToolWindowType.SLIDING) {
                            toolWindow.setVisible(false);
                        }
                    } else if (toolWindow.getType() == ToolWindowType.SLIDING) {
                        toolWindow.setVisible(false);
                    }
                    if (!toolWindow.isVisible() || !toolWindow.isMaximized()) continue;
                    toolWindow.setMaximized(false);
                }
            }
        }
    }

    protected class TypeListener
    extends AvailableListener {
        protected TypeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = (ToolWindowDescriptor)evt.getSource();
            if (evt.getOldValue() == ToolWindowType.FLOATING_FREE) {
                MyDoggyToolWindowBar.this.addRepresentativeAnchor(toolWindowDescriptor.getRepresentativeAnchor(MyDoggyToolWindowBar.this.representativeButtonsPanel), -1);
                MyDoggyToolWindowBar.this.ensureVisible(toolWindowDescriptor.getRepresentativeAnchor());
                SwingUtil.repaint(MyDoggyToolWindowBar.this.representativeButtonsPanel);
            } else if ((evt.getNewValue() == ToolWindowType.FLOATING_FREE || evt.getNewValue() == ToolWindowType.EXTERN) && toolWindowDescriptor.getRepresentativeAnchor() != null) {
                MyDoggyToolWindowBar.this.removeRepresentativeAnchor(toolWindowDescriptor.getRepresentativeAnchor(), toolWindowDescriptor);
                SwingUtil.repaint(MyDoggyToolWindowBar.this.representativeButtonsPanel);
            }
        }
    }

    protected static class ActiveListener
    implements PropertyChangeListener {
        protected ActiveListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = (ToolWindowDescriptor)evt.getSource();
            toolWindowDescriptor.getToolWindowContainer().propertyChange(evt);
        }
    }

    protected class ActiveBeforeListener
    implements PropertyChangeListener {
        protected ActiveBeforeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindow sourceTool = ((ToolWindowDescriptor)evt.getSource()).getToolWindow();
            boolean newValue = (Boolean)evt.getNewValue();
            if (newValue) {
                ToolWindow[] toolWindows;
                for (ToolWindow toolWindow : toolWindows = MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.getAnchor())) {
                    if (toolWindow == sourceTool) continue;
                    MyDoggyToolWindowBar.this.deactiveTool(toolWindow);
                }
            }
        }
    }

    protected class ShowUnavailableToolsListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() == Boolean.TRUE) {
                for (ToolWindow tool : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                    if (tool.isAvailable() || tool.getType() == ToolWindowType.FLOATING_FREE) continue;
                    MyDoggyToolWindowBar.this.addRepresentativeAnchor(MyDoggyToolWindowBar.this.manager.getDescriptor(tool).getRepresentativeAnchor(MyDoggyToolWindowBar.this.representativeButtonsPanel), -1);
                }
            } else {
                for (ToolWindow tool : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                    if (tool.isAvailable() || tool.getType() == ToolWindowType.FLOATING_FREE) continue;
                    ToolWindowDescriptor descriptor = MyDoggyToolWindowBar.this.manager.getDescriptor(tool);
                    MyDoggyToolWindowBar.this.removeRepresentativeAnchor(descriptor.getRepresentativeAnchor(MyDoggyToolWindowBar.this.representativeButtonsPanel), descriptor);
                }
            }
        }
    }

    protected class AvailableListener
    implements PropertyChangeListener {
        protected Map<DockableDescriptor, Integer> rabsPositions = new Hashtable<DockableDescriptor, Integer>();

        public void propertyChange(PropertyChangeEvent evt) {
            DockableDescriptor descriptor = (DockableDescriptor)evt.getSource();
            if (this.isDockableDescriptorValid(descriptor)) {
                boolean rabsEvent = evt.getPropertyName().equals("representativeAnchorButtonVisible");
                if (!rabsEvent && descriptor.getDockableType() == DockableDescriptor.DockableType.TOOL_WINDOW && !((ToolWindow)descriptor.getDockable()).isRepresentativeAnchorButtonVisible()) {
                    return;
                }
                boolean oldAvailable = (Boolean)evt.getOldValue();
                boolean newAvailable = (Boolean)evt.getNewValue();
                boolean repaint = false;
                if (oldAvailable && !newAvailable) {
                    JComponent representativeAnchor;
                    boolean flag = false;
                    if (!rabsEvent) {
                        assert (evt instanceof UserPropertyChangeEvent);
                        Object[] params = (Object[])((UserPropertyChangeEvent)evt).getUserObject();
                        boolean bl = flag = MyDoggyToolWindowBar.this.manager.getToolWindowManagerDescriptor().isShowUnavailableTools() && descriptor.getAnchorIndex() != -1;
                        if (params[1] == Boolean.TRUE) {
                            flag = false;
                        }
                    }
                    if ((representativeAnchor = descriptor.getRepresentativeAnchor()) != null) {
                        if (!flag) {
                            if (rabsEvent) {
                                this.rabsPositions.put(descriptor, descriptor.getAnchorIndex());
                            }
                            MyDoggyToolWindowBar.this.removeRepresentativeAnchor(representativeAnchor, descriptor);
                        } else {
                            descriptor.updateRepresentativeAnchor();
                        }
                        repaint = true;
                    }
                } else if (!oldAvailable && newAvailable) {
                    Object[] params = null;
                    boolean flag = false;
                    if (!rabsEvent) {
                        assert (evt instanceof UserPropertyChangeEvent);
                        params = (Object[])((UserPropertyChangeEvent)evt).getUserObject();
                        boolean bl = flag = MyDoggyToolWindowBar.this.manager.getToolWindowManagerDescriptor().isShowUnavailableTools() && descriptor.getAnchorIndex() != -1;
                        if (params[1] == Boolean.TRUE) {
                            flag = false;
                        }
                    }
                    JComponent representativeAnchor = descriptor.getRepresentativeAnchor(MyDoggyToolWindowBar.this.representativeButtonsPanel);
                    if (!flag) {
                        if (rabsEvent) {
                            int index = -1;
                            if (rabsEvent && this.rabsPositions.containsKey(descriptor)) {
                                index = this.rabsPositions.get(descriptor);
                            }
                            MyDoggyToolWindowBar.this.addRepresentativeAnchor(representativeAnchor, index);
                        } else {
                            MyDoggyToolWindowBar.this.addRepresentativeAnchor(representativeAnchor, (Integer)params[0]);
                        }
                    } else {
                        descriptor.updateRepresentativeAnchor();
                    }
                    repaint = true;
                }
                if (repaint) {
                    SwingUtil.repaint(MyDoggyToolWindowBar.this.representativeButtonsPanel);
                }
            }
        }

        protected boolean isDockableDescriptorValid(DockableDescriptor dockableDescriptor) {
            if (dockableDescriptor.getDockableType() == DockableDescriptor.DockableType.TOOL_WINDOW) {
                ToolWindow tool = (ToolWindow)dockableDescriptor.getDockable();
                return tool.getType() != ToolWindowType.FLOATING_FREE && tool.getType() != ToolWindowType.EXTERN;
            }
            return true;
        }
    }
}

