/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.descriptors;

import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.descriptors.InternalTypeDescriptor;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;

public class DefaultFloatingTypeDescriptor
extends PropertyChangeEventSource
implements FloatingTypeDescriptor,
PropertyChangeListener,
InternalTypeDescriptor {
    private Point location;
    private Dimension size;
    private boolean modal;
    private boolean transparentMode;
    private float transparentRatio;
    private int transparentDelay;
    private boolean enabled;
    private boolean animating;
    private boolean autoHide;
    private boolean idVisibleOnTitleBar;
    private boolean addToTaskBar;

    public DefaultFloatingTypeDescriptor() {
        this.transparentMode = true;
        this.transparentRatio = 0.7f;
        this.transparentDelay = 1500;
        this.modal = false;
        this.enabled = true;
        this.animating = true;
        this.autoHide = false;
        this.idVisibleOnTitleBar = true;
        this.addToTaskBar = false;
    }

    public DefaultFloatingTypeDescriptor(ToolWindowDescriptor toolWindowDescriptor, DefaultFloatingTypeDescriptor parent, Point location, Dimension size, int transparentDelay, float transparentRatio, boolean useTransparentMode, boolean modal, boolean enabled, boolean animating, boolean autoHide, boolean idVisibleOnTitleBar, boolean addToTaskBar) {
        this.location = location;
        this.size = size;
        this.transparentDelay = transparentDelay;
        this.transparentRatio = transparentRatio;
        this.transparentMode = useTransparentMode;
        this.modal = modal;
        this.enabled = enabled;
        this.animating = animating;
        this.autoHide = autoHide;
        this.idVisibleOnTitleBar = idVisibleOnTitleBar;
        this.addToTaskBar = addToTaskBar;
        parent.addPropertyChangeListener(this);
        toolWindowDescriptor.getCleaner().addCleaner(this);
    }

    public void setLocation(int x, int y) {
        Point newLocation = new Point(x, y);
        if (this.location != null && this.location.equals(newLocation)) {
            return;
        }
        Point old = this.location;
        this.location = newLocation;
        this.firePropertyChangeEvent("location", old, this.location);
    }

    public void setSize(int width, int height) {
        Dimension newSize = new Dimension(width, height);
        if (this.size != null && this.size.equals(newSize)) {
            return;
        }
        Dimension old = this.size;
        this.size = newSize;
        this.firePropertyChangeEvent("size", old, this.size);
    }

    public Point getLocation() {
        return this.location;
    }

    public Dimension getSize() {
        return this.size;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        if (this.modal == modal) {
            return;
        }
        boolean old = this.modal;
        this.modal = modal;
        this.firePropertyChangeEvent("modal", old, modal);
    }

    public float getTransparentRatio() {
        return this.transparentRatio;
    }

    public void setTransparentRatio(float transparentRatio) {
        if (this.transparentRatio == transparentRatio) {
            return;
        }
        if (transparentRatio < 0.0f || transparentRatio > 1.0f) {
            throw new IllegalArgumentException("Invalid transparent ratio. Valid range is [0.0f, 1.0f]. [transparentRatio : " + transparentRatio + "]");
        }
        float old = this.transparentRatio;
        this.transparentRatio = transparentRatio;
        this.firePropertyChangeEvent("transparentRatio", Float.valueOf(old), Float.valueOf(transparentRatio));
    }

    public boolean isTransparentMode() {
        return this.transparentMode;
    }

    public void setTransparentMode(boolean transparentMode) {
        if (this.transparentMode == transparentMode) {
            return;
        }
        boolean old = this.transparentMode;
        this.transparentMode = transparentMode;
        this.firePropertyChangeEvent("transparentMode", old, transparentMode);
    }

    public int getTransparentDelay() {
        return this.transparentDelay;
    }

    public void setAddToTaskBar(boolean addToTaskBar) {
        if (this.addToTaskBar == addToTaskBar) {
            return;
        }
        boolean old = this.addToTaskBar;
        this.addToTaskBar = addToTaskBar;
        this.firePropertyChangeEvent("addToTaskBar", old, addToTaskBar);
    }

    public boolean isAddToTaskBar() {
        return this.addToTaskBar;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        boolean old = this.enabled;
        this.enabled = enabled;
        this.firePropertyChangeEvent("enabled", old, enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setTransparentDelay(int transparentDelay) {
        if (this.transparentDelay == transparentDelay) {
            return;
        }
        int old = this.transparentDelay;
        this.transparentDelay = transparentDelay;
        this.firePropertyChangeEvent("transparentDelay", old, transparentDelay);
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void setAnimating(boolean animating) {
        if (this.animating == animating) {
            return;
        }
        boolean old = this.animating;
        this.animating = animating;
        this.firePropertyChangeEvent("animating", old, animating);
    }

    public void setIdVisibleOnTitleBar(boolean idVisibleOnTitleBar) {
        if (this.idVisibleOnTitleBar == idVisibleOnTitleBar) {
            return;
        }
        boolean old = this.idVisibleOnTitleBar;
        this.idVisibleOnTitleBar = idVisibleOnTitleBar;
        this.firePropertyChangeEvent("idVisibleOnTitleBar", old, idVisibleOnTitleBar);
    }

    public boolean isIdVisibleOnTitleBar() {
        return this.idVisibleOnTitleBar;
    }

    public void setAutoHide(boolean autoHide) {
        boolean old = this.autoHide;
        this.autoHide = autoHide;
        this.firePropertyChangeEvent("autoHide", old, autoHide);
    }

    public boolean isAutoHide() {
        return this.autoHide;
    }

    public ToolWindowTypeDescriptor cloneMe(ToolWindowDescriptor toolWindowDescriptor) {
        return new DefaultFloatingTypeDescriptor(toolWindowDescriptor, this, this.location, this.size, this.transparentDelay, this.transparentRatio, this.transparentMode, this.modal, this.enabled, this.animating, this.autoHide, this.idVisibleOnTitleBar, this.addToTaskBar);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("location".equals(evt.getPropertyName())) {
            Point p = (Point)evt.getNewValue();
            this.setLocation(p.x, p.y);
        } else if ("size".equals(evt.getPropertyName())) {
            Dimension d = (Dimension)evt.getNewValue();
            this.setSize(d.width, d.height);
        } else if ("modal".equals(evt.getPropertyName())) {
            this.setModal((Boolean)evt.getNewValue());
        } else if ("transparentMode".equals(evt.getPropertyName())) {
            this.setTransparentMode((Boolean)evt.getNewValue());
        } else if ("transparentRatio".equals(evt.getPropertyName())) {
            this.setTransparentRatio(((Float)evt.getNewValue()).floatValue());
        } else if ("transparentDelay".equals(evt.getPropertyName())) {
            this.setTransparentDelay((Integer)evt.getNewValue());
        } else if ("enabled".equals(evt.getPropertyName())) {
            this.setEnabled((Boolean)evt.getNewValue());
        } else if ("autoHide".equals(evt.getPropertyName())) {
            this.setAutoHide((Boolean)evt.getNewValue());
        } else if ("animating".equals(evt.getPropertyName())) {
            this.setAnimating((Boolean)evt.getNewValue());
        } else if ("idVisibleOnTitleBar".equals(evt.getPropertyName())) {
            this.setIdVisibleOnTitleBar((Boolean)evt.getNewValue());
        } else if ("addToTaskBar".equals(evt.getPropertyName())) {
            this.setAddToTaskBar((Boolean)evt.getNewValue());
        }
    }
}

