/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowBar;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.cleaner.CleanerAggregator;
import org.noos.xing.mydoggy.plaf.cleaner.DefaultCleanerAggregator;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGesture;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.drag.RepresentativeAnchorDragGesture;

public abstract class CustomDockableDescriptor
implements DockableDescriptor {
    protected MyDoggyToolWindowManager manager;
    protected String id;
    protected boolean available;
    protected ToolWindowAnchor anchor;
    protected JComponent representativeAnchor;
    protected int anchorIndex;
    protected DragGesture dragGesture;
    protected CleanerAggregator cleaner;

    public CustomDockableDescriptor(MyDoggyToolWindowManager manager) {
        this(manager, ToolWindowAnchor.LEFT);
    }

    public CustomDockableDescriptor(MyDoggyToolWindowManager manager, ToolWindowAnchor anchor) {
        this.manager = manager;
        this.anchor = anchor;
        this.anchorIndex = -1;
        this.id = "CustomDockableDescriptor" + System.identityHashCode(this);
        this.manager.putDockableDescriptor(this.id, this);
        this.available = false;
    }

    public CustomDockableDescriptor(MyDoggyToolWindowManager manager, ToolWindowAnchor anchor, String id) {
        this.manager = manager;
        this.anchor = anchor;
        this.anchorIndex = -1;
        this.id = id;
        this.manager.putDockableDescriptor(id, this);
        this.available = false;
    }

    public DockableDescriptor.DockableType getDockableType() {
        return DockableDescriptor.DockableType.CUSTOM;
    }

    public Dockable getDockable() {
        return null;
    }

    public void setAnchor(ToolWindowAnchor anchor, int index) {
        if (!this.isAvailable()) {
            return;
        }
        this.setAvailable(false);
        this.anchor = anchor;
        this.anchorIndex = index;
        this.setAvailable(true);
    }

    public ToolWindowAnchor getAnchor() {
        return this.anchor;
    }

    public int getAnchorIndex() {
        if (this.representativeAnchor == null) {
            return this.anchorIndex;
        }
        return this.getToolBar().getRepresentativeAnchorIndex(this.representativeAnchor);
    }

    public void setAvailable(boolean available) {
        if (this.available == available) {
            return;
        }
        if (available) {
            this.manager.propertyChange(new UserPropertyChangeEvent(this, "available", false, true, new Object[]{this.anchorIndex, false}));
        } else {
            this.manager.propertyChange(new UserPropertyChangeEvent(this, "available", true, false, new Object[]{-1, false}));
        }
        this.available = available;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public JComponent getRepresentativeAnchor() {
        return this.representativeAnchor;
    }

    public void resetRepresentativeAnchor() {
        this.representativeAnchor = null;
    }

    public ResourceManager getResourceManager() {
        return this.manager.getResourceManager();
    }

    public MyDoggyToolWindowManager getManager() {
        return this.manager;
    }

    public MyDoggyToolWindowBar getToolBar() {
        return this.manager.getBar(this.getAnchor());
    }

    public MyDoggyToolWindowBar getToolBar(ToolWindowAnchor anchor) {
        return this.manager.getBar(anchor);
    }

    public CleanerAggregator getCleaner() {
        if (this.cleaner == null) {
            this.cleaner = new DefaultCleanerAggregator();
        }
        return this.cleaner;
    }

    public boolean isDragImageAvailable() {
        return false;
    }

    public Component getComponentForDragImage() {
        return null;
    }

    public void cleanup() {
        this.getCleaner().cleanup();
        this.manager = null;
    }

    protected void registerDragGesture(Component c) {
        if (this.dragGesture == null) {
            this.initDragGesture();
        }
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(c, 2, this.dragGesture);
        dragSource.addDragSourceMotionListener(this.dragGesture);
    }

    protected void initDragGesture() {
        this.dragGesture = new CustomRepresentativeAnchorDragGesture(this);
    }

    protected class CustomRepresentativeAnchorDragGesture
    extends RepresentativeAnchorDragGesture {
        public CustomRepresentativeAnchorDragGesture(DockableDescriptor descriptor) {
            super(descriptor, null);
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.releaseLocksOne();
            this.manager.setTempShowed(false);
            if (this.lastAnchor != null) {
                this.descriptor.getToolBar(this.lastAnchor).propertyChange(new PropertyChangeEvent(CustomDockableDescriptor.this.representativeAnchor, "endDrag", null, dsde));
            } else {
                this.descriptor.getToolBar().propertyChange(new PropertyChangeEvent(CustomDockableDescriptor.this.representativeAnchor, "endDrag", null, dsde));
            }
            this.cleanupGhostImage();
            this.lastAnchor = null;
            this.releaseLocksTwo();
        }

        public Component getComponent() {
            return CustomDockableDescriptor.this.representativeAnchor;
        }

        protected Transferable createTransferable() {
            return new MyDoggyTransferable(this.manager, MyDoggyTransferable.CUSTOM_DESCRIPTOR_ID, CustomDockableDescriptor.this.id);
        }
    }
}

