/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.animation.MoveComponentAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.ToFrontWindowFocusListener;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.WindowTransparencyListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class AnimatedContentDialog
extends JDialog {
    protected Content content;
    protected ContentUI contentUI;

    public AnimatedContentDialog(ResourceManager resourceManager, Content content, ContentUI contentUI, Frame parentFrame, Rectangle bounds) throws HeadlessException {
        super(resourceManager.getBoolean("dialog.owner.enabled", true) ? parentFrame : null, false);
        this.content = content;
        this.contentUI = contentUI;
        Component component = content.getComponent();
        component.setPreferredSize(component.getSize());
        this.setTitle(content.getTitle());
        this.getContentPane().setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}}));
        this.getContentPane().add(component, "0,0,FULL,FULL");
        this.setBounds(bounds);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new ContentDialogWindowAdapter());
        if (parentFrame == null) {
            this.addWindowFocusListener(new ToFrontWindowFocusListener(this));
        }
        this.addComponentListener(new ContentDialogComponentAdapter());
        if (resourceManager.getTransparencyManager().isServiceAvailable()) {
            WindowTransparencyListener windowTransparencyListener = new WindowTransparencyListener(resourceManager.getTransparencyManager(), contentUI, this);
            this.addWindowListener(windowTransparencyListener);
            this.addWindowFocusListener(windowTransparencyListener);
        }
    }

    public void setVisible(boolean b) {
        Rectangle detachedBounds;
        super.setVisible(b);
        if (b && (detachedBounds = SwingUtil.validateBounds(this.contentUI.getDetachedBounds())) != null) {
            MoveComponentAnimation animation = new MoveComponentAnimation(200.0f, this);
            animation.show(detachedBounds);
            this.setBounds(detachedBounds);
        }
    }

    protected class ContentDialogComponentAdapter
    extends ComponentAdapter {
        protected ContentDialogComponentAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            AnimatedContentDialog.this.contentUI.setDetachedBounds(AnimatedContentDialog.this.getBounds());
        }

        public void componentMoved(ComponentEvent e) {
            AnimatedContentDialog.this.contentUI.setDetachedBounds(AnimatedContentDialog.this.getBounds());
        }
    }

    protected class ContentDialogWindowAdapter
    extends WindowAdapter {
        protected ContentDialogWindowAdapter() {
        }

        public void windowClosing(WindowEvent event) {
            AnimatedContentDialog.this.content.setDetached(false);
        }
    }
}

