/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockableManagerListener;
import org.noos.xing.mydoggy.event.DockableManagerEvent;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;

public class DockablePanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
DockableManagerListener {
    protected static Border flashingBorder = new LineBorder(Color.RED, 3);
    protected Dockable dockable;
    protected boolean flashingEnabled;
    protected Timer flashingTimer;
    protected int flashingDuration = -1;
    protected boolean flashingState;
    protected long startingTime = 0L;

    public DockablePanel(Dockable dockable, Component component) {
        this.dockable = dockable;
        this.flashingEnabled = dockable instanceof Content;
        this.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{-1.0}, {-1.0}})));
        this.setFocusCycleRoot(true);
        this.setFocusable(false);
        this.add(component, "0,0,FULL,FULL");
        dockable.addPropertyChangeListener((PropertyChangeListener)this);
        dockable.getDockableManager().addDockableManagerListener((DockableManagerListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("flash".equals(propertyName)) {
            if (!this.flashingEnabled) {
                return;
            }
            if (evt.getNewValue() == Boolean.TRUE) {
                if (!this.dockable.isSelected()) {
                    this.putClientProperty("oldBorder", this.getBorder());
                    this.flashingDuration = -1;
                    this.flashingTimer = new Timer(600, this);
                    this.flashingTimer.start();
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                this.setBorder((Border)this.getClientProperty("oldBorder"));
            }
        } else if ("flash.duration".equals(propertyName)) {
            if (!this.flashingEnabled) {
                return;
            }
            if (evt.getNewValue() == Boolean.TRUE) {
                if (!this.dockable.isSelected()) {
                    this.putClientProperty("oldBorder", this.getBorder());
                    this.flashingDuration = (Integer)evt.getNewValue();
                    this.flashingTimer = new Timer(600, this);
                    this.flashingTimer.start();
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                this.setBorder((Border)this.getClientProperty("oldBorder"));
            }
        } else if ("selected".equals(propertyName) && evt.getNewValue() == Boolean.TRUE) {
            this.dockable.setFlashing(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.startingTime == 0L) {
            this.startingTime = System.currentTimeMillis();
        }
        boolean bl = this.flashingState = !this.flashingState;
        if (this.flashingState) {
            this.setBorder(flashingBorder);
        } else {
            this.setBorder((Border)this.getClientProperty("oldBorder"));
        }
        if (this.flashingDuration != -1 && System.currentTimeMillis() - this.startingTime > (long)this.flashingDuration) {
            this.dockable.setFlashing(false);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.dockable.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void dockableAdded(DockableManagerEvent event) {
    }

    public void dockableRemoved(DockableManagerEvent event) {
        if (event.getDockable() == this.dockable) {
            this.dockable.getDockableManager().removeDockableManagerListener((DockableManagerListener)this);
            this.dockable.removePropertyChangeListener((PropertyChangeListener)this);
            this.dockable = null;
            if (this.flashingTimer != null) {
                this.flashingTimer.stop();
            }
            this.flashingTimer = null;
        }
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public Component getComponent() {
        return this.getComponent(0);
    }

    public void setComponent(Component component) {
        this.removeAll();
        this.add(component, "0,0,FULL,FULL");
    }
}

