/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.TabbedPaneUI;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.AggregateIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.TextIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneEvent;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class JTabbedContentPane
extends JTabbedPane
implements PropertyChangeListener {
    protected MyDoggyToolWindowManager toolWindowManager;
    protected ResourceManager resourceManager;
    protected boolean dragEnabled;
    protected Map<Integer, Content> contentMap;
    protected Map<Content, Object> flashingContents;
    protected Icon selectedTabIcon;
    protected TextIcon titleIcon;
    protected AggregateIcon tabIconTitle;
    protected AggregateIcon minCloseDetachIcon;
    protected AggregateIcon closeDetachIcon;
    protected Icon closeIcon;
    protected Icon detachIcon;
    protected Icon minimizeIcon;
    protected ByteArrayOutputStream tmpWorkspace = null;
    protected MouseInputAdapter mouseInputAdapter;
    protected boolean hasGhost = true;
    protected static final int LINEWIDTH = 3;
    protected static final String NAME = "test";
    protected Rectangle2D lineRect = new Rectangle2D.Double();
    protected Color lineColor = new Color(0, 100, 255);
    protected DragSource dragSource = new DragSource();
    protected DropTarget dropTarget;
    protected int dragTabIndex = -1;

    public JTabbedContentPane() {
        this(false);
    }

    public JTabbedContentPane(boolean dragEnabled) {
        super.setTabLayoutPolicy(1);
        this.contentMap = new Hashtable<Integer, Content>();
        this.titleIcon = new TextIcon(this, "", 1);
        this.tabIconTitle = new AggregateIcon(null, this.titleIcon, 0);
        this.closeDetachIcon = new AggregateIcon(this.detachIcon, this.closeIcon, 0);
        this.minCloseDetachIcon = new AggregateIcon(this.minimizeIcon, this.closeDetachIcon, 0);
        this.selectedTabIcon = new ExAggregateIcon(this.tabIconTitle, this.minCloseDetachIcon, 0);
        this.flashingContents = new HashMap<Content, Object>();
        this.dragEnabled = dragEnabled;
        this.setFocusable(false);
        this.setInheritsPopupMenu(false);
        this.mouseInputAdapter = new MouseOverTabListener();
        this.addMouseListener(this.mouseInputAdapter);
        this.addMouseMotionListener(this.mouseInputAdapter);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dragTabIndex >= 0) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.lineColor);
            g2.fill(this.lineRect);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("flash".equals(evt.getPropertyName())) {
            if (evt.getNewValue() == Boolean.TRUE) {
                this.flashingContents.put((Content)evt.getSource(), null);
                SwingUtil.repaint(this);
            } else {
                this.flashingContents.remove((Content)evt.getSource());
                SwingUtil.repaint(this);
            }
        } else if ("selected".equals(evt.getPropertyName())) {
            this.flashingContents.remove((Content)evt.getSource());
            SwingUtil.repaint(this);
        }
    }

    public String getTitleAt(int index) {
        if (this.getSelectedIndex() == index) {
            return "";
        }
        return super.getTitleAt(index);
    }

    public Icon getIconAt(int index) {
        if (this.getSelectedIndex() == index) {
            Content content = this.contentMap.get(index);
            if (content == null) {
                return super.getIconAt(index);
            }
            ContentUI contentUI = content.getContentUI();
            if (contentUI == null) {
                return super.getIconAt(index);
            }
            this.titleIcon.setText(super.getTitleAt(index));
            this.titleIcon.setUnderlinedIndex(SwingUtil.findDisplayedMnemonicIndex(super.getTitleAt(index), this.getContentAt(index).getMnemonic()));
            this.tabIconTitle.setLeftIcon(super.getIconAt(index));
            this.minCloseDetachIcon.setLeftVisible(contentUI.isMinimizable());
            this.closeDetachIcon.setLeftVisible(contentUI.isDetachable());
            this.closeDetachIcon.setRightVisible(contentUI.isCloseable());
            ((ExAggregateIcon)this.selectedTabIcon).setIndex(index);
            return this.selectedTabIcon;
        }
        if (this.flashingContents.containsKey(this.getContentAt(index))) {
            Content content = this.getContentAt(index);
            Object o = this.flashingContents.get(content);
            if (o == null) {
                TextIcon textIcon = new TextIcon(this, super.getTitleAt(index), 1);
                textIcon.setUnderlinedIndex(SwingUtil.findDisplayedMnemonicIndex(super.getTitleAt(index), this.getContentAt(index).getMnemonic()));
                AggregateIcon icon = new AggregateIcon(new AggregateIcon(super.getIconAt(index), textIcon, 0), this.resourceManager.getIcon("AUTO_HIDE_ON"), 0);
                this.flashingContents.put(content, icon);
                return icon;
            }
            return (Icon)o;
        }
        return super.getIconAt(index);
    }

    public void removeTabAt(int index) {
        Content content = this.getContentAt(index);
        if (content == null) {
            throw new IllegalArgumentException("Invalid index location.");
        }
        content.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeTabAt(index);
        this.contentMap.remove(index);
        Object[] keys = this.contentMap.keySet().toArray(new Integer[this.contentMap.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            if ((Integer)key <= index) continue;
            this.contentMap.put((Integer)key - 1, this.contentMap.remove(key));
        }
    }

    public void setUI(TabbedPaneUI ui) {
        super.setUI(ui);
        this.setFocusable(false);
        this.setInheritsPopupMenu(false);
        this.removeMouseListener(this.mouseInputAdapter);
        this.removeMouseMotionListener(this.mouseInputAdapter);
        this.addMouseListener(this.mouseInputAdapter);
        this.addMouseMotionListener(this.mouseInputAdapter);
    }

    public void setToolWindowManager(MyDoggyToolWindowManager toolWindowManager) {
        this.toolWindowManager = toolWindowManager;
        this.resourceManager = toolWindowManager.getResourceManager();
        this.minimizeIcon = this.resourceManager.getIcon("CONTENT_PAGE_MINIMIZE");
        this.detachIcon = this.resourceManager.getIcon("CONTENT_PAGE_DETACH");
        this.closeIcon = this.resourceManager.getIcon("CONTENT_PAGE_CLOSE");
        this.minCloseDetachIcon.setLeftIcon(this.minimizeIcon);
        this.closeDetachIcon.setLeftIcon(this.detachIcon);
        this.closeDetachIcon.setRightIcon(this.closeIcon);
        if (this.dragEnabled) {
            this.initDragListener();
        }
    }

    public void addTab(Content content) {
        String tip = content.getToolTipText();
        this.addTab(content.getTitle(), content.getIcon(), content.getComponent(), tip);
        int index = this.getTabCount() - 1;
        this.setForegroundAt(index, content.getForeground());
        this.setDisabledIconAt(index, content.getDisabledIcon());
        this.setMnemonicAt(index, content.getMnemonic());
        content.addPropertyChangeListener((PropertyChangeListener)this);
        this.contentMap.put(index, content);
    }

    public void addTab(Content content, Component component) {
        String tip = content.getToolTipText();
        if (component == null) {
            component = content.getComponent();
        }
        this.addTab(content.getTitle(), content.getIcon(), component, tip);
        int index = this.getTabCount() - 1;
        this.setForegroundAt(index, content.getForeground());
        this.setDisabledIconAt(index, content.getDisabledIcon());
        this.setMnemonicAt(index, content.getMnemonic());
        content.addPropertyChangeListener((PropertyChangeListener)this);
        this.contentMap.put(index, content);
    }

    public int addTab(Content content, Component component, int index) {
        if (index < 0 || index >= this.getTabCount()) {
            this.addTab(content, component);
            return this.getTabCount() - 1;
        }
        String tip = content.getToolTipText();
        if (component == null) {
            component = content.getComponent();
        }
        Integer[] keys = this.contentMap.keySet().toArray(new Integer[this.contentMap.size()]);
        Arrays.sort(keys, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 < o2 ? 1 : (o1.equals(o2) ? 0 : -11);
            }
        });
        for (Integer key : keys) {
            if (key < index) continue;
            this.contentMap.put(key + 1, this.contentMap.remove(key));
        }
        this.insertTab(content.getTitle(), content.getIcon(), component, tip, index);
        this.setForegroundAt(index, content.getForeground());
        this.setDisabledIconAt(index, content.getDisabledIcon());
        this.setMnemonicAt(index, content.getMnemonic());
        content.addPropertyChangeListener((PropertyChangeListener)this);
        this.contentMap.put(index, content);
        return index;
    }

    public Content getContentAt(int index) {
        return this.contentMap.get(index);
    }

    public void addTabbedContentPaneListener(TabbedContentPaneListener listener) {
        this.listenerList.add(TabbedContentPaneListener.class, listener);
    }

    public void removeTabbedContentPaneListener(TabbedContentPaneListener listener) {
        this.listenerList.remove(TabbedContentPaneListener.class, listener);
    }

    public synchronized void setIndex(Content content, Integer newIndex) {
        if (newIndex < 0 || newIndex >= this.getTabCount()) {
            throw new IllegalArgumentException("Invalid index");
        }
        int index = this.indexOfContent(content);
        if (index != -1) {
            this.removeTabAt(index);
            this.addTab(content, content.getComponent(), newIndex);
        }
    }

    public int indexOfContent(Content content) {
        for (Integer key : this.contentMap.keySet()) {
            if (this.contentMap.get(key) != content) continue;
            return key;
        }
        return -1;
    }

    public Object getSelectedContent() {
        int index = this.getSelectedIndex();
        return index != -1 ? this.getContentAt(index) : null;
    }

    protected void initDragListener() {
        TabbedDragSourceListener dsl = new TabbedDragSourceListener();
        TabbedTransferable t = new TabbedTransferable();
        TabbedDragGestureListener dgl = new TabbedDragGestureListener(t, dsl);
        this.dropTarget = new DropTarget(this.toolWindowManager.getGlassPanel(), 3, new TabbedDropTargetListener(), true);
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, dgl);
    }

    public void setPaintGhost(boolean flag) {
        this.hasGhost = flag;
    }

    public boolean hasGhost() {
        return this.hasGhost;
    }

    protected int getTargetTabIndex(Point glassPt) {
        Point tabPt = SwingUtilities.convertPoint(this.toolWindowManager.getGlassPanel(), glassPt, this);
        boolean isTB = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle r = this.getBoundsAt(i);
            if (isTB) {
                r.setRect(r.x - r.width / 2, r.y, r.width, r.height);
            } else {
                r.setRect(r.x, r.y - r.height / 2, r.width, r.height);
            }
            if (!r.contains(tabPt)) continue;
            return i;
        }
        Rectangle r = this.getBoundsAt(this.getTabCount() - 1);
        if (isTB) {
            r.setRect(r.x + r.width / 2, r.y, r.width, r.height);
        } else {
            r.setRect(r.x, r.y + r.height / 2, r.width, r.height);
        }
        return r.contains(tabPt) ? this.getTabCount() : -1;
    }

    protected void convertTab(int prev, int next) {
        if (next < 0 || prev == next) {
            return;
        }
        Component cmp = this.getComponentAt(prev);
        Content content = this.getContentAt(prev);
        if (content == null) {
            throw new IllegalArgumentException("Invalid index location.");
        }
        content.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeTabAt(prev);
        this.contentMap.remove(prev);
        Object[] keys = this.contentMap.keySet().toArray(new Integer[this.contentMap.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            if ((Integer)key <= prev) continue;
            this.contentMap.put((Integer)key - 1, this.contentMap.remove(key));
        }
        if (next == this.getTabCount()) {
            this.addTab(content, cmp);
            this.setSelectedIndex(this.getTabCount() - 1);
        } else if (prev > next) {
            this.addTab(content, cmp, next);
            this.setSelectedIndex(next);
        } else {
            this.addTab(content, cmp, next - 1);
            this.setSelectedIndex(next - 1);
        }
    }

    protected void initTargetLeftRightLine(int next) {
        if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == this.getTabCount()) {
            Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
            this.lineRect.setRect(rect.x + rect.width - 1, rect.y, 3.0, rect.height);
        } else if (next == 0) {
            Rectangle rect = this.getBoundsAt(0);
            this.lineRect.setRect(-1.0, rect.y, 3.0, rect.height);
        } else {
            Rectangle rect = this.getBoundsAt(next - 1);
            this.lineRect.setRect(rect.x + rect.width - 1, rect.y, 3.0, rect.height);
        }
    }

    protected void initTargetTopBottomLine(int next) {
        if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == this.getTabCount()) {
            Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
            this.lineRect.setRect(rect.x, rect.y + rect.height - 1, rect.width, 3.0);
        } else if (next == 0) {
            Rectangle rect = this.getBoundsAt(0);
            this.lineRect.setRect(rect.x, -1.0, rect.width, 3.0);
        } else {
            Rectangle rect = this.getBoundsAt(next - 1);
            this.lineRect.setRect(rect.x, rect.y + rect.height - 1, rect.width, 3.0);
        }
    }

    protected void initGlassPane(Component c, Point tabPt) {
        if (this.hasGhost()) {
            Rectangle rect = this.getBoundsAt(this.dragTabIndex);
            BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
            Graphics g = image.getGraphics();
            c.paint(g);
            image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            this.toolWindowManager.getGlassPanel().setDraggingImage(image);
        }
        Point glassPt = SwingUtilities.convertPoint(c, tabPt, this.toolWindowManager.getGlassPanel());
        this.toolWindowManager.getGlassPanel().setPoint(glassPt);
        this.toolWindowManager.getGlassPanel().setVisible(true);
    }

    protected Rectangle getTabAreaBound() {
        Rectangle lastTab = this.getUI().getTabBounds(this, this.getTabCount() - 1);
        return new Rectangle(0, 0, this.getWidth(), lastTab.y + lastTab.height);
    }

    protected void fireCloseTabEvent(Content content) {
        TabbedContentPaneEvent event = new TabbedContentPaneEvent(this, TabbedContentPaneEvent.ActionId.ON_CLOSE, content);
        for (TabbedContentPaneListener tabListener : (TabbedContentPaneListener[])this.getListeners(TabbedContentPaneListener.class)) {
            tabListener.tabbedContentPaneEventFired(event);
        }
    }

    protected void fireDetachTabEvent(Content content) {
        TabbedContentPaneEvent event = new TabbedContentPaneEvent(this, TabbedContentPaneEvent.ActionId.ON_DETACH, content);
        for (TabbedContentPaneListener tabListener : (TabbedContentPaneListener[])this.getListeners(TabbedContentPaneListener.class)) {
            tabListener.tabbedContentPaneEventFired(event);
        }
    }

    protected class TabbedDragGestureListener
    implements DragGestureListener {
        private final Transferable t;
        private final DragSourceListener dsl;

        public TabbedDragGestureListener(Transferable t, DragSourceListener dsl) {
            this.t = t;
            this.dsl = dsl;
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            Point tabPt = e.getDragOrigin();
            JTabbedContentPane.this.dragTabIndex = JTabbedContentPane.this.indexAtLocation(tabPt.x, tabPt.y);
            if (JTabbedContentPane.this.dragTabIndex < 0) {
                return;
            }
            JTabbedContentPane.this.initGlassPane(e.getComponent(), e.getDragOrigin());
            try {
                e.startDrag(DragSource.DefaultMoveDrop, this.t, this.dsl);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                // empty catch block
            }
        }
    }

    protected class TabbedTransferable
    implements Transferable {
        private final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "test");

        protected TabbedTransferable() {
        }

        public Object getTransferData(DataFlavor flavor) {
            return JTabbedContentPane.this;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] f = new DataFlavor[]{this.FLAVOR};
            return f;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.getHumanPresentableName().equals(JTabbedContentPane.NAME);
        }
    }

    protected class TabbedDragSourceListener
    implements DragSourceListener {
        protected TabbedDragSourceListener() {
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
            JTabbedContentPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
            JTabbedContentPane.this.toolWindowManager.getGlassPanel().setPoint(new Point(-1000, -1000));
            JTabbedContentPane.this.toolWindowManager.getGlassPanel().repaint();
        }

        public void dragOver(DragSourceDragEvent e) {
            Point tabPt = e.getLocation();
            SwingUtilities.convertPointFromScreen(tabPt, JTabbedContentPane.this);
            Point glassPt = e.getLocation();
            SwingUtilities.convertPointFromScreen(glassPt, JTabbedContentPane.this.toolWindowManager.getGlassPanel());
            int targetIdx = JTabbedContentPane.this.getTargetTabIndex(glassPt);
            if (!JTabbedContentPane.this.getTabAreaBound().contains(tabPt) || targetIdx < 0 || targetIdx == JTabbedContentPane.this.dragTabIndex || targetIdx != JTabbedContentPane.this.dragTabIndex + 1) {
                // empty if block
            }
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            JTabbedContentPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
            JTabbedContentPane.this.dragTabIndex = -1;
            if (JTabbedContentPane.this.hasGhost()) {
                JTabbedContentPane.this.toolWindowManager.getGlassPanel().setVisible(false);
                JTabbedContentPane.this.toolWindowManager.getGlassPanel().setDraggingImage(null);
            }
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    protected class TabbedDropTargetListener
    implements DropTargetListener {
        protected TabbedDropTargetListener() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            if (this.isDragAcceptable(e)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void dragOver(DropTargetDragEvent e) {
            if (JTabbedContentPane.this.getTabPlacement() == 1 || JTabbedContentPane.this.getTabPlacement() == 3) {
                JTabbedContentPane.this.initTargetLeftRightLine(JTabbedContentPane.this.getTargetTabIndex(e.getLocation()));
            } else {
                JTabbedContentPane.this.initTargetTopBottomLine(JTabbedContentPane.this.getTargetTabIndex(e.getLocation()));
            }
            JTabbedContentPane.this.repaint();
            if (JTabbedContentPane.this.hasGhost()) {
                JTabbedContentPane.this.toolWindowManager.getGlassPanel().setPoint(e.getLocation());
                JTabbedContentPane.this.toolWindowManager.getGlassPanel().repaint();
            }
        }

        public void drop(DropTargetDropEvent e) {
            if (this.isDropAcceptable(e)) {
                JTabbedContentPane.this.convertTab(JTabbedContentPane.this.dragTabIndex, JTabbedContentPane.this.getTargetTabIndex(e.getLocation()));
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
            JTabbedContentPane.this.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = e.getCurrentDataFlavors();
            return t.isDataFlavorSupported(f[0]) && JTabbedContentPane.this.dragTabIndex >= 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = t.getTransferDataFlavors();
            return t.isDataFlavorSupported(f[0]) && JTabbedContentPane.this.dragTabIndex >= 0;
        }
    }

    protected class ExAggregateIcon
    extends AggregateIcon {
        protected int index;

        public ExAggregateIcon(Icon leftIcon, Icon rightIcon, int orientation) {
            super(leftIcon, rightIcon, orientation);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    protected class MouseOverTabListener
    extends MouseInputAdapter {
        protected int mouseOverTab = -1;
        protected JPopupMenu stdPopupMenu;
        protected boolean selectionOnPressed;
        protected int mouseOverTabWhenPressed;

        protected MouseOverTabListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (this.mouseOverTab >= 0 && this.mouseOverTab < JTabbedContentPane.this.getTabCount()) {
                this.selectionOnPressed = ((ExAggregateIcon)JTabbedContentPane.this.selectedTabIcon).getIndex() == this.mouseOverTab;
            }
            this.mouseOverTabWhenPressed = this.mouseOverTab;
        }

        public void mouseClicked(MouseEvent e) {
            JPopupMenu popupMenu;
            if (this.mouseOverTab >= 0 && this.mouseOverTab < JTabbedContentPane.this.getTabCount()) {
                if (this.mouseOverTab == this.mouseOverTabWhenPressed && !this.selectionOnPressed) {
                    return;
                }
                Content content = JTabbedContentPane.this.getContentAt(this.mouseOverTab);
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (this.isDetachFired(content.getContentUI(), e.getPoint())) {
                        JTabbedContentPane.this.fireDetachTabEvent(content);
                        return;
                    }
                    if (this.isCloseFired(content.getContentUI(), e.getPoint())) {
                        JTabbedContentPane.this.fireCloseTabEvent(content);
                        return;
                    }
                    if (this.isMinimizedFired(content.getContentUI(), e.getPoint())) {
                        content.setMinimized(!content.isMinimized());
                        return;
                    }
                    if (e.getClickCount() == 2) {
                        content.setMaximized(!content.isMaximized());
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    this.showPopupMenu(e);
                }
            } else if (SwingUtilities.isRightMouseButton(e) && (popupMenu = JTabbedContentPane.this.getComponentPopupMenu()) != null) {
                popupMenu.show(JTabbedContentPane.this, e.getX(), e.getY());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.mouseOverTab != -1) {
                int tmp = this.mouseOverTab;
                this.mouseOverTab = -1;
                if (tmp < JTabbedContentPane.this.getTabCount()) {
                    JTabbedContentPane.this.repaint(JTabbedContentPane.this.getBoundsAt(tmp));
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            int tabIndex;
            if (!JTabbedContentPane.this.isEnabled()) {
                return;
            }
            if (this.mouseOverTab != -1) {
                int tmp = this.mouseOverTab;
                this.mouseOverTab = -1;
                if (tmp < JTabbedContentPane.this.getTabCount()) {
                    JTabbedContentPane.this.repaint(JTabbedContentPane.this.getBoundsAt(tmp));
                }
            }
            if ((tabIndex = JTabbedContentPane.this.indexAtLocation(e.getX(), e.getY())) >= 0 && JTabbedContentPane.this.isEnabledAt(tabIndex)) {
                this.mouseOverTab = tabIndex;
                if (tabIndex < JTabbedContentPane.this.getTabCount()) {
                    JTabbedContentPane.this.repaint(JTabbedContentPane.this.getBoundsAt(tabIndex));
                }
            }
        }

        protected boolean isMinimizedFired(ContentUI contentUI, Point point) {
            Point relativeMousePoint = SwingUtilities.convertPoint(JTabbedContentPane.this, point, this.getDestination());
            Rectangle iconBounds = JTabbedContentPane.this.minCloseDetachIcon.getLastPaintedLeftRec();
            return contentUI.isMinimizable() && (relativeMousePoint.getX() > (double)iconBounds.x && relativeMousePoint.getX() < (double)(iconBounds.x + iconBounds.width) || point.getX() > (double)iconBounds.x && point.getX() < (double)(iconBounds.x + iconBounds.width));
        }

        protected boolean isDetachFired(ContentUI contentUI, Point point) {
            Point relativeMousePoint = SwingUtilities.convertPoint(JTabbedContentPane.this, point, this.getDestination());
            Rectangle iconBounds = JTabbedContentPane.this.closeDetachIcon.getLastPaintedLeftRec();
            return contentUI.isDetachable() && (relativeMousePoint.getX() > (double)iconBounds.x && relativeMousePoint.getX() < (double)(iconBounds.x + iconBounds.width) || point.getX() > (double)iconBounds.x && point.getX() < (double)(iconBounds.x + iconBounds.width));
        }

        protected boolean isCloseFired(ContentUI contentUI, Point point) {
            Point relativeMousePoint = SwingUtilities.convertPoint(JTabbedContentPane.this, point, this.getDestination());
            Rectangle iconsBounds = JTabbedContentPane.this.closeDetachIcon.getLastPaintedRightRec();
            return contentUI.isCloseable() && (relativeMousePoint.getX() > (double)iconsBounds.x && relativeMousePoint.getX() < (double)(iconsBounds.x + iconsBounds.width) || point.getX() > (double)iconsBounds.x && point.getX() < (double)(iconsBounds.x + iconsBounds.width));
        }

        protected Component getDestination() {
            int size = JTabbedContentPane.this.getComponentCount();
            for (int i = 0; i < size; ++i) {
                if (!(JTabbedContentPane.this.getComponent(i) instanceof JViewport)) continue;
                return ((JViewport)JTabbedContentPane.this.getComponent(i)).getView();
            }
            return JTabbedContentPane.this;
        }

        protected void showPopupMenu(MouseEvent mouseEvent) {
            final Content contentAt = JTabbedContentPane.this.getContentAt(this.mouseOverTab);
            JPopupMenu popupMenu = contentAt.getPopupMenu();
            if (popupMenu == null) {
                popupMenu = JTabbedContentPane.this.getComponentPopupMenu();
            }
            if (popupMenu == null) {
                this.stdPopupMenu = new JPopupMenu("Content Page Popup");
                this.stdPopupMenu.add(new JMenuItem(new AbstractAction(JTabbedContentPane.this.resourceManager.getString("@@tabbed.page.close")){

                    public void actionPerformed(ActionEvent e) {
                        JTabbedContentPane.this.fireCloseTabEvent(contentAt);
                    }
                })).setEnabled(contentAt.getContentUI().isCloseable());
                this.stdPopupMenu.add(new JMenuItem(new AbstractAction(JTabbedContentPane.this.resourceManager.getString("@@tabbed.page.closeAll")){

                    public void actionPerformed(ActionEvent e) {
                        for (Content content : JTabbedContentPane.this.toolWindowManager.getContentManager().getContents()) {
                            if (!content.getContentUI().isCloseable()) continue;
                            JTabbedContentPane.this.fireCloseTabEvent(content);
                        }
                    }
                }));
                this.stdPopupMenu.add(new JMenuItem(new AbstractAction(JTabbedContentPane.this.resourceManager.getString("@@tabbed.page.closeAllButThis")){

                    public void actionPerformed(ActionEvent e) {
                        for (Content content : JTabbedContentPane.this.toolWindowManager.getContentManager().getContents()) {
                            if (content == contentAt || !content.getContentUI().isCloseable()) continue;
                            JTabbedContentPane.this.fireCloseTabEvent(content);
                        }
                    }
                }));
                this.stdPopupMenu.addSeparator();
                this.stdPopupMenu.add(new JMenuItem(new AbstractAction(JTabbedContentPane.this.resourceManager.getString("@@tabbed.page.detach")){

                    public void actionPerformed(ActionEvent e) {
                        JTabbedContentPane.this.fireDetachTabEvent(contentAt);
                    }
                })).setEnabled(contentAt.getContentUI().isDetachable());
                MaximizeAction maximizeAction = new MaximizeAction(contentAt);
                this.stdPopupMenu.add(maximizeAction);
                maximizeAction.putValue("Name", contentAt.isMaximized() || this.isAContentMaximized() ? JTabbedContentPane.this.resourceManager.getString("@@tabbed.page.restore") : JTabbedContentPane.this.resourceManager.getString("@@tabbed.page.maximize"));
                popupMenu = this.stdPopupMenu;
            }
            if (popupMenu != null) {
                popupMenu.show(JTabbedContentPane.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        protected boolean isAContentMaximized() {
            for (Content content : JTabbedContentPane.this.toolWindowManager.getContentManager().getContents()) {
                if (!content.isMaximized()) continue;
                return true;
            }
            return false;
        }

        class MaximizeAction
        extends AbstractAction {
            Content content;

            public MaximizeAction(Content content) {
                super(JTabbedContentPane.this.resourceManager.getString("@@tabbed.page.maximize"));
                this.content = content;
            }

            public void actionPerformed(ActionEvent e) {
                this.content.setMaximized(!this.content.isMaximized());
            }
        }
    }
}

