/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.BasicPanelUI;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowListener;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.event.ToolWindowTabEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowTab;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.support.PropertyChangeBridge;
import org.noos.xing.mydoggy.plaf.ui.DockedContainer;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.TitleBarTabs;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowActiveButton;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGesture;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGestureDelegate;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.MouseEventDispatcher;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowTabPanel
extends JComponent
implements TitleBarTabs,
Cleaner {
    protected DockedContainer dockedContainer;
    protected ToolWindowDescriptor descriptor;
    protected ToolWindow toolWindow;
    protected ResourceManager resourceManager;
    protected JViewport viewport;
    protected JPanel tabContainer;
    protected TableLayout containerLayout;
    protected ToolWindowTab selectedTab;
    protected Component selecTabButton;
    protected PopupButton popupButton;
    protected DragGestureDelegate dragGestureDelegate;
    protected MouseEventDispatcher mouseEventDispatcher;
    protected PropertyChangeBridge propertyChangeBridge;

    public ToolWindowTabPanel(DockedContainer dockedContainer, ToolWindowDescriptor descriptor) {
        this.descriptor = descriptor;
        this.toolWindow = descriptor.getToolWindow();
        this.resourceManager = descriptor.getResourceManager();
        this.dockedContainer = dockedContainer;
        this.mouseEventDispatcher = new MouseEventDispatcher();
        this.dragGestureDelegate = new DragGestureDelegate();
        descriptor.getCleaner().addCleaner(this);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        this.toolWindow = null;
        this.descriptor = null;
        this.resourceManager = null;
        this.dockedContainer = null;
        this.selectedTab = null;
        this.selecTabButton = null;
        this.dragGestureDelegate = null;
    }

    public void setDragGesture(DragGesture dragGesture) {
        this.dragGestureDelegate.setDragGesture(dragGesture);
    }

    public void addEventDispatcherlListener(EventListener eventListener) {
        this.mouseEventDispatcher.addListener(eventListener);
    }

    public void removeEventDispatcherlListener(EventListener eventListener) {
        this.mouseEventDispatcher.removeListener(eventListener);
    }

    protected void initComponents() {
        this.propertyChangeBridge = new PropertyChangeBridge();
        this.descriptor.getCleaner().addCleaner(this.propertyChangeBridge);
        this.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{-1.0, 1.0, 14.0}, {0.0, -1.0, 0.0}}, false)));
        this.setFocusable(false);
        this.setBorder(null);
        this.containerLayout = new TableLayout((double[][])new double[][]{{0.0}, {this.resourceManager.getFloat("toolwindow.title.font.size", 12.0f) + 4.0f}});
        this.tabContainer = new JPanel((LayoutManager)this.containerLayout);
        this.tabContainer.setName("toolWindow.tabContainer." + this.descriptor.getToolWindow().getId());
        this.tabContainer.setOpaque(false);
        this.tabContainer.setBorder(null);
        this.tabContainer.setFocusable(false);
        this.viewport = new JViewport();
        this.viewport.setBorder(null);
        this.viewport.setOpaque(false);
        this.viewport.setFocusable(false);
        this.viewport.setView(this.tabContainer);
        this.add((Component)this.viewport, "0,1,FULL,FULL");
        this.popupButton = new PopupButton();
        this.add((Component)this.popupButton, "2,1,FULL,FULL");
        this.viewport.addMouseWheelListener(new WheelScroller());
        this.initTabs();
    }

    protected void initListeners() {
        this.propertyChangeBridge.addBridgePropertyChangeListener("selected", new TabSelectedPropertyChangeListener());
        this.dockedContainer.setPopupUpdater(new DockedContainer.PopupUpdater(){
            final JMenuItem nextTabItem;
            final JMenuItem previousTabItem;
            final JMenuItem closeAllItem;
            {
                this.nextTabItem = new JMenuItem(new SelectNextTabAction());
                this.previousTabItem = new JMenuItem(new SelectPreviousTabAction());
                this.closeAllItem = new JMenuItem(new CloseAllTabAction());
            }

            public void update(Component source, JPopupMenu popupMenu) {
                if (source.getParent() instanceof TabButton) {
                    boolean enableByTabsCount = ToolWindowTabPanel.this.toolWindow.getToolWindowTabs().length > 1;
                    TabButton tabButton = (TabButton)source.getParent();
                    int index = 0;
                    if (tabButton.tab.isCloseable()) {
                        JMenuItem closeItem = new JMenuItem(new CloseTabAction(tabButton.tab));
                        popupMenu.add((Component)closeItem, index++);
                        popupMenu.add((Component)this.closeAllItem, index++);
                        popupMenu.add((Component)new JSeparator(), index++);
                    }
                    popupMenu.add((Component)this.nextTabItem, index++);
                    popupMenu.add((Component)this.previousTabItem, index++);
                    popupMenu.add((Component)new JSeparator(), index);
                    this.nextTabItem.setEnabled(enableByTabsCount);
                    this.previousTabItem.setEnabled(enableByTabsCount);
                }
            }

            class CloseAllTabAction
            extends AbstractAction {
                public CloseAllTabAction() {
                    super(ToolWindowTabPanel.this.resourceManager.getString("@@tool.tab.closeAll"));
                }

                public void actionPerformed(ActionEvent e) {
                    ToolWindowTab selectedTab = null;
                    for (ToolWindowTab tab : ToolWindowTabPanel.this.toolWindow.getToolWindowTabs()) {
                        if (tab.isSelected()) {
                            selectedTab = tab;
                            continue;
                        }
                        this.tryToClose(tab);
                    }
                    this.tryToClose(selectedTab);
                }

                protected void tryToClose(ToolWindowTab tab) {
                    if (tab != null && tab.isCloseable()) {
                        ToolWindowListener listener;
                        boolean result;
                        ToolWindowTabEvent event = new ToolWindowTabEvent((Object)this, ToolWindowTabEvent.ActionId.TAB_REMOVING, ToolWindowTabPanel.this.toolWindow, tab);
                        ToolWindowListener[] arr$ = ToolWindowTabPanel.this.toolWindow.getToolWindowListeners();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (result = (listener = arr$[i$]).toolWindowTabRemoving(event)); ++i$) {
                        }
                        ToolWindowTabPanel.this.toolWindow.removeToolWindowTab(tab);
                    }
                }
            }

            class CloseTabAction
            extends AbstractAction {
                ToolWindowTab tab;

                public CloseTabAction(ToolWindowTab tab) {
                    super(ToolWindowTabPanel.this.resourceManager.getString("@@tool.tab.close"));
                    this.tab = tab;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.tab.isCloseable()) {
                        ToolWindowListener listener;
                        boolean result;
                        ToolWindowTabEvent event = new ToolWindowTabEvent((Object)this, ToolWindowTabEvent.ActionId.TAB_REMOVING, ToolWindowTabPanel.this.toolWindow, this.tab);
                        ToolWindowListener[] arr$ = ToolWindowTabPanel.this.toolWindow.getToolWindowListeners();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (result = (listener = arr$[i$]).toolWindowTabRemoving(event)); ++i$) {
                        }
                        ToolWindowTabPanel.this.toolWindow.removeToolWindowTab(this.tab);
                    }
                }
            }
        });
        this.toolWindow.addToolWindowListener((ToolWindowListener)new TabToolWindowListener());
        this.viewport.addMouseListener(this.dockedContainer.getTitleBarMouseAdapter());
        this.viewport.addMouseListener(this.mouseEventDispatcher);
        this.viewport.addMouseMotionListener(this.mouseEventDispatcher);
        SwingUtil.registerDragGesture(this.viewport, this.dragGestureDelegate);
    }

    protected void initTabs() {
        for (ToolWindowTab tab : this.toolWindow.getToolWindowTabs()) {
            this.addTab((MyDoggyToolWindowTab)tab);
        }
        this.checkPopupButton();
    }

    protected void addTab(TabButton tabButton) {
        int column = this.containerLayout.getNumColumn();
        this.containerLayout.insertColumn(column, 0.0);
        this.containerLayout.insertColumn(column + 1, -2.0);
        this.containerLayout.insertColumn(column + 2, 0.0);
        this.tabContainer.add((Component)tabButton, column + 1 + ",0" + ",FULL,FULL");
        SwingUtil.repaint(this.tabContainer);
    }

    protected void addTab(MyDoggyToolWindowTab tab) {
        TabButton tabButton = new TabButton(tab);
        tab.removePlafPropertyChangeListener(this.propertyChangeBridge);
        tab.addPlafPropertyChangeListener(this.propertyChangeBridge);
        this.addTab(tabButton);
    }

    protected ToolWindowTab removeTab(ToolWindowTab toolWindowTab, boolean flag) {
        int nextTabCol = -1;
        for (Component component : this.tabContainer.getComponents()) {
            if (!(component instanceof TabButton)) continue;
            TabButton tabButton = (TabButton)component;
            if (tabButton.tab != toolWindowTab) continue;
            TableLayoutConstraints constraints = this.containerLayout.getConstraints((Component)tabButton);
            this.tabContainer.remove(tabButton);
            if (flag) {
                tabButton.removePropertyChangeListener(this.propertyChangeBridge);
            }
            nextTabCol = constraints.col1;
            int col = constraints.col1 - 1;
            this.containerLayout.deleteColumn(col);
            this.containerLayout.deleteColumn(col);
            this.containerLayout.deleteColumn(col);
            break;
        }
        SwingUtil.repaint(this.tabContainer);
        MyDoggyToolWindowTab firstTab = null;
        if (nextTabCol != -1) {
            for (Component component : this.tabContainer.getComponents()) {
                if (!(component instanceof TabButton)) continue;
                TabButton tabButton = (TabButton)component;
                TableLayoutConstraints constraints = this.containerLayout.getConstraints((Component)tabButton);
                if (constraints.col1 == nextTabCol) {
                    return tabButton.tab;
                }
                if (constraints.col1 != 2) continue;
                firstTab = tabButton.tab;
            }
        }
        return firstTab;
    }

    protected void checkPopupButton() {
        boolean visible = this.toolWindow.getToolWindowTabs().length > 1;
        this.popupButton.setVisible(visible);
        ((TableLayout)this.getLayout()).setColumn(2, visible ? 14.0 : 0.0);
    }

    protected class SelectTabAction
    extends AbstractAction {
        private ToolWindowTab tab;

        public SelectTabAction(ToolWindowTab tab) {
            super(tab.getTitle());
            this.tab = tab;
        }

        public void actionPerformed(ActionEvent e) {
            this.tab.setSelected(true);
        }
    }

    protected class SelectPreviousTabAction
    extends AbstractAction {
        public SelectPreviousTabAction() {
            super(ToolWindowTabPanel.this.resourceManager.getString("@@tool.tab.selectPreviuos"));
        }

        public void actionPerformed(ActionEvent e) {
            ToolWindowTab[] tabs = ToolWindowTabPanel.this.toolWindow.getToolWindowTabs();
            if (ToolWindowTabPanel.this.selectedTab != null && ToolWindowTabPanel.this.selecTabButton != null) {
                int nextTabCol = ToolWindowTabPanel.this.containerLayout.getConstraints((Component)ToolWindowTabPanel.this.selecTabButton).col1 - 3;
                for (Component component : ToolWindowTabPanel.this.tabContainer.getComponents()) {
                    if (!(component instanceof TabButton)) continue;
                    TabButton tabButton = (TabButton)component;
                    TableLayoutConstraints constraints = ToolWindowTabPanel.this.containerLayout.getConstraints((Component)tabButton);
                    if (constraints.col1 != nextTabCol) continue;
                    tabButton.tab.setSelected(true);
                    return;
                }
                if (tabs.length > 0) {
                    tabs[tabs.length - 1].setSelected(true);
                }
            } else if (tabs.length > 0) {
                tabs[tabs.length - 1].setSelected(true);
            }
        }
    }

    protected class SelectNextTabAction
    extends AbstractAction {
        public SelectNextTabAction() {
            super(ToolWindowTabPanel.this.resourceManager.getString("@@tool.tab.selectNext"));
        }

        public void actionPerformed(ActionEvent e) {
            ToolWindowTab[] tabs = ToolWindowTabPanel.this.toolWindow.getToolWindowTabs();
            if (ToolWindowTabPanel.this.selectedTab != null && ToolWindowTabPanel.this.selecTabButton != null) {
                int nextTabCol = ToolWindowTabPanel.this.containerLayout.getConstraints((Component)ToolWindowTabPanel.this.selecTabButton).col1 + 3;
                for (Component component : ToolWindowTabPanel.this.tabContainer.getComponents()) {
                    if (!(component instanceof TabButton)) continue;
                    TabButton tabButton = (TabButton)component;
                    TableLayoutConstraints constraints = ToolWindowTabPanel.this.containerLayout.getConstraints((Component)tabButton);
                    if (constraints.col1 != nextTabCol) continue;
                    tabButton.tab.setSelected(true);
                    return;
                }
                if (tabs.length > 0) {
                    tabs[0].setSelected(true);
                }
            } else if (tabs.length > 0) {
                tabs[0].setSelected(true);
            }
        }
    }

    protected class TabSelectedPropertyChangeListener
    implements PropertyChangeListener {
        protected TabSelectedPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowTab tab = (ToolWindowTab)evt.getSource();
            if (evt.getNewValue() == Boolean.TRUE) {
                if (ToolWindowTabPanel.this.selectedTab != null) {
                    ToolWindowTabPanel.this.selectedTab.setSelected(false);
                }
                ToolWindowTabPanel.this.selectedTab = tab;
            }
        }
    }

    protected class WheelScroller
    implements MouseWheelListener {
        protected WheelScroller() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            switch (e.getWheelRotation()) {
                case 1: {
                    Rectangle visRect = ToolWindowTabPanel.this.viewport.getViewRect();
                    Rectangle bounds = ToolWindowTabPanel.this.tabContainer.getBounds();
                    visRect.x += e.getUnitsToScroll() * 2;
                    if (visRect.x + visRect.width >= bounds.width) {
                        visRect.x = bounds.width - visRect.width;
                    }
                    ToolWindowTabPanel.this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                    break;
                }
                case -1: {
                    Rectangle visRect = ToolWindowTabPanel.this.viewport.getViewRect();
                    visRect.x += e.getUnitsToScroll() * 2;
                    if (visRect.x < 0) {
                        visRect.x = 0;
                    }
                    ToolWindowTabPanel.this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                }
            }
        }
    }

    protected class PopupButton
    extends ToolWindowActiveButton
    implements ActionListener {
        protected JPopupMenu popupMenu;

        public PopupButton() {
            this.setIcon(ToolWindowTabPanel.this.resourceManager.getIcon("TOO_WINDOW_TAB_POPUP"));
            this.addActionListener(this);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    ToolWindowTabPanel.this.toolWindow.setActive(true);
                }
            });
            this.setVisible(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.initPopup();
            this.popupMenu.show(this, 10, 10);
        }

        protected void initPopup() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu("TabPopup");
                this.popupMenu.add(new SelectNextTabAction());
                this.popupMenu.add(new SelectPreviousTabAction());
                this.popupMenu.addSeparator();
            }
            int size = this.popupMenu.getComponentCount();
            for (int i = 3; i < size; ++i) {
                this.popupMenu.remove(3);
            }
            for (ToolWindowTab tab : ToolWindowTabPanel.this.toolWindow.getToolWindowTabs()) {
                this.popupMenu.add(new SelectTabAction(tab));
            }
        }
    }

    protected class TabButton
    extends JPanel
    implements PropertyChangeListener,
    MouseListener,
    ActionListener,
    Cleaner {
        protected MyDoggyToolWindowTab tab;
        protected TableLayout layout;
        protected JLabel titleLabel;
        protected JButton closeButton;
        protected JButton minimizeButton;
        protected boolean pressed;
        protected boolean inside;
        protected boolean selected;
        protected Timer flashingTimer;
        protected int flasingDuration = -1;
        protected boolean flashingState;

        public TabButton(final MyDoggyToolWindowTab tab) {
            this.tab = tab;
            tab.getCleaner().addCleaner(this);
            this.putClientProperty(ToolWindowTab.class, tab);
            this.layout = new TableLayout((double[][])new double[][]{{-1.0, 0.0, 0.0, 0.0, 0.0}, {-1.0}});
            this.setLayout((LayoutManager)this.layout);
            this.setOpaque(false);
            this.setFocusable(false);
            this.setUI(new TabButtonPanelUI());
            this.addMouseListener(ToolWindowTabPanel.this.mouseEventDispatcher);
            this.addMouseMotionListener(ToolWindowTabPanel.this.mouseEventDispatcher);
            String name = "toolWindow." + tab.getOwner().getId() + ".tab." + tab.getTitle();
            this.setName(name);
            this.tab.addPropertyChangeListener(this);
            this.inside = false;
            this.pressed = false;
            this.selected = false;
            this.titleLabel = new JLabel(tab.getTitle());
            this.titleLabel.setName(name + ".title");
            this.titleLabel.setForeground(ToolWindowTabPanel.this.resourceManager.getColor("TWTB_TAB_FOREGROUND_UNSELECTED"));
            this.titleLabel.setOpaque(false);
            this.titleLabel.setFocusable(false);
            this.titleLabel.setIcon(tab.getIcon());
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(ToolWindowTabPanel.this.resourceManager.getFloat("toolwindow.title.font.size", 12.0f)));
            this.titleLabel.setUI(new BasicLabelUI(){

                public void update(Graphics g, JComponent c) {
                    if (tab.isFlashing() && ToolWindowTabPanel.this.toolWindow.isVisible()) {
                        if (TabButton.this.flashingState) {
                            TabButton.this.titleLabel.setForeground(ToolWindowTabPanel.this.resourceManager.getColor("TWTB_TAB_FOREGROUND_SELECTED"));
                        } else {
                            TabButton.this.titleLabel.setForeground(ToolWindowTabPanel.this.resourceManager.getColor("TWTB_TAB_FOREGROUND_UNSELECTED"));
                        }
                    } else if (TabButton.this.selected) {
                        TabButton.this.titleLabel.setForeground(ToolWindowTabPanel.this.resourceManager.getColor("TWTB_TAB_FOREGROUND_SELECTED"));
                    } else {
                        TabButton.this.titleLabel.setForeground(ToolWindowTabPanel.this.resourceManager.getColor("TWTB_TAB_FOREGROUND_UNSELECTED"));
                    }
                    super.update(g, c);
                }

                protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
                    if (TabButton.this.pressed && TabButton.this.inside) {
                        super.paintEnabledText(l, g, s, textX + 1, textY + 1);
                    } else {
                        super.paintEnabledText(l, g, s, textX, textY);
                    }
                }
            });
            this.titleLabel.addMouseListener(ToolWindowTabPanel.this.dockedContainer.getTitleBarMouseAdapter());
            this.titleLabel.addMouseListener(ToolWindowTabPanel.this.mouseEventDispatcher);
            this.titleLabel.addMouseMotionListener(ToolWindowTabPanel.this.mouseEventDispatcher);
            this.titleLabel.addMouseListener(this);
            this.add((Component)this.titleLabel, "0,0,FULL,FULL");
            this.closeButton = (JButton)ToolWindowTabPanel.this.resourceManager.createComponent("TOOL_WINDOW_TITLE_BUTTON", ToolWindowTabPanel.this.descriptor.getManager().getContext());
            this.closeButton.setName(name + ".closeButton");
            this.closeButton.setActionCommand("close");
            this.closeButton.addActionListener(this);
            this.closeButton.setToolTipText(ToolWindowTabPanel.this.resourceManager.getString("@@tool.tab.close"));
            this.closeButton.setIcon(ToolWindowTabPanel.this.resourceManager.getIcon("TAB_CLOSE"));
            this.minimizeButton = (JButton)ToolWindowTabPanel.this.resourceManager.createComponent("TOOL_WINDOW_TITLE_BUTTON", ToolWindowTabPanel.this.descriptor.getManager().getContext());
            this.minimizeButton.setName(name + ".minimizeButton");
            this.minimizeButton.setActionCommand("minimize");
            this.minimizeButton.addActionListener(this);
            this.minimizeButton.setToolTipText(ToolWindowTabPanel.this.resourceManager.getString("@@tool.tab.minimize"));
            this.minimizeButton.setIcon(ToolWindowTabPanel.this.resourceManager.getIcon("TAB_MINIMIZE"));
            this.add((Component)this.minimizeButton, "2,0,FULL,c");
            this.add((Component)this.closeButton, "4,0,FULL,c");
            SwingUtil.registerDragGesture(this, ToolWindowTabPanel.this.dragGestureDelegate);
            SwingUtil.registerDragGesture(this.titleLabel, ToolWindowTabPanel.this.dragGestureDelegate);
            SwingUtil.registerDragGesture(this.minimizeButton, ToolWindowTabPanel.this.dragGestureDelegate);
            SwingUtil.registerDragGesture(this.closeButton, ToolWindowTabPanel.this.dragGestureDelegate);
        }

        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if ("close".equals(actionCommand)) {
                ToolWindowTabPanel.this.toolWindow.removeToolWindowTab((ToolWindowTab)this.tab);
            } else {
                this.tab.setMinimized(true);
            }
        }

        public void mousePressed(MouseEvent e) {
            ToolWindowTabPanel.this.toolWindow.setActive(true);
            if (SwingUtilities.isLeftMouseButton(e) && !this.selected) {
                this.pressed = true;
                this.repaint();
            } else {
                this.pressed = false;
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.pressed = false;
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            this.inside = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.inside = false;
            this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TabButton.this.tab.setSelected(true);
                    }
                });
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("selected".equals(property)) {
                if (evt.getNewValue() == Boolean.FALSE) {
                    ToolWindowTabPanel.this.selecTabButton = null;
                    this.titleLabel.setForeground(ToolWindowTabPanel.this.resourceManager.getColor("TWTB_TAB_FOREGROUND_UNSELECTED"));
                    this.closeButton.setIcon(ToolWindowTabPanel.this.resourceManager.getIcon("TAB_CLOSE_INACTIVE"));
                    this.minimizeButton.setIcon(ToolWindowTabPanel.this.resourceManager.getIcon("TAB_MINIMIZE_INACTIVE"));
                    this.setButtonsEnabled(false);
                    this.selected = false;
                } else {
                    this.tab.setFlashing(false);
                    ToolWindowTabPanel.this.selecTabButton = this;
                    this.ensureVisible();
                    this.titleLabel.setForeground(ToolWindowTabPanel.this.resourceManager.getColor("TWTB_TAB_FOREGROUND_SELECTED"));
                    this.closeButton.setIcon(ToolWindowTabPanel.this.resourceManager.getIcon("TAB_CLOSE"));
                    this.minimizeButton.setIcon(ToolWindowTabPanel.this.resourceManager.getIcon("TAB_MINIMIZE"));
                    this.setButtonsEnabled(true);
                    this.selected = true;
                }
                SwingUtil.repaint(this);
            } else if ("title".equals(property)) {
                this.titleLabel.setText((String)evt.getNewValue());
                this.setName("toolWindow." + ToolWindowTabPanel.this.toolWindow.getId() + ".tabs." + this.tab.getTitle());
            } else if ("icon".equals(property)) {
                this.titleLabel.setIcon((Icon)evt.getNewValue());
            } else if ("flash".equals(property)) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    if (!this.tab.isSelected()) {
                        this.flasingDuration = -1;
                        SwingUtil.repaint(this);
                    }
                } else if (this.flashingTimer != null) {
                    this.flashingTimer.stop();
                    this.flashingTimer = null;
                    SwingUtil.repaint(this);
                }
            } else if ("flash.duration".equals(property)) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    if (!this.tab.isSelected()) {
                        this.flasingDuration = (Integer)evt.getNewValue();
                        SwingUtil.repaint(this);
                    }
                } else if (this.flashingTimer != null) {
                    this.flashingTimer.stop();
                    this.flashingTimer = null;
                    SwingUtil.repaint(this);
                }
            } else if ("minimized".equals(property)) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    ToolWindowTab nextTab = ToolWindowTabPanel.this.removeTab(this.tab, false);
                    if (nextTab != null) {
                        nextTab.setSelected(true);
                    }
                } else {
                    ToolWindowTabPanel.this.addTab(this);
                }
            } else if ("ensureVisible".equals(property)) {
                this.ensureVisible();
            }
        }

        public Insets getInsets() {
            return new Insets(0, 5, 0, 5);
        }

        public void cleanup() {
            if (this.flashingTimer != null) {
                this.flashingTimer.stop();
            }
            this.flashingTimer = null;
            this.tab.removePropertyChangeListener(this);
            this.removeMouseMotionListener(ToolWindowTabPanel.this.mouseEventDispatcher);
            this.removeMouseListener(ToolWindowTabPanel.this.mouseEventDispatcher);
            this.putClientProperty(ToolWindowTab.class, null);
            this.titleLabel.removeMouseListener(ToolWindowTabPanel.this.dockedContainer.getTitleBarMouseAdapter());
            this.titleLabel.removeMouseListener(ToolWindowTabPanel.this.mouseEventDispatcher);
            this.titleLabel.removeMouseMotionListener(ToolWindowTabPanel.this.mouseEventDispatcher);
            this.titleLabel.removeMouseListener(this);
            if (ToolWindowTabPanel.this.selectedTab == this.tab) {
                ToolWindowTabPanel.this.selectedTab = null;
            }
            this.tab = null;
        }

        protected void setButtonsEnabled(boolean enabled) {
            if (enabled && ToolWindowTabPanel.this.tabContainer.getComponentCount() > 1) {
                if (this.tab.isCloseable()) {
                    this.layout.setColumn(3, 1.0);
                    this.layout.setColumn(4, 14.0);
                } else {
                    this.layout.setColumn(3, 0.0);
                    this.layout.setColumn(4, 0.0);
                }
                this.layout.setColumn(1, 1.0);
                this.layout.setColumn(2, 14.0);
            } else {
                this.layout.setColumn(1, 0.0);
                this.layout.setColumn(2, 0.0);
                this.layout.setColumn(3, 0.0);
                this.layout.setColumn(4, 0.0);
            }
            this.revalidate();
            this.repaint();
        }

        protected void ensureVisible() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Rectangle cellBounds = TabButton.this.getBounds();
                    cellBounds.x -= ToolWindowTabPanel.this.viewport.getViewPosition().x;
                    ToolWindowTabPanel.this.viewport.scrollRectToVisible(cellBounds);
                }
            });
        }

        protected class TabButtonPanelUI
        extends BasicPanelUI {
            protected TabButtonPanelUI() {
            }

            public void update(Graphics g, JComponent c) {
                if (TabButton.this.tab == null || ToolWindowTabPanel.this.toolWindow == null) {
                    return;
                }
                Rectangle bounds = c.getBounds();
                bounds.y = 0;
                bounds.x = 0;
                if (TabButton.this.tab.isFlashing() && ToolWindowTabPanel.this.toolWindow.isVisible()) {
                    if (TabButton.this.flashingState) {
                        GraphicsUtil.fillRect(g, bounds, ToolWindowTabPanel.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_END"), ToolWindowTabPanel.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"), new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 10.0, 10.0), 5);
                    } else if (ToolWindowTabPanel.this.toolWindow.isActive()) {
                        GraphicsUtil.fillRect(g, bounds, ToolWindowTabPanel.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"), ToolWindowTabPanel.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_END"), new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 10.0, 10.0), 5);
                    }
                    if (TabButton.this.flashingTimer == null) {
                        TabButton.this.flashingTimer = new Timer(600, new ActionListener(){
                            long start = 0L;

                            public void actionPerformed(ActionEvent e) {
                                Rectangle bounds = TabButton.this.getBounds();
                                bounds.y = 0;
                                bounds.x = 0;
                                if (this.start == 0L) {
                                    this.start = System.currentTimeMillis();
                                }
                                TabButton.this.flashingState = !TabButton.this.flashingState;
                                SwingUtil.repaint(TabButton.this);
                                if (TabButton.this.flasingDuration != -1 && System.currentTimeMillis() - this.start > (long)TabButton.this.flasingDuration) {
                                    TabButton.this.tab.setFlashing(false);
                                }
                            }
                        });
                        TabButton.this.flashingState = true;
                    }
                    if (!TabButton.this.flashingTimer.isRunning()) {
                        TabButton.this.flashingTimer.start();
                    }
                } else if (ToolWindowTabPanel.this.tabContainer.getComponentCount() > 1 && TabButton.this.selected && ToolWindowTabPanel.this.toolWindow.isActive()) {
                    GraphicsUtil.fillRect(g, bounds, ToolWindowTabPanel.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_END"), ToolWindowTabPanel.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"), new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 10.0, 10.0), 5);
                }
                super.update(g, c);
            }
        }
    }

    protected class TabToolWindowListener
    implements ToolWindowListener,
    Cleaner {
        public TabToolWindowListener() {
            ToolWindowTabPanel.this.descriptor.getCleaner().addBefore(ToolWindowTabPanel.this, this);
        }

        public void cleanup() {
            ToolWindowTabPanel.this.descriptor.getToolWindow().removeToolWindowListener(this);
        }

        public void toolWindowTabAdded(ToolWindowTabEvent event) {
            if (ToolWindowTabPanel.this.tabContainer.getComponentCount() == 0) {
                ToolWindowTabPanel.this.initTabs();
            } else {
                ToolWindowTabPanel.this.addTab((MyDoggyToolWindowTab)event.getToolWindowTab());
            }
            ToolWindowTabPanel.this.checkPopupButton();
        }

        public boolean toolWindowTabRemoving(ToolWindowTabEvent event) {
            return true;
        }

        public void toolWindowTabRemoved(ToolWindowTabEvent event) {
            ToolWindowTab nextTab = ToolWindowTabPanel.this.removeTab(event.getToolWindowTab(), true);
            if (event.getToolWindowTab().isSelected()) {
                ToolWindowTab[] tabs = ToolWindowTabPanel.this.toolWindow.getToolWindowTabs();
                if (tabs.length > 0) {
                    if (nextTab != null) {
                        nextTab.setSelected(true);
                    } else {
                        tabs[0].setSelected(true);
                    }
                } else {
                    ToolWindowTabPanel.this.selectedTab = null;
                    ToolWindowTabPanel.this.selecTabButton = null;
                }
            }
            ToolWindowTabPanel.this.checkPopupButton();
        }
    }
}

