/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.TranslucentComponent;
import org.noos.xing.mydoggy.plaf.ui.cmp.TranslucentRepaintManager;

public class TranslucentPanel
extends JPanel
implements TranslucentComponent {
    private float alpha = 1.0f;
    private boolean oldOpaque;

    public TranslucentPanel() {
    }

    public TranslucentPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public TranslucentPanel(LayoutManager layout) {
        super(layout);
    }

    public TranslucentPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComp = g2d.getComposite();
        float alpha = this.getAlphaModeEnabled();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, alpha);
        g2d.setComposite(alphaComp);
        super.paint(g2d);
        g2d.setComposite(oldComp);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComp = g2d.getComposite();
        float alpha = this.getAlphaModeEnabled();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, alpha);
        g2d.setComposite(alphaComp);
        super.paintComponent(g2d);
        g2d.setComposite(oldComp);
    }

    public void setAlphaModeRatio(float alpha) {
        if (this.alpha != alpha) {
            assert (alpha >= 0.0f && (double)alpha <= 1.0);
            float oldAlpha = this.alpha;
            this.alpha = alpha;
            if (alpha > 0.0f && alpha < 1.0f) {
                RepaintManager manager;
                if (oldAlpha == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
                if (!((manager = RepaintManager.currentManager(this)) instanceof TranslucentRepaintManager)) {
                    RepaintManager.setCurrentManager(new TranslucentRepaintManager());
                }
            } else if (alpha == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", oldAlpha, alpha);
            this.repaint();
        }
    }

    public float getAlphaModeEnabled() {
        return this.alpha;
    }
}

