/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.content;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.DesktopContentUI;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyContentManagerUI;

public class MyDoggyDesktopContentUI
extends PropertyChangeEventSource
implements DesktopContentUI {
    protected ContentManager contentManager;
    protected MyDoggyContentManagerUI contentManagerUI;
    protected JInternalFrame internalFrame;
    protected Content content;
    protected boolean closable;
    protected boolean detachable;
    protected boolean transparentMode;
    protected float transparentRatio;
    protected int transparentDelay;
    protected Rectangle detachedBounds;
    protected boolean addToTaskBar;
    protected boolean minimizable;

    public MyDoggyDesktopContentUI(ContentManager contentManager, MyDoggyContentManagerUI contentManagerUI, Content content) {
        this.contentManager = contentManager;
        this.contentManagerUI = contentManagerUI;
        this.content = content;
        this.closable = contentManagerUI.isCloseable();
        this.detachable = contentManagerUI.isDetachable();
        this.minimizable = contentManagerUI.isMinimizable();
        this.transparentMode = true;
        this.transparentRatio = 0.7f;
        this.transparentDelay = 0;
        this.addToTaskBar = false;
        this.initInternalFrame();
    }

    public Content getContent() {
        return this.content;
    }

    public boolean isCloseable() {
        return this.closable;
    }

    public void setCloseable(boolean closable) {
        if (this.closable == closable) {
            return;
        }
        boolean old = this.closable;
        this.closable = closable;
        this.internalFrame.setClosable(closable);
        this.firePropertyChangeEvent("closable", old, closable);
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public void setDetachable(boolean detachable) {
        if (this.detachable == detachable) {
            return;
        }
        boolean old = this.detachable;
        this.detachable = detachable;
        this.firePropertyChangeEvent("detachable", old, detachable);
    }

    public boolean isMinimizable() {
        return this.minimizable;
    }

    public void setMinimizable(boolean minimizable) {
        if (this.minimizable == minimizable) {
            return;
        }
        boolean old = this.minimizable;
        this.minimizable = minimizable;
        this.internalFrame.setMaximizable(minimizable);
        this.firePropertyChangeEvent("minimizable", old, minimizable);
    }

    public boolean isTransparentMode() {
        return this.transparentMode;
    }

    public void setTransparentMode(boolean transparentMode) {
        if (this.transparentMode == transparentMode) {
            return;
        }
        boolean old = this.transparentMode;
        this.transparentMode = transparentMode;
        this.firePropertyChangeEvent("transparentMode", old, transparentMode);
    }

    public float getTransparentRatio() {
        return this.transparentRatio;
    }

    public void setTransparentRatio(float transparentRatio) {
        if (this.transparentRatio == transparentRatio) {
            return;
        }
        float old = this.transparentRatio;
        this.transparentRatio = transparentRatio;
        this.firePropertyChangeEvent("transparentRatio", Float.valueOf(old), Float.valueOf(transparentRatio));
    }

    public int getTransparentDelay() {
        return this.transparentDelay;
    }

    public void setTransparentDelay(int transparentDelay) {
        if (this.transparentDelay == transparentDelay) {
            return;
        }
        int old = this.transparentDelay;
        this.transparentDelay = transparentDelay;
        this.firePropertyChangeEvent("transparentDelay", old, transparentDelay);
    }

    public void setConstraints(Object ... constraints) {
        if (constraints.length > 0) {
            if (constraints[0] instanceof Point) {
                this.internalFrame.setLocation((Point)constraints[0]);
            } else if (constraints[0] instanceof Rectangle) {
                this.internalFrame.setBounds((Rectangle)constraints[0]);
            }
        }
    }

    public Rectangle getDetachedBounds() {
        return this.detachedBounds;
    }

    public void setDetachedBounds(Rectangle detachedBounds) {
        if (this.detachedBounds != null && this.detachedBounds.equals(detachedBounds) || detachedBounds == null) {
            return;
        }
        this.detachedBounds = detachedBounds;
        this.firePropertyChangeEvent("detachedBounds", null, detachedBounds);
    }

    public void setAddToTaskBarWhenDetached(boolean addToTaskBar) {
        if (this.addToTaskBar == addToTaskBar) {
            return;
        }
        boolean old = this.addToTaskBar;
        this.addToTaskBar = addToTaskBar;
        this.firePropertyChangeEvent("addToTaskBar", old, addToTaskBar);
    }

    public boolean isAddToTaskBarWhenDetached() {
        return this.addToTaskBar;
    }

    public void setLocation(int x, int y) {
        Point location;
        Point old = this.internalFrame.getLocation();
        if (old.equals(location = new Point(x, y))) {
            return;
        }
        this.internalFrame.setLocation(location);
        this.firePropertyChangeEvent("location", old, location);
    }

    public Point getLocation() {
        return this.internalFrame.getLocation();
    }

    public void setSize(int width, int height) {
        Dimension size;
        Dimension old = this.internalFrame.getSize();
        if (old.equals(size = new Dimension(width, height))) {
            return;
        }
        this.internalFrame.setSize(size);
        this.firePropertyChangeEvent("size", old, size);
    }

    public Dimension getSize() {
        return this.internalFrame.getSize();
    }

    public boolean isIconified() {
        return this.internalFrame.isIcon();
    }

    public void setIconified(boolean iconified) {
        boolean old = this.internalFrame.isIcon();
        if (old == iconified) {
            return;
        }
        try {
            this.internalFrame.setIcon(iconified);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        this.firePropertyChangeEvent("iconified", old, iconified);
    }

    public void cleanup() {
        super.cleanup();
        this.content = null;
        this.contentManager = null;
        this.contentManagerUI = null;
    }

    public JInternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    protected void initInternalFrame() {
        this.internalFrame = new JInternalFrame(this.content.getTitle(), true, true, true, true);
        this.internalFrame.setFrameIcon(this.content.getIcon());
        this.internalFrame.getContentPane().add(this.content.getComponent());
        this.internalFrame.setClosable(this.closable);
        this.internalFrame.setMaximizable(true);
        this.initInternalFrameListeners();
    }

    protected void initInternalFrameListeners() {
        this.internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                MyDoggyDesktopContentUI.this.contentManager.removeContent(MyDoggyDesktopContentUI.this.content);
            }
        });
        this.internalFrame.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue()) && !MyDoggyDesktopContentUI.this.contentManagerUI.fireContentUIRemoving(MyDoggyDesktopContentUI.this.content.getContentUI())) {
                    throw new PropertyVetoException("Cannot remove.", evt);
                }
            }
        });
        this.internalFrame.addPropertyChangeListener("selected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ContentUI contentUI;
                if (!MyDoggyDesktopContentUI.this.contentManagerUI.valueAdjusting && !MyDoggyDesktopContentUI.this.contentManagerUI.contentValueAdjusting && (contentUI = MyDoggyDesktopContentUI.this.content.getContentUI()) != null) {
                    Content content = contentUI.getContent();
                    if (content == null) {
                        return;
                    }
                    boolean value = (Boolean)evt.getNewValue();
                    if (value) {
                        if (MyDoggyDesktopContentUI.this.contentManagerUI.lastSelected != null && MyDoggyDesktopContentUI.this.contentManagerUI.lastSelected.isDetached()) {
                            MyDoggyDesktopContentUI.this.contentManagerUI.lastSelected.setSelected(false);
                        }
                        content.setSelected(true);
                        MyDoggyDesktopContentUI.this.contentManagerUI.lastSelected = content;
                    } else {
                        content.setSelected(false);
                    }
                }
            }
        });
    }
}

