/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.plaf.PanelUI;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowTab;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGestureAdapter;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGestureInitiator;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.MutableColor;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowTitleBarUI
extends PanelUI
implements Cleaner {
    protected ToolWindow toolWindow;
    protected ToolWindowDescriptor descriptor;
    protected ResourceManager resourceManager;
    protected MutableColor animBackStart;
    protected MutableColor animBackEnd;
    protected MutableColor animTextColor;
    protected JComponent panel;
    protected GradientAnimation animation;
    protected Timer flashingTimer;
    protected int flasingDuration;
    protected boolean flashingState;
    protected AbstractAnimation flashingAnimation;

    public ToolWindowTitleBarUI(ToolWindowDescriptor descriptor, ToolWindowContainer dockedContainer) {
        this.descriptor = descriptor;
        this.toolWindow = descriptor.getToolWindow();
        this.resourceManager = descriptor.getResourceManager();
        dockedContainer.addPropertyChangeListener("active", new GradientActivationListener(descriptor));
        this.animBackStart = new MutableColor(this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_START"));
        this.animBackEnd = new MutableColor(0, 0, 0);
        this.animTextColor = new MutableColor(0, 0, 0);
        this.flashingAnimation = new GradientAnimation(700.0f);
        this.flasingDuration = -1;
        this.animation = new GradientAnimation();
        descriptor.getToolWindow().addPlafPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if ("flash".equals(propertyName)) {
                    if (e.getNewValue() == Boolean.TRUE) {
                        if (ToolWindowTitleBarUI.this.toolWindow.isVisible()) {
                            ToolWindowTitleBarUI.this.flasingDuration = -1;
                            SwingUtil.repaint(ToolWindowTitleBarUI.this.panel);
                        }
                    } else if (ToolWindowTitleBarUI.this.flashingTimer != null) {
                        ToolWindowTitleBarUI.this.flashingTimer.stop();
                        ToolWindowTitleBarUI.this.flashingTimer = null;
                        SwingUtil.repaint(ToolWindowTitleBarUI.this.panel);
                    }
                } else if ("flash.duration".equals(propertyName)) {
                    if (e.getNewValue() == Boolean.TRUE) {
                        if (ToolWindowTitleBarUI.this.toolWindow.isVisible()) {
                            ToolWindowTitleBarUI.this.flasingDuration = (Integer)e.getNewValue();
                            SwingUtil.repaint(ToolWindowTitleBarUI.this.panel);
                        }
                    } else if (ToolWindowTitleBarUI.this.flashingTimer != null) {
                        ToolWindowTitleBarUI.this.flashingTimer.stop();
                        ToolWindowTitleBarUI.this.flashingTimer = null;
                        SwingUtil.repaint(ToolWindowTitleBarUI.this.panel);
                    }
                } else if ("active".equals(propertyName)) {
                    ToolWindowTitleBarUI.this.toolWindow.setFlashing(false);
                }
            }
        });
        descriptor.getCleaner().addCleaner(this);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults(c);
        this.panel = c;
        final ToolWindowTitleBarDragGesture dragGesture = new ToolWindowTitleBarDragGesture(this.descriptor);
        SwingUtil.registerDragGesture(c, dragGesture);
        this.panel.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof DragGestureInitiator) {
                    DragGestureInitiator dragGestureInitiator = (DragGestureInitiator)((Object)e.getChild());
                    dragGestureInitiator.setDragGesture(dragGesture);
                }
            }
        });
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults(c);
        this.cleanup();
    }

    public void cleanup() {
        this.flashingAnimation.stop();
        this.animation.stop();
        if (this.flashingTimer != null) {
            this.flashingTimer.stop();
        }
        this.flashingTimer = null;
        this.toolWindow = null;
        this.descriptor = null;
        this.resourceManager = null;
    }

    public void update(Graphics g, JComponent c) {
        Rectangle r = c.getBounds();
        r.y = 0;
        r.x = 0;
        if (this.toolWindow.isFlashing()) {
            if (this.flashingState) {
                this.updateToolWindowTitleBar(g, c, this.animBackStart, this.animBackEnd, this.resourceManager.getColor("TWTB_ID_BACKGROUND_FLASHING_0"), this.animTextColor);
            } else {
                this.updateToolWindowTitleBar(g, c, this.animBackStart, this.animBackEnd, this.resourceManager.getColor("TWTB_ID_BACKGROUND_FLASHING_1"), this.animTextColor);
            }
            if (this.flashingTimer == null) {
                this.flashingTimer = new Timer(700, new ActionListener(){
                    long start = 0L;

                    public void actionPerformed(ActionEvent e) {
                        if (this.start == 0L) {
                            this.start = System.currentTimeMillis();
                        }
                        boolean bl = ToolWindowTitleBarUI.this.flashingState = !ToolWindowTitleBarUI.this.flashingState;
                        if (ToolWindowTitleBarUI.this.flashingAnimation.isAnimating()) {
                            ToolWindowTitleBarUI.this.flashingAnimation.stop();
                        }
                        if (ToolWindowTitleBarUI.this.flashingState) {
                            ToolWindowTitleBarUI.this.flashingAnimation.show(new Object[0]);
                        } else {
                            ToolWindowTitleBarUI.this.flashingAnimation.hide(new Object[0]);
                        }
                        if (ToolWindowTitleBarUI.this.flasingDuration != -1 && System.currentTimeMillis() - this.start > (long)ToolWindowTitleBarUI.this.flasingDuration) {
                            ToolWindowTitleBarUI.this.toolWindow.setFlashing(false);
                        }
                    }
                });
                this.flashingState = true;
                this.flashingAnimation.show(new Object[0]);
            }
            if (!this.flashingTimer.isRunning()) {
                this.flashingTimer.start();
            }
        } else if (this.animation.isAnimating()) {
            this.updateToolWindowTitleBar(g, c, this.animBackStart, this.animBackEnd, this.resourceManager.getColor("TWTB_ID_BACKGROUND_ANIMATING"), this.animTextColor);
        } else if (c.isEnabled()) {
            this.updateToolWindowTitleBar(g, c, this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"), this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_END"), this.resourceManager.getColor("TWTB_ID_BACKGROUND_ACTIVE"), this.resourceManager.getColor("TWTB_ID_FOREGROUND_ACTIVE"));
        } else {
            this.updateToolWindowTitleBar(g, c, this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_START"), this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_END"), this.resourceManager.getColor("TWTB_ID_BACKGROUND_INACTIVE"), this.resourceManager.getColor("TWTB_ID_FOREGROUND_INACTIVE"));
        }
        this.paint(g, c);
    }

    protected void installDefaults(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "Panel.background", "Panel.foreground", "Panel.font");
        LookAndFeel.installBorder(c, "Panel.border");
    }

    protected void uninstallDefaults(JComponent c) {
        LookAndFeel.uninstallBorder(c);
    }

    protected void updateToolWindowTitleBar(Graphics g, JComponent c, Color backgroundStart, Color backgroundEnd, Color idBackgroundColor, Color idColor) {
        Rectangle r = c.getBounds();
        r.y = 0;
        r.x = 0;
        GraphicsUtil.fillRect(g, r, backgroundStart, backgroundEnd, null, 5);
        if (this.descriptor.isIdVisibleOnTitleBar()) {
            String id = this.resourceManager.getUserString(this.descriptor.getToolWindow().getId());
            r.width = g.getFontMetrics().stringWidth(id) + 8;
            int halfHeigh = r.height / 2;
            GraphicsUtil.fillRect(g, r, Color.WHITE, idBackgroundColor, new Polygon(new int[]{r.x, r.x + r.width - halfHeigh, r.x + r.width - halfHeigh, r.x}, new int[]{r.y, r.y, r.y + r.height, r.y + r.height}, 4), 5);
            GraphicsUtil.fillRect(g, r, Color.WHITE, idBackgroundColor, new Arc2D.Double(r.x + r.width - r.height, r.y, r.height, r.height, -90.0, 180.0, 1), 5);
            g.setColor(idColor);
            g.drawString(id, r.x + 2, r.y + (r.height - g.getFontMetrics().getHeight()) / 2 + g.getFontMetrics().getAscent());
        }
    }

    protected class ToolWindowTitleBarDragGesture
    extends DragGestureAdapter {
        protected JComponent lastOverCmp;
        protected Border oldBorder;
        protected LineBorder highligthBorder;
        protected boolean moveAnchor;
        protected ToolWindowAnchor lastAnchor;

        public ToolWindowTitleBarDragGesture(ToolWindowDescriptor descriptor) {
            super(descriptor);
            this.lastOverCmp = null;
            this.oldBorder = null;
            this.highligthBorder = new LineBorder(Color.BLUE, 3);
            descriptor.getCleaner().addCleaner(this);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            if (ToolWindowTitleBarUI.this.toolWindow.getType() == ToolWindowType.FLOATING || ToolWindowTitleBarUI.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE || ToolWindowTitleBarUI.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                return;
            }
            if (!this.acquireLocks()) {
                return;
            }
            MyDoggyToolWindowTab toolWindowTab = null;
            if (SwingUtilities.isDescendingFrom(dge.getComponent(), ToolWindowTitleBarUI.this.panel)) {
                toolWindowTab = (MyDoggyToolWindowTab)SwingUtil.getParentClientProperty(dge.getComponent(), ToolWindowTab.class);
            }
            if (toolWindowTab != null && toolWindowTab.getDockableDelegator() != null) {
                MyDoggyTransferable transferable = new MyDoggyTransferable(this.manager);
                transferable.addEntry(MyDoggyTransferable.TOOL_WINDOW_ID_DF, toolWindowTab.getDockableDelegator().getId());
                transferable.addEntry(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF, toolWindowTab.getId());
                dge.startDrag(Cursor.getDefaultCursor(), transferable, this);
            } else {
                dge.startDrag(Cursor.getDefaultCursor(), new MyDoggyTransferable(this.manager, MyDoggyTransferable.TOOL_WINDOW_ID_DF, ToolWindowTitleBarUI.this.toolWindow.getId()), this);
            }
            if (!this.descriptor.isDragImageAvailable() || ToolWindowTitleBarUI.this.resourceManager.getBoolean("drag.icon.useDefault", false)) {
                this.setGhostImage(dge.getDragOrigin(), ToolWindowTitleBarUI.this.resourceManager.getBufferedImage("DRAG"));
            } else {
                Component contentContainer = this.descriptor.getComponentForDragImage();
                BufferedImage ghostImage = new BufferedImage(contentContainer.getWidth(), contentContainer.getHeight(), 1);
                contentContainer.print(ghostImage.getGraphics());
                ghostImage = GraphicsUtil.scale(ghostImage, contentContainer.getWidth() / 3, contentContainer.getHeight() / 3);
                this.setGhostImage(dge.getDragOrigin(), ghostImage);
            }
            this.lastAnchor = null;
        }

        public void dragMouseMoved(DragSourceDragEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            ToolWindowAnchor newAnchor = this.manager.getToolWindowAnchor(SwingUtil.convertPointFromScreen(dsde.getLocation(), this.manager));
            if (newAnchor != this.lastAnchor) {
                if (newAnchor == null) {
                    this.manager.getBar(this.lastAnchor).setTempShowed(false);
                } else if (this.manager.getBar(newAnchor).getAvailableTools() == 0) {
                    this.manager.getBar(newAnchor).setTempShowed(true);
                }
                this.lastAnchor = newAnchor;
            }
            this.updateGhostImage(dsde.getLocation());
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.releaseLocks();
            this.manager.setTempShowed(false);
            this.cleanupGhostImage();
        }
    }

    protected class GradientAnimation
    extends AbstractAnimation {
        public GradientAnimation() {
            super(300.0f);
        }

        protected GradientAnimation(float animationDuration) {
            super(animationDuration);
        }

        protected float onAnimating(float animationPercent) {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animBackStart, ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"), ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_START"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animBackEnd, ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_END"), ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_END"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animTextColor, ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_ID_FOREGROUND_ACTIVE"), ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_ID_FOREGROUND_INACTIVE"), animationPercent);
                    break;
                }
                case OUTGOING: {
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animBackStart, ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_START"), ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animBackEnd, ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_END"), ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_END"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animTextColor, ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_ID_FOREGROUND_INACTIVE"), ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_ID_FOREGROUND_ACTIVE"), animationPercent);
                }
            }
            SwingUtil.repaint(ToolWindowTitleBarUI.this.panel);
            return animationPercent;
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    ToolWindowTitleBarUI.this.animBackStart.setRGB(ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"));
                    break;
                }
                case OUTGOING: {
                    ToolWindowTitleBarUI.this.animBackStart.setRGB(ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_START"));
                }
            }
            SwingUtil.repaint(ToolWindowTitleBarUI.this.panel);
        }

        protected void onHide(Object ... params) {
            ToolWindowTitleBarUI.this.animBackStart.setRGB(ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"));
            ToolWindowTitleBarUI.this.animBackEnd.setRGB(ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_END"));
        }

        protected void onShow(Object ... params) {
            ToolWindowTitleBarUI.this.animBackStart.setRGB(ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_START"));
            ToolWindowTitleBarUI.this.animBackEnd.setRGB(ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_END"));
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
        }
    }

    protected class GradientActivationListener
    implements PropertyChangeListener {
        public static final float ANIMATION_DURATION = 80.0f;
        public static final int ANIMATION_SLEEP = 10;
        protected ToolWindowDescriptor descriptor;

        public GradientActivationListener(ToolWindowDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != this.descriptor || !this.descriptor.getToolWindow().isVisible()) {
                return;
            }
            assert (evt.getPropertyName() != null);
            assert (this.descriptor.getToolWindow().isVisible());
            if ("active".equals(evt.getPropertyName())) {
                if (evt.getNewValue() == Boolean.FALSE) {
                    if (ToolWindowTitleBarUI.this.animBackStart.equals(ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_ACTIVE_START"))) {
                        ToolWindowTitleBarUI.this.animation.hide(new Object[0]);
                    }
                } else if (ToolWindowTitleBarUI.this.animBackStart.equals(ToolWindowTitleBarUI.this.resourceManager.getColor("TWTB_BACKGROUND_INACTIVE_START"))) {
                    ToolWindowTitleBarUI.this.animation.show(new Object[0]);
                }
            }
        }
    }
}

