/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.Boot;
import jade.BootException;
import jade.PropertyType;
import jade.gui.TreeHelp;
import jade.util.BasicProperties;
import jade.util.ExpandedProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class BootGUI
extends JDialog {
    static String EXTENSION = "conf";
    static String TITLE = "--JADE Properties--";
    Vector propertiesVector = null;
    File currentDir = null;
    JTextField statusField = new JTextField();
    JPanel topPanel = new JPanel();
    JPanel propertyPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    String propertyFileName = null;
    BasicProperties outProp = null;
    BootGUI thisBootGui = this;
    Boot booter;

    public BootGUI(Boot theBooter) {
        this.booter = theBooter;
        this.propertiesVector = this.createPropertyVector(this.booter.getProperties());
        this.setTitle("JADE Configurator");
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(raisedbevel);
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.propertyPanel.setLayout(new BoxLayout(this.propertyPanel, 1));
        Enumeration it = this.propertiesVector.elements();
        while (it.hasMoreElements()) {
            singlePanel propPanel = new singlePanel();
            PropertyType p = (PropertyType)it.nextElement();
            JPanel panel = propPanel.newSinglePanel(p);
            this.propertyPanel.add(panel);
        }
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        this.statusField.setEditable(false);
        this.statusField.setFont(new Font("Monospaced", 0, 12));
        this.statusField.setPreferredSize(new Dimension(600, 50));
        this.statusField.setMinimumSize(new Dimension(50, 50));
        statusPanel.add((Component)this.statusField, "Center");
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        JButton openB = new JButton("Open File");
        openB.setToolTipText("Read configuration from file");
        openB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                block5: {
                    int returnVal;
                    String param = e.getActionCommand();
                    if (!param.equals("Open File")) break block5;
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileFilter(new myFileFilter());
                    if (BootGUI.this.currentDir != null) {
                        chooser.setCurrentDirectory(BootGUI.this.currentDir);
                    }
                    if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                        BootGUI.this.currentDir = chooser.getCurrentDirectory();
                        String fileName = chooser.getSelectedFile().getAbsolutePath();
                        try {
                            BootGUI.this.loadPropertiesFromFile(fileName);
                            BootGUI.this.propertyFileName = fileName;
                            BootGUI.this.updateProperties();
                        }
                        catch (FileNotFoundException fe) {
                            System.out.println("File not found Exception");
                        }
                        catch (IOException ioe) {
                            System.out.println("IO Exception");
                        }
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.buttonPanel.add(openB);
        JButton saveB = new JButton("Save File");
        saveB.setToolTipText("Save configuration into a file");
        saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                block7: {
                    String param = e.getActionCommand();
                    if (!param.equals("Save File")) break block7;
                    BasicProperties propToSave = BootGUI.this.extractPropertiesFromGui();
                    try {
                        int returnVal;
                        BootGUI.this.booter.setProperties(propToSave);
                        propToSave = BootGUI.this.booter.getProperties();
                        JFileChooser chooser = new JFileChooser();
                        chooser.setFileFilter(new myFileFilter());
                        if (BootGUI.this.currentDir != null) {
                            chooser.setCurrentDirectory(BootGUI.this.currentDir);
                        }
                        if ((returnVal = chooser.showSaveDialog(null)) != 0) break block7;
                        BootGUI.this.currentDir = chooser.getCurrentDirectory();
                        String fileName = chooser.getSelectedFile().getAbsolutePath();
                        boolean ext = BootGUI.this.hasExtension(fileName);
                        if (!ext) {
                            fileName = fileName.concat(".conf");
                        }
                        BootGUI.this.propertyFileName = fileName;
                        try {
                            FileOutputStream out = new FileOutputStream(fileName);
                            propToSave.put("conf", (Object)"false");
                            propToSave.store(out, TITLE);
                            out.close();
                            BootGUI.this.outProp = propToSave;
                        }
                        catch (FileNotFoundException e1) {
                            System.out.println("File not found Exception");
                        }
                        catch (IOException e2) {
                            System.out.println("IO exception");
                        }
                    }
                    catch (BootException be) {
                        BootGUI.this.statusField.setText(be.getMessage());
                    }
                }
            }
        });
        this.buttonPanel.add(saveB);
        JButton runB = new JButton("Run");
        runB.setToolTipText("Launch the system");
        runB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                block14: {
                    String param = e.getActionCommand();
                    if (!param.equals("Run")) break block14;
                    BasicProperties propToSave = BootGUI.this.extractPropertiesFromGui();
                    try {
                        BootGUI.this.booter.setProperties(propToSave);
                        propToSave = BootGUI.this.booter.getProperties();
                        boolean different = false;
                        if (BootGUI.this.propertyFileName != null) {
                            BasicProperties p = BootGUI.this.readPropertiesFromFile(BootGUI.this.propertyFileName);
                            different = BootGUI.this.compareProperties(propToSave, p);
                        }
                        if (different || BootGUI.this.propertyFileName == null) {
                            int val = JOptionPane.showConfirmDialog(BootGUI.this.topPanel, "Save this configuration?", "JADE Configurator", 1);
                            if (val == 2) {
                                return;
                            }
                            if (val == 0) {
                                int returnVal;
                                JFileChooser chooser = new JFileChooser();
                                chooser.setFileFilter(new myFileFilter());
                                if (BootGUI.this.currentDir != null) {
                                    chooser.setCurrentDirectory(BootGUI.this.currentDir);
                                }
                                if ((returnVal = chooser.showSaveDialog(null)) == 0) {
                                    BootGUI.this.currentDir = chooser.getCurrentDirectory();
                                    String fileName = chooser.getSelectedFile().getAbsolutePath();
                                    boolean ext = BootGUI.this.hasExtension(fileName);
                                    if (!ext) {
                                        fileName = fileName.concat(".conf");
                                    }
                                    try {
                                        FileOutputStream out = new FileOutputStream(fileName);
                                        propToSave.store(out, TITLE);
                                        out.close();
                                    }
                                    catch (FileNotFoundException e1) {
                                        System.out.println("File not found exception");
                                    }
                                    catch (IOException e2) {
                                        System.out.println("IO exception");
                                    }
                                }
                            }
                        }
                        BootGUI.this.outProp = propToSave;
                        BootGUI.this.dispose();
                    }
                    catch (BootException be) {
                        BootGUI.this.statusField.setText(be.getMessage());
                    }
                    catch (FileNotFoundException e1) {
                        System.out.println("File not found");
                    }
                    catch (IOException e2) {
                        System.out.println("Io Exception");
                    }
                }
            }
        });
        this.buttonPanel.add(runB);
        JButton exitB = new JButton("Exit");
        exitB.setToolTipText("Exit without executing");
        exitB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String param = e.getActionCommand();
                if (param.equals("Exit")) {
                    System.exit(0);
                }
            }
        });
        this.buttonPanel.add(exitB);
        JButton helpB = new JButton("Help");
        helpB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String param = e.getActionCommand();
                if (param.equals("Help")) {
                    TreeHelp help = new TreeHelp((Dialog)BootGUI.this.thisBootGui, "Boot Help", "help/BOOTGUI.html");
                    help.setVisible(true);
                    help.requestFocus();
                }
            }
        });
        this.buttonPanel.add(helpB);
        this.topPanel.add(this.buttonPanel);
        this.topPanel.add(this.propertyPanel);
        mainPanel.add(this.topPanel);
        mainPanel.add(statusPanel);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setResizable(false);
        this.setModal(true);
        this.ShowCorrect();
    }

    BasicProperties extractPropertiesFromGui() {
        BasicProperties out = new BasicProperties();
        int size = this.propertyPanel.getComponentCount();
        Enumeration it = this.propertiesVector.elements();
        while (it.hasMoreElements()) {
            PropertyType prop = (PropertyType)it.nextElement();
            String name = prop.getName();
            String type = prop.getType();
            String defaultVal = prop.getDefaultValue();
            boolean found = false;
            int i = 0;
            while (i < size && !found) {
                JPanel singlePanel2 = (JPanel)this.propertyPanel.getComponent(i);
                JLabel label = (JLabel)singlePanel2.getComponent(0);
                if (name.equalsIgnoreCase(label.getText())) {
                    JComponent box;
                    found = true;
                    if (type.equalsIgnoreCase(PropertyType.COMBO_TYPE)) {
                        box = (JComboBox)singlePanel2.getComponent(1);
                        out.setProperty(name.toLowerCase(), ((JComboBox)box).getSelectedItem().toString());
                    } else if (type.equalsIgnoreCase(PropertyType.BOOLEAN_TYPE)) {
                        box = (JCheckBox)singlePanel2.getComponent(1);
                        out.setProperty(name.toLowerCase(), new Boolean(((AbstractButton)box).isSelected()).toString());
                    } else {
                        JTextField textField = (JTextField)singlePanel2.getComponent(1);
                        String text = textField.getText();
                        if (text.length() == 0) {
                            text = defaultVal;
                        }
                        out.setProperty(name.toLowerCase(), text);
                    }
                }
                ++i;
            }
        }
        return out;
    }

    boolean compareProperties(BasicProperties p1, BasicProperties p2) {
        Enumeration<Object> keys = p1.keys();
        boolean modified = false;
        while (keys.hasMoreElements() && !modified) {
            String k1 = (String)keys.nextElement();
            String v1 = p1.getProperty(k1);
            String v2 = p2.getProperty(k1);
            if (v1 == null) {
                modified = v2 != null;
                continue;
            }
            boolean bl = modified = !v1.equalsIgnoreCase(v2);
        }
        return modified;
    }

    void updateProperties() {
        int size = this.propertyPanel.getComponentCount();
        Enumeration it = this.propertiesVector.elements();
        while (it.hasMoreElements()) {
            PropertyType prop = (PropertyType)it.nextElement();
            String name = prop.getName();
            String type = prop.getType();
            String newValue = prop.getDefaultValue();
            boolean found = false;
            int i = 0;
            while (i < size && !found) {
                JPanel singlePanel2 = (JPanel)this.propertyPanel.getComponent(i);
                JLabel label = (JLabel)singlePanel2.getComponent(0);
                if (name.equalsIgnoreCase(label.getText())) {
                    found = true;
                    if (type.equalsIgnoreCase(PropertyType.BOOLEAN_TYPE)) {
                        JCheckBox box = (JCheckBox)singlePanel2.getComponent(1);
                        box.setSelected(newValue.equalsIgnoreCase("true"));
                    } else {
                        JTextField textField = (JTextField)singlePanel2.getComponent(1);
                        textField.setText(newValue);
                    }
                }
                ++i;
            }
        }
    }

    void ShowCorrect() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = this.getPreferredSize();
        int x = (screenSize.width - mySize.width) / 2;
        int y = (screenSize.height - mySize.height) / 2;
        this.setBounds(x, y, mySize.width, mySize.height);
        this.setResizable(true);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    void loadPropertiesFromFile(String fileName) throws FileNotFoundException, IOException {
        BasicProperties p = this.readPropertiesFromFile(fileName);
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            boolean found = false;
            String name = (String)e.nextElement();
            Enumeration it = this.propertiesVector.elements();
            while (it.hasMoreElements() && !found) {
                PropertyType pt = (PropertyType)it.nextElement();
                if (!pt.getName().equalsIgnoreCase(name)) continue;
                found = true;
                pt.setDefaultValue(p.getProperty(name));
            }
        }
    }

    BasicProperties readPropertiesFromFile(String fileName) throws FileNotFoundException, IOException {
        ExpandedProperties p = new ExpandedProperties();
        FileInputStream in = new FileInputStream(fileName);
        p.load(in);
        in.close();
        return p;
    }

    boolean hasExtension(String fileName) {
        String ext = null;
        boolean out = false;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1);
        }
        if (ext != null && ext.equalsIgnoreCase("conf")) {
            out = true;
        }
        return out;
    }

    Vector createPropertyVector(BasicProperties theProperties) {
        Vector<PropertyType> pv = new Vector<PropertyType>();
        String[] loginEnum = new String[]{"Simple", "Unix", "NT", "Kerberos"};
        pv.add(new PropertyType("auth", PropertyType.COMBO_TYPE, loginEnum, theProperties.getProperty("auth"), "User Authentication context", false));
        pv.add(new PropertyType("host", PropertyType.STRING_TYPE, theProperties.getProperty("host"), "Host Name of the main-container", false));
        pv.add(new PropertyType("gui", PropertyType.BOOLEAN_TYPE, new Boolean(theProperties.getBooleanProperty("gui", false)).toString(), "Select to launch the RMA Gui", false));
        pv.add(new PropertyType("port", PropertyType.STRING_TYPE, new Integer(theProperties.getIntProperty("port", 1099)).toString(), "Port Number of the main-container", false));
        pv.add(new PropertyType("name", PropertyType.STRING_TYPE, theProperties.getProperty("name"), "The symbolic plaform name", false));
        pv.add(new PropertyType("container", PropertyType.BOOLEAN_TYPE, new Boolean(theProperties.getBooleanProperty("container", false)).toString(), "Select to launch an agent-container", false));
        pv.add(new PropertyType("mtp", PropertyType.STRING_TYPE, theProperties.getProperty("mtp"), "List of MTPs to activate", false));
        pv.add(new PropertyType("nomtp", PropertyType.BOOLEAN_TYPE, new Boolean(theProperties.getBooleanProperty("nomtp", false)).toString(), "Disable all external MTPs on this container", false));
        pv.add(new PropertyType("aclcodec", PropertyType.STRING_TYPE, theProperties.getProperty("aclcodec"), "List of ACLCodec to install", false));
        pv.add(new PropertyType("agents", PropertyType.STRING_TYPE, theProperties.getProperty("agents"), "Agents to launch", false));
        pv.add(new PropertyType("nomobility", PropertyType.BOOLEAN_TYPE, new Boolean(theProperties.getBooleanProperty("nomobility", false)).toString(), "Disable Mobility", false));
        return pv;
    }

    class myFileFilter
    extends FileFilter {
        myFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = this.getExtension(f);
            if (ext != null) {
                return ext.equals(EXTENSION);
            }
            return false;
        }

        public String getDescription() {
            return "Configuration file (*." + EXTENSION + ")";
        }

        String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }

    class singlePanel
    extends JPanel {
        singlePanel() {
        }

        JPanel newSinglePanel(PropertyType property) {
            JPanel mainP = new JPanel(new FlowLayout(0));
            Border etched = BorderFactory.createEtchedBorder(Color.white, Color.gray);
            String name = property.getName();
            JLabel nameLabel = new JLabel(name.toUpperCase());
            nameLabel.setPreferredSize(new Dimension(80, 26));
            nameLabel.setMaximumSize(new Dimension(80, 26));
            nameLabel.setMinimumSize(new Dimension(80, 26));
            mainP.add(nameLabel);
            String type = property.getType();
            String value = property.getDefaultValue();
            if (type.equalsIgnoreCase(PropertyType.COMBO_TYPE)) {
                JComboBox<String> valueCombo = new JComboBox<String>(property.getComboValues());
                valueCombo.setSelectedIndex(0);
                valueCombo.setToolTipText(property.getToolTip());
                mainP.add(valueCombo);
            } else if (type.equalsIgnoreCase(PropertyType.BOOLEAN_TYPE)) {
                JCheckBox valueBox = new JCheckBox();
                valueBox.setSelected(new Boolean(value));
                valueBox.setToolTipText(property.getToolTip());
                mainP.add(valueBox);
            } else {
                JTextField valueText = new JTextField();
                valueText.setBorder(etched);
                if (type.equalsIgnoreCase(PropertyType.INTEGER_TYPE)) {
                    valueText.setPreferredSize(new Dimension(100, 26));
                    valueText.setMaximumSize(new Dimension(100, 26));
                } else {
                    valueText.setPreferredSize(new Dimension(600, 26));
                }
                valueText.setMinimumSize(new Dimension(50, 26));
                valueText.setText(value);
                valueText.setToolTipText(property.getToolTip());
                mainP.add(valueText);
            }
            return mainP;
        }
    }
}

