/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsObject;
import jade.content.onto.Introspector;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PredicateSchema;
import jade.util.Logger;
import jade.util.leap.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class Ontology
implements Serializable {
    private static final String DEFAULT_INTROSPECTOR_CLASS = "jade.content.onto.ReflectiveIntrospector";
    private Ontology[] base;
    private String name;
    private Introspector introspector;
    private Hashtable elements;
    private Hashtable classes;
    private Hashtable schemas;
    private Logger logger;
    private static Class absObjectClass = null;

    public Ontology(String name, Ontology base) {
        this(name, base, null);
        try {
            this.introspector = (Introspector)Class.forName(DEFAULT_INTROSPECTOR_CLASS).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Class jade.content.onto.ReflectiveIntrospectorfor default Introspector not found");
        }
    }

    public Ontology(String name, Introspector introspector) {
        this(name, new Ontology[0], introspector);
    }

    public Ontology(String name, Ontology base, Introspector introspector) {
        Ontology[] ontologyArray;
        if (base != null) {
            Ontology[] ontologyArray2 = new Ontology[1];
            ontologyArray = ontologyArray2;
            ontologyArray2[0] = base;
        } else {
            ontologyArray = new Ontology[]{};
        }
        this(name, ontologyArray, introspector);
    }

    public Ontology(String name, Ontology[] base, Introspector introspector) {
        this.base = new Ontology[0];
        this.name = null;
        this.introspector = null;
        this.elements = new Hashtable();
        this.classes = new Hashtable();
        this.schemas = new Hashtable();
        this.logger = Logger.getMyLogger(this.getClass().getName());
        this.name = name;
        this.introspector = introspector;
        this.base = base != null ? base : new Ontology[]{};
    }

    public String getName() {
        return this.name;
    }

    public void add(ObjectSchema schema) throws OntologyException {
        this.add(schema, null);
    }

    public void add(ObjectSchema schema, Class javaClass) throws OntologyException {
        if (schema.getTypeName() == null) {
            throw new OntologyException("Invalid schema identifier");
        }
        String s = schema.getTypeName().toLowerCase();
        this.elements.put(s, schema);
        if (javaClass != null) {
            this.classes.put(s, javaClass);
            if (!absObjectClass.isAssignableFrom(javaClass)) {
                if (this.introspector != null) {
                    this.introspector.checkClass(schema, javaClass, this);
                }
                this.schemas.put(javaClass, schema);
            } else if (!javaClass.isInstance(schema.newInstance())) {
                throw new OntologyException("Java class " + javaClass.getName() + " can't represent instances of schema " + schema);
            }
        }
    }

    public ObjectSchema getSchema(String name) throws OntologyException {
        if (name == null) {
            throw new OntologyException("Null schema identifier");
        }
        ObjectSchema ret = (ObjectSchema)this.elements.get(name.toLowerCase());
        if (ret == null) {
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema for " + name + " not found");
            }
            int i = 0;
            while (i < this.base.length) {
                if (this.base[i] == null && this.logger.isLoggable(Logger.FINE)) {
                    this.logger.log(Logger.FINE, "Base ontology # " + i + " for ontology " + this.getName() + " is null");
                }
                if ((ret = this.base[i].getSchema(name)) != null) {
                    return ret;
                }
                ++i;
            }
        }
        return ret;
    }

    public Object toObject(AbsObject abs) throws OntologyException, UngroundedException {
        if (abs == null) {
            return null;
        }
        try {
            return this.toObject(abs, abs.getTypeName().toLowerCase(), this);
        }
        catch (UnknownSchemaException use) {
            throw new OntologyException("No schema found for type " + abs.getTypeName());
        }
        catch (OntologyException oe) {
            if (!abs.isGrounded()) {
                throw new UngroundedException();
            }
            throw oe;
        }
    }

    public AbsObject fromObject(Object obj) throws OntologyException {
        if (obj == null) {
            return null;
        }
        try {
            return this.fromObject(obj, this);
        }
        catch (UnknownSchemaException use) {
            throw new OntologyException("No schema found for class " + obj.getClass().getName());
        }
    }

    public Class getClassForElement(String name) throws OntologyException {
        if (name == null) {
            throw new OntologyException("Null schema identifier");
        }
        Class ret = (Class)this.classes.get(name.toLowerCase());
        if (ret == null) {
            int i = 0;
            while (i < this.base.length) {
                ret = this.base[i].getClassForElement(name);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
        }
        return ret;
    }

    protected Object toObject(AbsObject abs, String lcType, Ontology globalOnto) throws UnknownSchemaException, UngroundedException, OntologyException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Abs is: " + abs);
        }
        ObjectSchema schema = (ObjectSchema)this.elements.get(lcType);
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema is: " + schema);
        }
        if (schema != null) {
            Class javaClass = (Class)this.classes.get(lcType);
            if (javaClass == null) {
                throw new OntologyException("No java class associated to type " + abs.getTypeName());
            }
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Class is: " + javaClass.getName());
            }
            if (absObjectClass.isAssignableFrom(javaClass)) {
                return abs;
            }
            if (this.introspector != null) {
                if (this.logger.isLoggable(Logger.FINE)) {
                    this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Try to internalise " + abs + " through " + this.introspector);
                }
                return this.introspector.internalise(abs, schema, javaClass, globalOnto);
            }
        }
        int i = 0;
        while (i < this.base.length) {
            try {
                return this.base[i].toObject(abs, lcType, globalOnto);
            }
            catch (UnknownSchemaException use) {
                ++i;
            }
        }
        throw new UnknownSchemaException();
    }

    protected AbsObject fromObject(Object obj, Ontology globalOnto) throws UnknownSchemaException, OntologyException {
        if (obj instanceof AbsObject) {
            return (AbsObject)obj;
        }
        Class<?> javaClass = obj.getClass();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Class is: " + javaClass);
        }
        ObjectSchema schema = (ObjectSchema)this.schemas.get(javaClass);
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema is: " + schema);
        }
        if (schema != null && this.introspector != null) {
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Try to externalise " + obj + " through " + this.introspector);
            }
            return this.introspector.externalise(obj, schema, javaClass, globalOnto);
        }
        int i = 0;
        while (i < this.base.length) {
            try {
                return this.base[i].fromObject(obj, globalOnto);
            }
            catch (UnknownSchemaException use) {
                ++i;
            }
        }
        throw new UnknownSchemaException();
    }

    public static void checkIsTerm(Object obj) throws OntologyException {
    }

    public String toString() {
        return this.getClass().getName() + "-" + this.name;
    }

    public List getConceptNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration e = this.elements.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!(this.elements.get(key) instanceof ConceptSchema)) continue;
            names.add(key);
        }
        return names;
    }

    public List getActionNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration e = this.elements.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!(this.elements.get(key) instanceof AgentActionSchema)) continue;
            names.add(key);
        }
        return names;
    }

    public List getPredicateNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration e = this.elements.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!(this.elements.get(key) instanceof PredicateSchema)) continue;
            names.add(key);
        }
        return names;
    }

    static {
        try {
            absObjectClass = Class.forName("jade.content.abs.AbsObject");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

