/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.MessageQueue;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import java.util.List;

class InternalMessageQueue
implements MessageQueue {
    private LinkedList list;
    private int maxSize;
    private Long persistentID;

    public InternalMessageQueue(int size) {
        this.maxSize = size;
        this.list = new LinkedList();
    }

    public InternalMessageQueue() {
        this(0);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void setMaxSize(int newSize) throws IllegalArgumentException {
        if (newSize < 0) {
            throw new IllegalArgumentException("Invalid MsgQueue size");
        }
        this.maxSize = newSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.list.size();
    }

    public void addFirst(ACLMessage msg) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeFirst();
        }
        this.list.addFirst(msg);
    }

    public void addLast(ACLMessage msg) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeFirst();
            System.err.println("WARNING: a message has been lost by an agent because of the FIFO replacement policy of its message queue.\n Notice that, under some circumstances, this might not be the proper expected behaviour and the size of the queue needs to be increased. Check the method Agent.setQueueSize()");
        }
        this.list.addLast(msg);
    }

    public ACLMessage receive(MessageTemplate pattern) {
        ACLMessage result = null;
        int cnt = 0;
        Iterator messages = this.iterator();
        while (messages.hasNext()) {
            ACLMessage msg = (ACLMessage)messages.next();
            if (pattern == null || pattern.match(msg)) {
                messages.remove();
                result = msg;
                break;
            }
            ++cnt;
        }
        return result;
    }

    private Iterator iterator() {
        return this.list.iterator();
    }

    private void setMessages(List l) {
        System.out.println(">>> MessageQueue::setMessages() <<<");
    }

    private List getMessages() {
        System.out.println(">>> MessageQueue::getMessages() <<<");
        return null;
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }

    public void copyTo(jade.util.leap.List messages) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            messages.add(i.next());
        }
    }

    Object[] getAllMessages() {
        return this.list.toArray();
    }
}

