/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Filter;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.util.leap.Iterator;
import jade.util.leap.Map;

public class IncomingEncodingFilter
extends Filter {
    private Map messageEncodings;
    private MessagingService myService;

    public IncomingEncodingFilter(Map m, MessagingService svc) {
        this.messageEncodings = m;
        this.myService = svc;
        this.setPreferredPosition(50);
    }

    public boolean accept(VerticalCommand cmd) {
        String name = cmd.getName();
        if (name.equals("Send-Message")) {
            Object[] params = cmd.getParams();
            GenericMessage gmsg = (GenericMessage)params[1];
            if (gmsg.getPayload() == null) {
                return true;
            }
            Envelope env = gmsg.getEnvelope();
            byte[] payload = gmsg.getPayload();
            try {
                ACLMessage msg = this.decodeMessage(env, payload);
                msg.setEnvelope(env);
                if (env != null) {
                    AID sender = msg.getSender();
                    if (sender == null) {
                        System.err.println("ERROR: Trying to dispatch a message with a null sender.");
                        System.err.println("Aborting send operation...");
                        return true;
                    }
                    Iterator itSender = sender.getAllAddresses();
                    if (!itSender.hasNext()) {
                        msg.setSender(env.getFrom());
                    }
                }
                ((GenericMessage)params[1]).update(msg, null, null);
            }
            catch (MessagingService.UnknownACLEncodingException ee) {
                ee.printStackTrace();
                cmd.setReturnValue(ee);
                return false;
            }
            catch (ACLCodec.CodecException ce) {
                ce.printStackTrace();
                cmd.setReturnValue(ce);
                return false;
            }
        }
        return true;
    }

    public void postProcess(VerticalCommand cmd) {
        String name = cmd.getName();
        if (name.equals("Reattached")) {
            this.myService.notifyLocalMTPs();
        }
    }

    public ACLMessage decodeMessage(Envelope env, byte[] payload) throws MessagingService.UnknownACLEncodingException, ACLCodec.CodecException {
        String enc = env != null ? env.getAclRepresentation() : LEAPACLCodec.NAME.toLowerCase();
        if (enc != null) {
            ACLCodec codec = (ACLCodec)this.messageEncodings.get(enc.toLowerCase());
            if (codec != null) {
                String charset;
                if (env == null || (charset = env.getPayloadEncoding()) == null) {
                    charset = "US-ASCII";
                }
                return codec.decode(payload, charset);
            }
            throw new MessagingService.UnknownACLEncodingException("Unknown ACL encoding: " + enc + ".");
        }
        throw new MessagingService.UnknownACLEncodingException("No ACL encoding set.");
    }
}

