/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.UnreachableException;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.OutBox;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;

class MessageManager {
    private static MessageManager theInstance;
    private static final int POOL_SIZE_DEFAULT = 5;
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_QUEUE_SIZE_DEFAULT = 10000000;
    private OutBox outBox;
    private Thread[] delivererThreads;
    private Deliverer[] deliverers;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    private MessageManager() {
    }

    public static synchronized MessageManager instance(Profile p) {
        if (theInstance == null) {
            theInstance = new MessageManager();
            theInstance.initialize(p);
        }
        return theInstance;
    }

    public void initialize(Profile p) {
        int poolSize = 5;
        try {
            String tmp = p.getParameter("jade_core_messaging_MessageManager_poolsize", null);
            poolSize = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            // empty catch block
        }
        int maxQueueSize = 10000000;
        try {
            String tmp = p.getParameter("jade_core_messaging_MessageManager_maxqueuesize", null);
            maxQueueSize = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.outBox = new OutBox(maxQueueSize);
        try {
            ResourceManager rm = p.getResourceManager();
            this.delivererThreads = new Thread[poolSize];
            this.deliverers = new Deliverer[poolSize];
            int i = 0;
            while (i < poolSize) {
                String name = "Deliverer-" + i;
                this.deliverers[i] = new Deliverer();
                this.delivererThreads[i] = rm.getThread(2, name, this.deliverers[i]);
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Starting deliverer " + name + ". Thread=" + this.delivererThreads[i]);
                }
                this.delivererThreads[i].start();
                ++i;
            }
        }
        catch (ProfileException pe) {
            throw new RuntimeException("Can't get ResourceManager. " + pe.getMessage());
        }
    }

    public void deliver(GenericMessage msg, AID receiverID, Channel ch) {
        this.outBox.addLast(receiverID, msg, ch);
    }

    public static final String stringify(GenericMessage m) {
        ACLMessage msg = m.getACLMessage();
        if (msg != null) {
            StringBuffer sb = new StringBuffer("(");
            sb.append(ACLMessage.getPerformative(msg.getPerformative()));
            sb.append(" sender: ");
            sb.append(msg.getSender().getName());
            if (msg.getOntology() != null) {
                sb.append(" ontology: ");
                sb.append(msg.getOntology());
            }
            if (msg.getConversationId() != null) {
                sb.append(" conversation-id: ");
                sb.append(msg.getConversationId());
            }
            sb.append(')');
            return sb.toString();
        }
        return "unavailable";
    }

    String[] getQueueStatus() {
        return this.outBox.getStatus();
    }

    String getGlobalInfo() {
        return "Submitted-messages = " + this.outBox.getSubmittedCnt() + ", Served-messages = " + this.outBox.getServedCnt() + ", Queue-size (byte) = " + this.outBox.getSize();
    }

    String[] getThreadPoolStatus() {
        String[] status = new String[this.delivererThreads.length];
        int i = 0;
        while (i < this.delivererThreads.length) {
            status[i] = "(Deliverer-" + i + " :alive " + this.delivererThreads[i].isAlive() + " :Served-messages " + this.deliverers[i].getServedCnt() + ")";
            ++i;
        }
        return status;
    }

    Thread[] getThreadPool() {
        return this.delivererThreads;
    }

    public static class PendingMsg {
        private final GenericMessage msg;
        private final AID receiverID;
        private final Channel channel;
        private long deadline;

        public PendingMsg(GenericMessage msg, AID receiverID, Channel channel, long deadline) {
            this.msg = msg;
            this.receiverID = receiverID;
            this.channel = channel;
            this.deadline = deadline;
        }

        public GenericMessage getMessage() {
            return this.msg;
        }

        public AID getReceiver() {
            return this.receiverID;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public long getDeadline() {
            return this.deadline;
        }

        public void setDeadline(long deadline) {
            this.deadline = deadline;
        }
    }

    class Deliverer
    implements Runnable {
        private long servedCnt = 0L;

        Deliverer() {
        }

        public void run() {
            while (true) {
                PendingMsg pm = MessageManager.this.outBox.get();
                GenericMessage msg = pm.getMessage();
                AID receiverID = pm.getReceiver();
                Channel ch = pm.getChannel();
                try {
                    ch.deliverNow(msg, receiverID);
                }
                catch (Throwable t) {
                    MessageManager.this.myLogger.log(Logger.WARNING, "MessageManager cannot deliver message " + MessageManager.stringify(msg) + " to agent " + receiverID.getName() + ". " + t);
                    ch.notifyFailureToSender(msg, receiverID, new InternalError("\"" + t + "\""));
                }
                ++this.servedCnt;
                MessageManager.this.outBox.handleServed(receiverID);
            }
        }

        long getServedCnt() {
            return this.servedCnt;
        }
    }

    public static interface Channel {
        public void deliverNow(GenericMessage var1, AID var2) throws UnreachableException, NotFoundException;

        public void notifyFailureToSender(GenericMessage var1, AID var2, InternalError var3);
    }
}

