/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp;

import jade.core.CaseInsensitiveString;
import jade.util.leap.Serializable;

public class MTPDescriptor
implements Serializable {
    private String name;
    private String className;
    private String[] addresses;
    private String[] protoNames;
    private Long persistentID;

    public MTPDescriptor(String n, String cn, String[] a, String[] pn) {
        this.name = n;
        this.className = cn;
        this.addresses = a;
        this.protoNames = pn;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public String[] getSupportedProtocols() {
        return this.protoNames;
    }

    public boolean equals(Object obj) {
        try {
            MTPDescriptor toBeCompared = (MTPDescriptor)obj;
            if (!CaseInsensitiveString.equalsIgnoreCase(this.name, toBeCompared.getName())) {
                return false;
            }
            String[] comparedAddresses = toBeCompared.getAddresses();
            if (this.addresses == null && comparedAddresses == null) {
                return true;
            }
            if (this.addresses.length != comparedAddresses.length) {
                return false;
            }
            int i = 0;
            while (i < this.addresses.length) {
                int j = 0;
                while (j < comparedAddresses.length) {
                    if (CaseInsensitiveString.equalsIgnoreCase(this.addresses[i], comparedAddresses[j])) break;
                    ++j;
                }
                if (j >= comparedAddresses.length) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "(MTP :name " + this.name + " :class-name" + this.className + " :addresses " + this.addresses + ")";
    }

    private MTPDescriptor() {
    }

    private void setName(String n) {
        this.name = n;
    }

    private void setClassName(String cn) {
        this.className = cn;
    }

    private void setAddresses(String[] a) {
        this.addresses = a;
    }

    private void setSupportedProtocols(String[] sp) {
        this.protoNames = sp;
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }
}

