/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.proto.SSResponder;

public class SSContractNetResponder
extends SSResponder {
    public final String CFP_KEY;
    public final String PROPOSE_KEY;
    public final String ACCEPT_PROPOSAL_KEY;
    public final String REJECT_PROPOSAL_KEY;
    public static final String HANDLE_CFP = "Handle-Cfp";
    public static final String HANDLE_ACCEPT_PROPOSAL = "Handle-Accept-Proposal";
    public static final String HANDLE_REJECT_PROPOSAL = "Handle-Reject-Proposal";
    private boolean proposeSent;

    public SSContractNetResponder(Agent a, ACLMessage cfp) {
        this(a, cfp, new DataStore());
    }

    public SSContractNetResponder(Agent a, ACLMessage cfp, DataStore store) {
        super(a, cfp, store, true);
        this.CFP_KEY = this.INITIATION_KEY;
        this.PROPOSE_KEY = this.REPLY_KEY;
        this.ACCEPT_PROPOSAL_KEY = this.RECEIVED_KEY;
        this.REJECT_PROPOSAL_KEY = this.RECEIVED_KEY;
        this.proposeSent = false;
        this.registerDefaultTransition(HANDLE_CFP, "Send-Reply");
        this.registerTransition("Send-Reply", "Receive-Next", 11);
        this.registerTransition("Receive-Next", HANDLE_REJECT_PROPOSAL, -1001);
        this.registerTransition("Check-In-seq", HANDLE_ACCEPT_PROPOSAL, 0, new String[]{"Send-Reply"});
        this.registerTransition("Check-In-seq", HANDLE_REJECT_PROPOSAL, 15);
        this.registerDefaultTransition(HANDLE_ACCEPT_PROPOSAL, "Send-Reply");
        this.registerDefaultTransition(HANDLE_REJECT_PROPOSAL, "Dummy-Final");
        OneShotBehaviour b = new CfpHandler(this.myAgent);
        this.registerFirstState(b, HANDLE_CFP);
        b.setDataStore(this.getDataStore());
        b = new AcceptHandler(this.myAgent);
        this.registerDSState(b, HANDLE_ACCEPT_PROPOSAL);
        b = new RejectHandler(this.myAgent);
        this.registerDSState(b, HANDLE_REJECT_PROPOSAL);
    }

    protected ACLMessage handleCfp(ACLMessage cfp) throws RefuseException, FailureException, NotUnderstoodException {
        return null;
    }

    protected ACLMessage handleAcceptProposal(ACLMessage cfp, ACLMessage propose, ACLMessage accept) throws FailureException {
        return null;
    }

    protected void handleRejectProposal(ACLMessage cfp, ACLMessage propose, ACLMessage reject) {
    }

    protected void handleOutOfSequence(ACLMessage cfp, ACLMessage propose, ACLMessage msg) {
    }

    public void registerHandleCfp(Behaviour b) {
        this.registerFirstState(b, HANDLE_CFP);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAcceptProposal(Behaviour b) {
        this.registerDSState(b, HANDLE_ACCEPT_PROPOSAL);
    }

    public void registerHandleRejectProposal(Behaviour b) {
        this.registerDSState(b, HANDLE_REJECT_PROPOSAL);
    }

    protected void reinit() {
        this.proposeSent = false;
        this.getDataStore().remove(this.CFP_KEY);
        super.reinit();
    }

    protected void handleOutOfSequence(ACLMessage msg) {
        ACLMessage cfp = (ACLMessage)this.getDataStore().get(this.CFP_KEY);
        ACLMessage propose = (ACLMessage)this.getDataStore().get(this.PROPOSE_KEY);
        this.handleOutOfSequence(cfp, propose, msg);
    }

    protected boolean checkInSequence(ACLMessage received) {
        return received.getPerformative() == 0 || received.getPerformative() == 15;
    }

    protected void beforeReply(ACLMessage reply) {
        if (this.proposeSent) {
            this.forceTransitionTo("Dummy-Final");
        }
    }

    protected void afterReply(ACLMessage reply) {
        if (reply != null && reply.getPerformative() == 11) {
            this.proposeSent = true;
        }
    }

    private static class RejectHandler
    extends OneShotBehaviour {
        private static final long serialVersionUID = 4766407563773003L;

        public RejectHandler(Agent a) {
            super(a);
        }

        public void action() {
            SSContractNetResponder parent = (SSContractNetResponder)this.getParent();
            ACLMessage cfp = (ACLMessage)this.getDataStore().get(parent.CFP_KEY);
            ACLMessage propose = (ACLMessage)this.getDataStore().get(parent.PROPOSE_KEY);
            ACLMessage reject = (ACLMessage)this.getDataStore().get(parent.REJECT_PROPOSAL_KEY);
            parent.handleRejectProposal(cfp, propose, reject);
        }
    }

    private static class AcceptHandler
    extends OneShotBehaviour {
        private static final long serialVersionUID = 4766407563773002L;

        public AcceptHandler(Agent a) {
            super(a);
        }

        public void action() {
            SSContractNetResponder parent = (SSContractNetResponder)this.getParent();
            ACLMessage reply = null;
            try {
                ACLMessage cfp = (ACLMessage)this.getDataStore().get(parent.CFP_KEY);
                ACLMessage propose = (ACLMessage)this.getDataStore().get(parent.PROPOSE_KEY);
                ACLMessage accept = (ACLMessage)this.getDataStore().get(parent.ACCEPT_PROPOSAL_KEY);
                reply = parent.handleAcceptProposal(cfp, propose, accept);
            }
            catch (FIPAException fe) {
                reply = fe.getACLMessage();
            }
            this.getDataStore().put(parent.REPLY_KEY, reply);
        }
    }

    private static class CfpHandler
    extends OneShotBehaviour {
        private static final long serialVersionUID = 4766407563773001L;

        public CfpHandler(Agent a) {
            super(a);
        }

        public void action() {
            SSContractNetResponder parent = (SSContractNetResponder)this.getParent();
            ACLMessage reply = null;
            try {
                reply = parent.handleCfp((ACLMessage)this.getDataStore().get(parent.CFP_KEY));
            }
            catch (FIPAException fe) {
                reply = fe.getACLMessage();
            }
            this.getDataStore().put(parent.REPLY_KEY, reply);
        }
    }
}

