/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ConversationList;
import jade.lang.acl.MessageTemplate;

public abstract class SSResponderDispatcher
extends CyclicBehaviour {
    private ConversationList activeConversations;
    private MessageTemplate template;

    public SSResponderDispatcher(Agent a, MessageTemplate tpl) {
        super(a);
        this.activeConversations = new ConversationList(a);
        this.template = MessageTemplate.and(tpl, this.activeConversations.getMessageTemplate());
    }

    public final void action() {
        ACLMessage msg = this.myAgent.receive(this.template);
        if (msg != null) {
            final String convId = msg.getConversationId();
            if (convId != null) {
                this.activeConversations.registerConversation(convId);
                SequentialBehaviour sb = new SequentialBehaviour(){
                    private static final long serialVersionUID = 12345678L;

                    public int onEnd() {
                        SSResponderDispatcher.this.activeConversations.deregisterConversation(convId);
                        return super.onEnd();
                    }
                };
                sb.setBehaviourName(convId + "-Responder");
                sb.addSubBehaviour(this.createResponder(msg));
                this.myAgent.addBehaviour(sb);
            } else {
                System.out.println("WARNING: Incoming CFP message received with null conversation ID");
            }
        } else {
            this.block();
        }
    }

    protected abstract Behaviour createResponder(ACLMessage var1);
}

